/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.query;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.relations.IRelation;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.query.IQueryMin;
import mb.statix.spec.Rule;

public class QueryMin
implements IQueryMin,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IRelation.Immutable<ITerm> labelOrd;
    private final Rule dataOrd;

    public QueryMin(IRelation.Immutable<ITerm> labelOrd, Rule dataConstraint) {
        this.labelOrd = labelOrd;
        this.dataOrd = dataConstraint;
    }

    @Override
    public IRelation<ITerm> getLabelOrder() {
        return this.labelOrd;
    }

    @Override
    public Rule getDataEquiv() {
        return this.dataOrd;
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.dataOrd.varSet());
        return vars.build();
    }

    @Override
    public IQueryMin apply(ISubstitution.Immutable subst) {
        return new QueryMin(this.labelOrd, this.dataOrd.apply(subst));
    }

    @Override
    public IQueryMin apply(IRenaming subst) {
        return new QueryMin(this.labelOrd, this.dataOrd.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("min ");
        sb.append(this.labelOrd);
        sb.append(" and ");
        sb.append(this.dataOrd.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryMin queryMin = (QueryMin)o;
        return Objects.equals(this.labelOrd, queryMin.labelOrd) && Objects.equals(this.dataOrd, queryMin.dataOrd);
    }

    public int hashCode() {
        return Objects.hash(this.labelOrd, this.dataOrd);
    }
}

