/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.query;

import java.util.Optional;
import mb.nabl2.regexp.IRegExpMatcher;
import mb.nabl2.terms.ITerm;
import mb.statix.scopegraph.reference.LabelWF;
import mb.statix.scopegraph.reference.ResolutionException;

public class RegExpLabelWF
implements LabelWF<ITerm> {
    private final IRegExpMatcher<ITerm> re;

    private RegExpLabelWF(IRegExpMatcher<ITerm> re) {
        this.re = re;
    }

    @Override
    public Optional<LabelWF<ITerm>> step(ITerm l) throws ResolutionException, InterruptedException {
        IRegExpMatcher<ITerm> re = this.re.match(l);
        if (re.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RegExpLabelWF(re));
    }

    @Override
    public boolean accepting() throws ResolutionException, InterruptedException {
        return this.re.isAccepting();
    }

    public String toString() {
        return this.re.toString();
    }

    public static RegExpLabelWF of(IRegExpMatcher<ITerm> re) {
        return new RegExpLabelWF(re);
    }
}

