/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.CExists;
import mb.statix.constraints.Constraints;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.State;
import mb.statix.spec.Rule;
import mb.statix.spec.Spec;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ARule {
    public static final LeftRightOrder leftRightPatternOrdering = new LeftRightOrder();

    @Value.Default
    public String label() {
        return "";
    }

    @Value.Parameter
    public abstract String name();

    @Value.Parameter
    public abstract List<Pattern> params();

    @Value.Lazy
    public Set<ITermVar> paramVars() {
        return (Set)this.params().stream().flatMap(t -> t.getVars().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Value.Parameter
    public abstract IConstraint body();

    @Value.Lazy
    public Optional<Boolean> isAlways(Spec spec) throws InterruptedException {
        IConstraint instBody;
        ImmutableList.Builder argsBuilder = ImmutableList.builder();
        int i = 0;
        while (i < this.params().size()) {
            argsBuilder.add((Object)TermBuild.B.newVar("", "arg" + Integer.toString(i)));
            ++i;
        }
        ImmutableList args = argsBuilder.build();
        try {
            instBody = this.apply((List<? extends ITerm>)args, Unifiers.Immutable.of()).orElse(null);
            if (instBody == null) {
                return Optional.of(false);
            }
        }
        catch (Delay e) {
            return Optional.of(false);
        }
        try {
            CExists constraint = new CExists((Iterable<ITermVar>)args, instBody);
            return Optional.of(Solver.entails(spec, State.of(spec), constraint, (s, l, st) -> true, new NullDebugContext(), new NullProgress(), new NullCancel()));
        }
        catch (Delay d) {
            return Optional.empty();
        }
    }

    public Set<ITermVar> freeVars() {
        return Sets.difference(Constraints.freeVars(this.body()), this.paramVars());
    }

    public Set<ITermVar> varSet() {
        return Sets.union(Constraints.vars(this.body()), this.paramVars());
    }

    public Rule apply(ISubstitution.Immutable subst) {
        IConstraint newBody = this.body().apply(subst.removeAll(this.paramVars()));
        return Rule.of(this.name(), this.params(), newBody);
    }

    public Rule apply(IRenaming subst) {
        List newParams = (List)this.params().stream().map(p -> p.apply(subst)).collect(ImmutableList.toImmutableList());
        IConstraint newBody = this.body().apply(subst);
        return Rule.of(this.name(), newParams, newBody);
    }

    public Optional<IConstraint> apply(List<? extends ITerm> args, IUniDisunifier.Immutable unifier) throws Delay {
        return this.apply(args, unifier, null);
    }

    public Optional<IConstraint> apply(List<? extends ITerm> args, IUniDisunifier.Immutable unifier, @Nullable IConstraint cause) throws Delay {
        Optional<ISubstitution.Immutable> matchResult = TermPattern.P.match(this.params(), args, unifier).orElseThrow(vars -> Delay.ofVars(vars));
        ISubstitution.Transient subst = matchResult.map(u -> u.melt()).orElse(null);
        if (subst == null) {
            return Optional.empty();
        }
        ISubstitution.Immutable isubst = subst.freeze();
        IConstraint newBody = this.body().apply(isubst);
        return Optional.of(newBody.withCause(cause));
    }

    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        if (!this.label().isEmpty()) {
            sb.append("[").append(this.label()).append("] ");
        }
        if (this.name().isEmpty()) {
            sb.append("{ ");
        } else {
            sb.append(this.name()).append("(");
        }
        sb.append(this.params().stream().map(Object::toString).collect(Collectors.joining(", ")));
        if (!this.name().isEmpty()) {
            sb.append(")");
        }
        sb.append(" :- ");
        sb.append(this.body().toString(termToString));
        if (this.name().isEmpty()) {
            sb.append(" }");
        } else {
            sb.append(".");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public static class LeftRightOrder {
        public Optional<Integer> compare(Rule r1, Rule r2) {
            Pattern p1 = TermPattern.P.newTuple((Iterable<? extends Pattern>)r1.params());
            Pattern p2 = TermPattern.P.newTuple((Iterable<? extends Pattern>)r2.params());
            return Pattern.leftRightOrdering.compare(p1, p2);
        }

        public Comparator<Rule> asComparator() {
            return (r1, r2) -> this.compare((Rule)r1, (Rule)r2).orElse(0);
        }
    }
}

