/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.spec.AApplyResult;

public final class ApplyResult
extends AApplyResult
implements Serializable {
    private final IState.Immutable state;
    private final IUnifier.Immutable diff;
    private final Diseq guard;
    private final IConstraint body;
    private static final long serialVersionUID = 42L;

    private ApplyResult(IState.Immutable state, IUnifier.Immutable diff, Optional<? extends Diseq> guard, IConstraint body) {
        this.state = Objects.requireNonNull(state, "state");
        this.diff = Objects.requireNonNull(diff, "diff");
        this.guard = guard.orElse(null);
        this.body = Objects.requireNonNull(body, "body");
    }

    private ApplyResult(ApplyResult original, IState.Immutable state, IUnifier.Immutable diff, Diseq guard, IConstraint body) {
        this.state = state;
        this.diff = diff;
        this.guard = guard;
        this.body = body;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    @Override
    public IUnifier.Immutable diff() {
        return this.diff;
    }

    @Override
    public Optional<Diseq> guard() {
        return Optional.ofNullable(this.guard);
    }

    @Override
    public IConstraint body() {
        return this.body;
    }

    public final ApplyResult withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new ApplyResult(this, newValue, this.diff, this.guard, this.body);
    }

    public final ApplyResult withDiff(IUnifier.Immutable value) {
        if (this.diff == value) {
            return this;
        }
        IUnifier.Immutable newValue = Objects.requireNonNull(value, "diff");
        return new ApplyResult(this, this.state, newValue, this.guard, this.body);
    }

    public final ApplyResult withGuard(Diseq value) {
        Diseq newValue = Objects.requireNonNull(value, "guard");
        if (this.guard == newValue) {
            return this;
        }
        return new ApplyResult(this, this.state, this.diff, newValue, this.body);
    }

    public final ApplyResult withGuard(Optional<? extends Diseq> optional) {
        Diseq value = optional.orElse(null);
        if (this.guard == value) {
            return this;
        }
        return new ApplyResult(this, this.state, this.diff, value, this.body);
    }

    public final ApplyResult withBody(IConstraint value) {
        if (this.body == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "body");
        return new ApplyResult(this, this.state, this.diff, this.guard, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplyResult && this.equalTo((ApplyResult)another);
    }

    private boolean equalTo(ApplyResult another) {
        return this.state.equals(another.state) && this.diff.equals(another.diff) && Objects.equals(this.guard, another.guard) && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.diff.hashCode();
        h += (h << 5) + Objects.hashCode(this.guard);
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ApplyResult").omitNullValues().add("state", (Object)this.state).add("diff", (Object)this.diff).add("guard", (Object)this.guard).add("body", (Object)this.body).toString();
    }

    public static ApplyResult of(IState.Immutable state, IUnifier.Immutable diff, Optional<? extends Diseq> guard, IConstraint body) {
        return new ApplyResult(state, diff, guard, body);
    }

    public static ApplyResult copyOf(AApplyResult instance) {
        if (instance instanceof ApplyResult) {
            return (ApplyResult)instance;
        }
        return ApplyResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ApplyResult(ApplyResult applyResult, IState.Immutable immutable, IUnifier.Immutable immutable2, Diseq diseq, IConstraint iConstraint, ApplyResult applyResult2) {
        this(applyResult, immutable, immutable2, diseq, iConstraint);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private static final long INIT_BIT_DIFF = 2L;
        private static final long INIT_BIT_BODY = 4L;
        private long initBits = 7L;
        private IState.Immutable state;
        private IUnifier.Immutable diff;
        private Diseq guard;
        private IConstraint body;

        private Builder() {
        }

        public final Builder from(AApplyResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            this.diff(instance.diff());
            Optional<Diseq> guardOptional = instance.guard();
            if (guardOptional.isPresent()) {
                this.guard(guardOptional);
            }
            this.body(instance.body());
            return this;
        }

        public final Builder state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder diff(IUnifier.Immutable diff) {
            this.diff = Objects.requireNonNull(diff, "diff");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder guard(Diseq guard) {
            this.guard = Objects.requireNonNull(guard, "guard");
            return this;
        }

        public final Builder guard(Optional<? extends Diseq> guard) {
            this.guard = guard.orElse(null);
            return this;
        }

        public final Builder body(IConstraint body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ApplyResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplyResult(null, this.state, this.diff, this.guard, this.body, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("diff");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build ApplyResult, some of required attributes are not set " + attributes;
        }
    }
}

