/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.Renaming;

public class FreshVars {
    private final Set.Transient<ITermVar> oldVars = Set.Transient.of();
    private Set.Transient<ITermVar> newVars = Set.Transient.of();

    public FreshVars() {
    }

    public FreshVars(Iterable<ITermVar> oldVars) {
        this();
        oldVars.forEach(arg_0 -> this.oldVars.__insert(arg_0));
    }

    public ITermVar fresh(String name) {
        String base = name.replaceAll("-?[0-9]*$", "");
        ITermVar fresh = TermBuild.B.newVar("", name);
        int i = 0;
        while (this.oldVars.contains((Object)fresh) || this.newVars.contains((Object)fresh)) {
            fresh = TermBuild.B.newVar("", String.valueOf(base) + "-" + i++);
        }
        this.newVars.__insert((Object)fresh);
        return fresh;
    }

    public IRenaming fresh(Set<ITermVar> vars) {
        Renaming.Builder renaming = Renaming.builder();
        for (ITermVar var : vars) {
            String base = var.getName().replaceAll("-?[0-9]*$", "");
            ITermVar fresh = var;
            int i = 0;
            while (vars.contains(fresh) && !var.equals(fresh) || this.oldVars.contains((Object)fresh) || this.newVars.contains((Object)fresh)) {
                fresh = TermBuild.B.newVar(var.getResource(), String.valueOf(base) + "-" + i++);
            }
            this.newVars.__insert((Object)fresh);
            renaming.put(var, fresh);
            renaming.put(fresh, var);
        }
        return renaming.build();
    }

    public Set.Immutable<ITermVar> fix() {
        Set.Immutable fixedVars = this.newVars.freeze();
        this.oldVars.__insertAll((Set)fixedVars);
        this.newVars = Set.Transient.of();
        return fixedVars;
    }

    public Set.Immutable<ITermVar> reset() {
        Set.Immutable resetVars = this.newVars.freeze();
        this.newVars = Set.Transient.of();
        return resetVars;
    }
}

