/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.Pattern;
import mb.statix.solver.IConstraint;
import mb.statix.spec.ARule;

public final class Rule
extends ARule
implements Serializable {
    private final String label;
    private final String name;
    private final ImmutableList<Pattern> params;
    private final IConstraint body;
    private volatile transient long lazyInitBitmap;
    private static final long PARAM_VARS_LAZY_INIT_BIT = 1L;
    private transient Set<ITermVar> paramVars;
    private static final long serialVersionUID = 42L;

    private Rule(String name, Iterable<? extends Pattern> params, IConstraint body) {
        this.name = Objects.requireNonNull(name, "name");
        this.params = ImmutableList.copyOf(params);
        this.body = Objects.requireNonNull(body, "body");
        this.label = Objects.requireNonNull(super.label(), "label");
    }

    private Rule(Builder builder) {
        this.name = builder.name;
        this.params = builder.params.build();
        this.body = builder.body;
        this.label = builder.label != null ? builder.label : Objects.requireNonNull(super.label(), "label");
    }

    private Rule(String label, String name, ImmutableList<Pattern> params, IConstraint body) {
        this.label = label;
        this.name = name;
        this.params = params;
        this.body = body;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String name() {
        return this.name;
    }

    public ImmutableList<Pattern> params() {
        return this.params;
    }

    @Override
    public IConstraint body() {
        return this.body;
    }

    public final Rule withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new Rule(newValue, this.name, this.params, this.body);
    }

    public final Rule withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Rule(this.label, newValue, this.params, this.body);
    }

    public final Rule withParams(Pattern ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Rule(this.label, this.name, (ImmutableList<Pattern>)newValue, this.body);
    }

    public final Rule withParams(Iterable<? extends Pattern> elements) {
        if (this.params == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Rule(this.label, this.name, (ImmutableList<Pattern>)newValue, this.body);
    }

    public final Rule withBody(IConstraint value) {
        if (this.body == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "body");
        return new Rule(this.label, this.name, this.params, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Rule && this.equalTo((Rule)another);
    }

    private boolean equalTo(Rule another) {
        return this.label.equals(another.label) && this.name.equals(another.name) && this.params.equals(another.params) && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.params.hashCode();
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ITermVar> paramVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Rule rule = this;
            synchronized (rule) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.paramVars = Objects.requireNonNull(super.paramVars(), "paramVars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.paramVars;
    }

    public static Rule of(String name, List<Pattern> params, IConstraint body) {
        return Rule.of(name, params, body);
    }

    public static Rule of(String name, Iterable<? extends Pattern> params, IConstraint body) {
        return new Rule(name, params, body);
    }

    public static Rule copyOf(ARule instance) {
        if (instance instanceof Rule) {
            return (Rule)instance;
        }
        return Rule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Rule(Builder builder, Rule rule) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_BODY = 2L;
        private long initBits = 3L;
        private String label;
        private String name;
        private ImmutableList.Builder<Pattern> params = ImmutableList.builder();
        private IConstraint body;

        private Builder() {
        }

        public final Builder from(ARule instance) {
            Objects.requireNonNull(instance, "instance");
            this.label(instance.label());
            this.name(instance.name());
            this.addAllParams(instance.params());
            this.body(instance.body());
            return this;
        }

        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParams(Pattern element) {
            this.params.add((Object)element);
            return this;
        }

        public final Builder addParams(Pattern ... elements) {
            this.params.add((Object[])elements);
            return this;
        }

        public final Builder params(Iterable<? extends Pattern> elements) {
            this.params = ImmutableList.builder();
            return this.addAllParams(elements);
        }

        public final Builder addAllParams(Iterable<? extends Pattern> elements) {
            this.params.addAll(elements);
            return this;
        }

        public final Builder body(IConstraint body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Rule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Rule(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build Rule, some of required attributes are not set " + attributes;
        }
    }
}

