/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.regexp.IAlphabet;
import mb.nabl2.terms.ITerm;
import mb.nabl2.util.Tuple2;
import mb.statix.spec.ASpec;
import mb.statix.spec.RuleSet;

public final class Spec
extends ASpec
implements Serializable {
    private final RuleSet rules;
    private final ImmutableSet<ITerm> edgeLabels;
    private final ImmutableSet<ITerm> relationLabels;
    private final ITerm noRelationLabel;
    private final IAlphabet<ITerm> labels;
    private final ImmutableSetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions;
    private static final long serialVersionUID = 42L;

    private Spec(RuleSet rules, Iterable<? extends ITerm> edgeLabels, Iterable<? extends ITerm> relationLabels, ITerm noRelationLabel, IAlphabet<ITerm> labels, Multimap<String, ? extends Tuple2<Integer, ITerm>> scopeExtensions) {
        this.rules = Objects.requireNonNull(rules, "rules");
        this.edgeLabels = ImmutableSet.copyOf(edgeLabels);
        this.relationLabels = ImmutableSet.copyOf(relationLabels);
        this.noRelationLabel = Objects.requireNonNull(noRelationLabel, "noRelationLabel");
        this.labels = Objects.requireNonNull(labels, "labels");
        this.scopeExtensions = ImmutableSetMultimap.copyOf(scopeExtensions);
    }

    private Spec(Spec original, RuleSet rules, ImmutableSet<ITerm> edgeLabels, ImmutableSet<ITerm> relationLabels, ITerm noRelationLabel, IAlphabet<ITerm> labels, ImmutableSetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        this.rules = rules;
        this.edgeLabels = edgeLabels;
        this.relationLabels = relationLabels;
        this.noRelationLabel = noRelationLabel;
        this.labels = labels;
        this.scopeExtensions = scopeExtensions;
    }

    @Override
    public RuleSet rules() {
        return this.rules;
    }

    public ImmutableSet<ITerm> edgeLabels() {
        return this.edgeLabels;
    }

    public ImmutableSet<ITerm> relationLabels() {
        return this.relationLabels;
    }

    @Override
    public ITerm noRelationLabel() {
        return this.noRelationLabel;
    }

    @Override
    public IAlphabet<ITerm> labels() {
        return this.labels;
    }

    public ImmutableSetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions() {
        return this.scopeExtensions;
    }

    public final Spec withRules(RuleSet value) {
        if (this.rules == value) {
            return this;
        }
        RuleSet newValue = Objects.requireNonNull(value, "rules");
        return new Spec(this, newValue, this.edgeLabels, this.relationLabels, this.noRelationLabel, this.labels, this.scopeExtensions);
    }

    public final Spec withEdgeLabels(ITerm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new Spec(this, this.rules, (ImmutableSet<ITerm>)newValue, this.relationLabels, this.noRelationLabel, this.labels, this.scopeExtensions);
    }

    public final Spec withEdgeLabels(Iterable<? extends ITerm> elements) {
        if (this.edgeLabels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new Spec(this, this.rules, (ImmutableSet<ITerm>)newValue, this.relationLabels, this.noRelationLabel, this.labels, this.scopeExtensions);
    }

    public final Spec withRelationLabels(ITerm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new Spec(this, this.rules, this.edgeLabels, (ImmutableSet<ITerm>)newValue, this.noRelationLabel, this.labels, this.scopeExtensions);
    }

    public final Spec withRelationLabels(Iterable<? extends ITerm> elements) {
        if (this.relationLabels == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new Spec(this, this.rules, this.edgeLabels, (ImmutableSet<ITerm>)newValue, this.noRelationLabel, this.labels, this.scopeExtensions);
    }

    public final Spec withNoRelationLabel(ITerm value) {
        if (this.noRelationLabel == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "noRelationLabel");
        return new Spec(this, this.rules, this.edgeLabels, this.relationLabels, newValue, this.labels, this.scopeExtensions);
    }

    public final Spec withLabels(IAlphabet<ITerm> value) {
        if (this.labels == value) {
            return this;
        }
        IAlphabet<ITerm> newValue = Objects.requireNonNull(value, "labels");
        return new Spec(this, this.rules, this.edgeLabels, this.relationLabels, this.noRelationLabel, newValue, this.scopeExtensions);
    }

    public final Spec withScopeExtensions(Multimap<String, ? extends Tuple2<Integer, ITerm>> entries) {
        if (this.scopeExtensions == entries) {
            return this;
        }
        ImmutableSetMultimap newValue = ImmutableSetMultimap.copyOf(entries);
        return new Spec(this, this.rules, this.edgeLabels, this.relationLabels, this.noRelationLabel, this.labels, (ImmutableSetMultimap<String, Tuple2<Integer, ITerm>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Spec && this.equalTo((Spec)another);
    }

    private boolean equalTo(Spec another) {
        return this.rules.equals(another.rules) && this.edgeLabels.equals(another.edgeLabels) && this.relationLabels.equals(another.relationLabels) && this.noRelationLabel.equals(another.noRelationLabel) && this.labels.equals(another.labels) && this.scopeExtensions.equals(another.scopeExtensions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + this.edgeLabels.hashCode();
        h += (h << 5) + this.relationLabels.hashCode();
        h += (h << 5) + this.noRelationLabel.hashCode();
        h += (h << 5) + this.labels.hashCode();
        h += (h << 5) + this.scopeExtensions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Spec").omitNullValues().add("rules", (Object)this.rules).add("edgeLabels", this.edgeLabels).add("relationLabels", this.relationLabels).add("noRelationLabel", (Object)this.noRelationLabel).add("labels", this.labels).add("scopeExtensions", this.scopeExtensions).toString();
    }

    public static Spec of(RuleSet rules, Set<ITerm> edgeLabels, Set<ITerm> relationLabels, ITerm noRelationLabel, IAlphabet<ITerm> labels, SetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        return Spec.of(rules, edgeLabels, relationLabels, noRelationLabel, labels, scopeExtensions);
    }

    public static Spec of(RuleSet rules, Iterable<? extends ITerm> edgeLabels, Iterable<? extends ITerm> relationLabels, ITerm noRelationLabel, IAlphabet<ITerm> labels, Multimap<String, ? extends Tuple2<Integer, ITerm>> scopeExtensions) {
        return new Spec(rules, edgeLabels, relationLabels, noRelationLabel, labels, scopeExtensions);
    }

    public static Spec copyOf(ASpec instance) {
        if (instance instanceof Spec) {
            return (Spec)instance;
        }
        return Spec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Spec(Spec spec, RuleSet ruleSet, ImmutableSet immutableSet, ImmutableSet immutableSet2, ITerm iTerm, IAlphabet iAlphabet, ImmutableSetMultimap immutableSetMultimap, Spec spec2) {
        this(spec, ruleSet, (ImmutableSet<ITerm>)immutableSet, (ImmutableSet<ITerm>)immutableSet2, iTerm, iAlphabet, (ImmutableSetMultimap<String, Tuple2<Integer, ITerm>>)immutableSetMultimap);
    }

    public static final class Builder {
        private static final long INIT_BIT_RULES = 1L;
        private static final long INIT_BIT_NO_RELATION_LABEL = 2L;
        private static final long INIT_BIT_LABELS = 4L;
        private long initBits = 7L;
        private RuleSet rules;
        private ImmutableSet.Builder<ITerm> edgeLabels = ImmutableSet.builder();
        private ImmutableSet.Builder<ITerm> relationLabels = ImmutableSet.builder();
        private ITerm noRelationLabel;
        private IAlphabet<ITerm> labels;
        private ImmutableSetMultimap.Builder<String, Tuple2<Integer, ITerm>> scopeExtensions = ImmutableSetMultimap.builder();

        private Builder() {
        }

        public final Builder from(ASpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.rules(instance.rules());
            this.addAllEdgeLabels(instance.edgeLabels());
            this.addAllRelationLabels(instance.relationLabels());
            this.noRelationLabel(instance.noRelationLabel());
            this.labels(instance.labels());
            this.putAllScopeExtensions((Multimap<String, ? extends Tuple2<Integer, ITerm>>)instance.scopeExtensions());
            return this;
        }

        public final Builder rules(RuleSet rules) {
            this.rules = Objects.requireNonNull(rules, "rules");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEdgeLabels(ITerm element) {
            this.edgeLabels.add((Object)element);
            return this;
        }

        public final Builder addEdgeLabels(ITerm ... elements) {
            this.edgeLabels.add((Object[])elements);
            return this;
        }

        public final Builder edgeLabels(Iterable<? extends ITerm> elements) {
            this.edgeLabels = ImmutableSet.builder();
            return this.addAllEdgeLabels(elements);
        }

        public final Builder addAllEdgeLabels(Iterable<? extends ITerm> elements) {
            this.edgeLabels.addAll(elements);
            return this;
        }

        public final Builder addRelationLabels(ITerm element) {
            this.relationLabels.add((Object)element);
            return this;
        }

        public final Builder addRelationLabels(ITerm ... elements) {
            this.relationLabels.add((Object[])elements);
            return this;
        }

        public final Builder relationLabels(Iterable<? extends ITerm> elements) {
            this.relationLabels = ImmutableSet.builder();
            return this.addAllRelationLabels(elements);
        }

        public final Builder addAllRelationLabels(Iterable<? extends ITerm> elements) {
            this.relationLabels.addAll(elements);
            return this;
        }

        public final Builder noRelationLabel(ITerm noRelationLabel) {
            this.noRelationLabel = Objects.requireNonNull(noRelationLabel, "noRelationLabel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder labels(IAlphabet<ITerm> labels) {
            this.labels = Objects.requireNonNull(labels, "labels");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putScopeExtensions(String key, Tuple2<Integer, ITerm> ... values) {
            this.scopeExtensions.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        public final Builder putAllScopeExtensions(String key, Iterable<Tuple2<Integer, ITerm>> values) {
            this.scopeExtensions.putAll((Object)key, values);
            return this;
        }

        public final Builder putScopeExtensions(String key, Tuple2<Integer, ITerm> value) {
            this.scopeExtensions.put((Object)key, value);
            return this;
        }

        public final Builder putScopeExtensions(Map.Entry<String, ? extends Tuple2<Integer, ITerm>> entry) {
            this.scopeExtensions.put(entry);
            return this;
        }

        public final Builder scopeExtensions(Multimap<String, ? extends Tuple2<Integer, ITerm>> entries) {
            this.scopeExtensions = ImmutableSetMultimap.builder();
            return this.putAllScopeExtensions(entries);
        }

        public final Builder putAllScopeExtensions(Multimap<String, ? extends Tuple2<Integer, ITerm>> entries) {
            this.scopeExtensions.putAll(entries);
            return this;
        }

        public Spec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Spec(null, this.rules, this.edgeLabels.build(), this.relationLabels.build(), this.noRelationLabel, this.labels, this.scopeExtensions.build(), null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rules");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("noRelationLabel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("labels");
            }
            return "Cannot build Spec, some of required attributes are not set " + attributes;
        }
    }
}

