/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.scopegraph.IScopeGraph;
import mb.statix.scopegraph.terms.Scope;
import mb.statix.solver.IState;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_debug_scopegraph
extends StatixPrimitive {
    @Inject
    public STX_debug_scopegraph() {
        super(STX_debug_scopegraph.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult analysis = TermMatch.M.blobValue(SolverResult.class).match(term).orElseThrow(() -> new InterpreterException("Expected solver result."));
        IState.Immutable state = analysis.state();
        IScopeGraph scopeGraph = state.scopeGraph();
        IUniDisunifier.Immutable unifier = state.unifier();
        HashMap edgeEntries = Maps.newHashMap();
        scopeGraph.getEdges().forEach((src_lbl, tgt) -> {
            ITerm lbl_tgt = TermBuild.B.newTuple((ITerm)src_lbl.getValue(), TermBuild.B.newList(StatixTerms.explicate(tgt)));
            edgeEntries.computeIfAbsent((Scope)src_lbl.getKey(), s -> Lists.newArrayList()).add(lbl_tgt);
        });
        HashMap dataEntries = Maps.newHashMap();
        scopeGraph.getData().forEach((s_lbl, ds) -> {
            List ds2 = Streams.stream((Iterable)ds).map(unifier::findRecursive).collect(Collectors.toList());
            ITerm lbl_ds = TermBuild.B.newTuple((ITerm)s_lbl.getValue(), TermBuild.B.newList(StatixTerms.explicate(ds2)));
            dataEntries.computeIfAbsent((Scope)s_lbl.getKey(), s -> Lists.newArrayList()).add(lbl_ds);
        });
        ArrayList scopeEntries = Lists.newArrayList();
        for (Scope scope : state.scopes()) {
            scopeEntries.add(TermBuild.B.newTuple(StatixTerms.explicate(scope), TermBuild.B.newList((Iterable)dataEntries.getOrDefault(scope, ImmutableList.of())), TermBuild.B.newList((Iterable)edgeEntries.getOrDefault(scope, ImmutableList.of()))));
        }
        return Optional.of(TermBuild.B.newList(scopeEntries));
    }
}

