/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_extract_messages
extends StatixPrimitive {
    @Inject
    public STX_extract_messages() {
        super(STX_extract_messages.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult result = TermMatch.M.blobValue(SolverResult.class).match(term).orElseThrow(() -> new InterpreterException("Expected solver result."));
        IUniDisunifier.Immutable unifier = result.state().unifier();
        ArrayList errorList = Lists.newArrayList();
        ArrayList warningList = Lists.newArrayList();
        ArrayList noteList = Lists.newArrayList();
        result.messages().forEach((c, m) -> this.addMessage((IMessage)m, (IConstraint)c, unifier, errorList, warningList, noteList));
        IListTerm errors = TermBuild.B.newList(errorList);
        IListTerm warnings = TermBuild.B.newList(warningList);
        IListTerm notes = TermBuild.B.newList(noteList);
        ITerm resultTerm = TermBuild.B.newTuple(errors, warnings, notes);
        return Optional.of(resultTerm);
    }
}

