/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.util.Tuple2;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_get_ast_property
extends StatixPrimitive {
    @Inject
    public STX_get_ast_property() {
        super(STX_get_ast_property.class.getSimpleName(), 2);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult analysis = TermMatch.M.blobValue(SolverResult.class).match(terms.get(0)).orElseThrow(() -> new InterpreterException("Expected solver result."));
        ITerm prop = terms.get(1);
        Optional<TermIndex> maybeIndex = TermIndex.get(term);
        if (maybeIndex.isPresent()) {
            ITerm result;
            TermIndex index = maybeIndex.get();
            Tuple2<TermIndex, ITerm> key = Tuple2.of(index, prop);
            if (!analysis.state().termProperties().containsKey(key)) {
                return Optional.empty();
            }
            ITermProperty property = (ITermProperty)analysis.state().termProperties().get(key);
            switch (property.multiplicity()) {
                case BAG: {
                    result = TermBuild.B.newList((Iterable)Streams.stream(property.values()).map(analysis.state().unifier()::findRecursive).collect(ImmutableList.toImmutableList()));
                    break;
                }
                case SINGLETON: {
                    result = analysis.state().unifier().findRecursive(property.value());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown multiplicity " + (Object)((Object)property.multiplicity()));
                }
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

