/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_solve_constraint
extends StatixPrimitive {
    @Inject
    public STX_solve_constraint() {
        super(STX_solve_constraint.class.getSimpleName(), 4);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        ITerm specTerm = terms.get(0);
        Spec spec = StatixTerms.spec().match(specTerm).orElseThrow(() -> new InterpreterException("Expected spec, got " + specTerm));
        this.reportOverlappingRules(spec);
        IDebugContext debug = this.getDebugContext(terms.get(1));
        IProgress progress = this.getProgress(terms.get(2));
        ICancel cancel = this.getCancel(terms.get(3));
        Function1<IConstraint, ITerm> solveConstraint = constraint -> this.solveConstraint(spec, (IConstraint)constraint, debug, progress, cancel);
        TermMatch.IMatcher[] iMatcherArray = new TermMatch.IMatcher[2];
        iMatcherArray[0] = StatixTerms.constraint().map(solveConstraint::apply);
        iMatcherArray[1] = TermMatch.M.listElems(StatixTerms.constraint()).map(vars_constraints -> TermBuild.B.newList((Iterable)((Stream)vars_constraints.stream().parallel()).map(solveConstraint::apply).collect(ImmutableList.toImmutableList())));
        return TermMatch.M.cases(iMatcherArray).match(term);
    }

    private ITerm solveConstraint(Spec spec, IConstraint constraint, IDebugContext debug, IProgress progress, ICancel cancel) {
        SolverResult resultConfig;
        State state = State.of(spec);
        try {
            resultConfig = Solver.solve(spec, state, constraint, debug, progress, cancel);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        IListTerm substTerm = StatixTerms.explicateMapEntries((Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>>)resultConfig.existentials().entrySet(), resultConfig.state().unifier());
        IBlobTerm solverTerm = TermBuild.B.newBlob(resultConfig);
        IApplTerm resultTerm = TermBuild.B.newAppl("Solution", substTerm, solverTerm);
        return resultTerm;
    }
}

