/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.regexp.IRegExp;
import mb.nabl2.regexp.IRegExpBuilder;
import mb.nabl2.regexp.impl.FiniteAlphabet;
import mb.nabl2.regexp.impl.RegExpBuilder;
import mb.nabl2.relations.IRelation;
import mb.nabl2.relations.RelationDescription;
import mb.nabl2.relations.RelationException;
import mb.nabl2.relations.impl.Relation;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.Tuple2;
import mb.statix.arithmetic.ArithExpr;
import mb.statix.arithmetic.ArithTerms;
import mb.statix.arithmetic.ArithTest;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTellRel;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.IMessagePart;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.TermPart;
import mb.statix.constraints.messages.TextPart;
import mb.statix.scopegraph.path.IResolutionPath;
import mb.statix.scopegraph.path.IScopePath;
import mb.statix.scopegraph.path.IStep;
import mb.statix.scopegraph.terms.Scope;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.IQueryFilter;
import mb.statix.solver.query.IQueryMin;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleSet;
import mb.statix.spec.Spec;
import org.metaborg.util.Ref;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class StatixTerms {
    private static final ILogger log = LoggerUtils.logger(StatixTerms.class);
    public static final String SCOPE_OP = "Scope";
    public static final String TERMINDEX_OP = "TermIndex";
    public static final String OCCURRENCE_OP = "StxOccurrence";
    public static final String PATH_EMPTY_OP = "PathEmpty";
    public static final String PATH_STEP_OP = "PathStep";
    public static final String WITHID_OP = "WithId";
    public static final String NOID_OP = "NoId";

    public static TermMatch.IMatcher<Spec> spec() {
        return TermMatch.M.appl5("Spec", TermMatch.M.req(StatixTerms.labels()), TermMatch.M.req(StatixTerms.labels()), TermMatch.M.term(), StatixTerms.rules(), TermMatch.M.req(StatixTerms.scopeExtensions()), (t, edgeLabels, relationLabels, noRelationLabel, rules, ext) -> {
            FiniteAlphabet<ITerm> labels = new FiniteAlphabet<ITerm>(Iterables2.cons(noRelationLabel, Iterables.concat((Iterable)relationLabels, (Iterable)edgeLabels)));
            return Spec.of(rules, edgeLabels, relationLabels, noRelationLabel, labels, (Multimap<String, ? extends Tuple2<Integer, ITerm>>)ext);
        });
    }

    public static TermMatch.IMatcher<RuleSet> rules() {
        return TermMatch.M.listElems(TermMatch.M.req(StatixTerms.rule())).map(RuleSet::of);
    }

    public static TermMatch.IMatcher<Rule> rule() {
        return TermMatch.M.cases(TermMatch.M.appl3("Rule", StatixTerms.ruleName(), StatixTerms.head(), StatixTerms.constraint(), (r, n, h, bc) -> Rule.of((String)h._1(), (List)h._2(), bc).withLabel((String)n)), TermMatch.M.appl4("Rule", StatixTerms.ruleName(), StatixTerms.head(), TermMatch.M.listElems(StatixTerms.varTerm()), StatixTerms.constraint(), (r, n, h, bvs, bc) -> {
            log.warn("Rules with explicit local variables are deprecated.");
            return Rule.of((String)h._1(), (List)h._2(), (IConstraint)new CExists((Iterable<ITermVar>)bvs, (IConstraint)bc)).withLabel((String)n);
        }));
    }

    public static TermMatch.IMatcher<String> ruleName() {
        return TermMatch.M.cases(TermMatch.M.appl0("NoName", t -> ""), TermMatch.M.appl1("Name", TermMatch.M.stringValue(), (t, n) -> n));
    }

    public static TermMatch.IMatcher<Tuple2<String, List<Pattern>>> head() {
        return TermMatch.M.appl2("C", StatixTerms.constraintName(), TermMatch.M.listElems(StatixTerms.pattern()), (h, name, patterns) -> Tuple2.of(name, patterns));
    }

    public static TermMatch.IMatcher<IConstraint> constraint() {
        return (t, u) -> TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl4("CArith", ArithTerms.matchExpr(), ArithTerms.matchTest(), ArithTerms.matchExpr(), StatixTerms.message(), (c, ae1, op, ae2, msg) -> new CArith((ArithExpr)ae1, (ArithTest)op, (ArithExpr)ae2, msg.orElse(null))), TermMatch.M.appl2("CAstId", StatixTerms.term(), StatixTerms.term(), (c, t1, t2) -> new CAstId((ITerm)t1, (ITerm)t2)), TermMatch.M.appl4("CAstProperty", StatixTerms.term(), StatixTerms.label(), StatixTerms.propertyOp(), StatixTerms.term(), (c, idTerm, property, op, valueTerm) -> new CAstProperty((ITerm)idTerm, (ITerm)property, (CAstProperty.Op)((Object)((Object)((Object)op))), (ITerm)valueTerm)), TermMatch.M.appl2("CConj", m, m, (c, c1, c2) -> new CConj((IConstraint)c1, (IConstraint)c2)), TermMatch.M.appl3("CEqual", StatixTerms.term(), StatixTerms.term(), StatixTerms.message(), (c, t1, t2, msg) -> new CEqual((ITerm)t1, (ITerm)t2, msg.orElse(null))), TermMatch.M.appl2("CExists", TermMatch.M.listElems(StatixTerms.varTerm()), StatixTerms.constraint(), (c, vs, body) -> new CExists((Iterable<ITermVar>)vs, (IConstraint)body)), TermMatch.M.appl1("CFalse", StatixTerms.message(), (c, msg) -> new CFalse(msg.orElse(null))), TermMatch.M.appl3("CInequal", StatixTerms.term(), StatixTerms.term(), StatixTerms.message(), (c, t1, t2, msg) -> new CInequal((Iterable<ITermVar>)ImmutableSet.of(), (ITerm)t1, (ITerm)t2, msg.orElse(null))), TermMatch.M.appl1("CNew", TermMatch.M.listElems(StatixTerms.term()), (c, ts) -> new CNew((Iterable<ITerm>)ts)), TermMatch.M.appl6("CResolveQuery", TermMatch.M.term(), StatixTerms.queryFilter(), StatixTerms.queryMin(), StatixTerms.term(), StatixTerms.term(), StatixTerms.message(), (c, rel, filter, min2, scope, result, msg) -> new CResolveQuery((ITerm)rel, (IQueryFilter)filter, (IQueryMin)min2, (ITerm)scope, (ITerm)result, msg.orElse(null))), TermMatch.M.appl3("CTellEdge", StatixTerms.term(), StatixTerms.label(), StatixTerms.term(), (c, sourceScope, label, targetScope) -> new CTellEdge((ITerm)sourceScope, (ITerm)label, (ITerm)targetScope)), TermMatch.M.appl3("CTellRel", StatixTerms.label(), TermMatch.M.listElems(StatixTerms.term()), StatixTerms.term(), (c, rel, args, scope) -> new CTellRel((ITerm)scope, (ITerm)rel, TermBuild.B.newTuple((Iterable<? extends ITerm>)args, c.getAttachments()))), TermMatch.M.appl0("CTrue", c -> new CTrue()), TermMatch.M.appl2("CTry", StatixTerms.constraint(), StatixTerms.message(), (c, body, msg) -> new CTry((IConstraint)body, msg.orElse(null))), TermMatch.M.appl3("C", StatixTerms.constraintName(), TermMatch.M.listElems(StatixTerms.term()), StatixTerms.message(), (c, name, args, msg) -> new CUser((String)name, (Iterable<? extends ITerm>)args, msg.orElse(null))))).match(t, u);
    }

    private static TermMatch.IMatcher<String> constraintName() {
        return TermMatch.M.stringValue();
    }

    public static TermMatch.IMatcher<IQueryFilter> queryFilter() {
        return TermMatch.M.appl2("Filter", StatixTerms.labelRE(new RegExpBuilder<ITerm>()), StatixTerms.hoconstraint(), (f, wf, dataConstraint) -> new QueryFilter((IRegExp<ITerm>)wf, (Rule)dataConstraint));
    }

    public static TermMatch.IMatcher<IQueryMin> queryMin() {
        return TermMatch.M.appl2("Min", StatixTerms.labelLt(), StatixTerms.hoconstraint(), (m, ord, dataConstraint) -> new QueryMin((IRelation.Immutable<ITerm>)ord, (Rule)dataConstraint));
    }

    public static TermMatch.IMatcher<Rule> hoconstraint() {
        return TermMatch.M.cases(TermMatch.M.appl2("LLam", TermMatch.M.listElems(StatixTerms.pattern()), StatixTerms.constraint(), (t, ps, c) -> Rule.of("", ps, c)), TermMatch.M.appl3("LLam", TermMatch.M.listElems(StatixTerms.pattern()), TermMatch.M.listElems(StatixTerms.varTerm()), StatixTerms.constraint(), (t, ps, vs, c) -> {
            log.warn("Lambdas with explicit local variables are deprecated.");
            return Rule.of("", ps, (IConstraint)new CExists((Iterable<ITermVar>)vs, (IConstraint)c));
        }));
    }

    public static TermMatch.IMatcher<Multimap<String, Tuple2<Integer, ITerm>>> scopeExtensions() {
        return TermMatch.M.listElems(StatixTerms.scopeExtension(), (t, exts) -> {
            ImmutableMultimap.Builder extmap = ImmutableMultimap.builder();
            exts.forEach(ext -> {
                ImmutableMultimap.Builder builder2 = ext.apply((arg_0, arg_1) -> ((ImmutableMultimap.Builder)extmap).put(arg_0, arg_1));
            });
            return extmap.build();
        });
    }

    public static TermMatch.IMatcher<Tuple2<String, Tuple2<Integer, ITerm>>> scopeExtension() {
        return TermMatch.M.tuple3(TermMatch.M.stringValue(), TermMatch.M.integerValue(), TermMatch.M.term(), (t, c, i, lbl) -> Tuple2.of(c, Tuple2.of(i - 1, lbl)));
    }

    public static TermMatch.IMatcher<List<ITerm>> labels() {
        return TermMatch.M.listElems(StatixTerms.label());
    }

    public static TermMatch.IMatcher<ITerm> label() {
        return TermMatch.M.term();
    }

    private static TermMatch.IMatcher<IRegExp<ITerm>> labelRE(IRegExpBuilder<ITerm> builder) {
        return TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl0("Empty", t -> (IRegExp)builder.emptySet()), TermMatch.M.appl0("Epsilon", t -> (IRegExp)builder.emptyString()), TermMatch.M.appl1("Closure", m, (t, re) -> (IRegExp)builder.closure((IRegExp<ITerm>)re)), TermMatch.M.appl1("Neg", m, (t, re) -> (IRegExp)builder.complement((IRegExp<ITerm>)re)), TermMatch.M.appl2("Concat", m, m, (t, re1, re2) -> (IRegExp)builder.concat((IRegExp<ITerm>)re1, (IRegExp<ITerm>)re2)), TermMatch.M.appl2("And", m, m, (t, re1, re2) -> (IRegExp)builder.and((IRegExp<ITerm>)re1, (IRegExp<ITerm>)re2)), TermMatch.M.appl2("Or", m, m, (t, re1, re2) -> (IRegExp)builder.or((IRegExp<ITerm>)re1, (IRegExp<ITerm>)re2)), StatixTerms.label().map(l -> (IRegExp)builder.symbol((ITerm)l))));
    }

    public static TermMatch.IMatcher<IRelation.Immutable<ITerm>> labelLt() {
        return TermMatch.M.listElems(StatixTerms.labelPair(), (t, ps) -> {
            IRelation.Transient<ITerm> order = Relation.Transient.of(RelationDescription.STRICT_PARTIAL_ORDER);
            for (Tuple2 p : ps) {
                try {
                    order.add((ITerm)p._1(), (ITerm)p._2());
                }
                catch (RelationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return order.freeze();
        });
    }

    public static TermMatch.IMatcher<Tuple2<ITerm, ITerm>> labelPair() {
        return TermMatch.M.appl2("LabelPair", StatixTerms.label(), StatixTerms.label(), (t, l1, l2) -> Tuple2.of(l1, l2));
    }

    public static TermMatch.IMatcher<CAstProperty.Op> propertyOp() {
        return TermMatch.M.cases(TermMatch.M.appl0("Add", t -> CAstProperty.Op.ADD), TermMatch.M.appl0("Set", t -> CAstProperty.Op.SET));
    }

    public static TermMatch.IMatcher<ITerm> term() {
        return TermMatch.M.casesFix(m -> Iterables2.from(StatixTerms.varTerm(), TermMatch.M.appl2("Op", TermMatch.M.stringValue(), TermMatch.M.listElems(m), (t, op, args) -> TermBuild.B.newAppl((String)op, (Iterable<? extends ITerm>)args, t.getAttachments())), TermMatch.M.appl1("Tuple", TermMatch.M.listElems(m), (t, args) -> TermBuild.B.newTuple((Iterable<? extends ITerm>)args, t.getAttachments())), TermMatch.M.appl1("Str", TermMatch.M.stringValue(), (t, string) -> TermBuild.B.newString((String)string, t.getAttachments())), StatixTerms.intTerm(), StatixTerms.listTerm(), TermMatch.M.appl3(OCCURRENCE_OP, TermMatch.M.string(), TermMatch.M.listElems(m), StatixTerms.positionTerm(), (t, ns, args, pos) -> {
            ImmutableList applArgs = ImmutableList.of((Object)ns, (Object)TermBuild.B.newList((Iterable<? extends ITerm>)args), (Object)pos);
            return TermBuild.B.newAppl(OCCURRENCE_OP, (Iterable<? extends ITerm>)applArgs, t.getAttachments());
        }), TermMatch.M.appl1(PATH_EMPTY_OP, StatixTerms.term(), (t, s) -> {
            ImmutableList applArgs = ImmutableList.of((Object)s);
            return TermBuild.B.newAppl(PATH_EMPTY_OP, (Iterable<? extends ITerm>)applArgs, t.getAttachments());
        }), TermMatch.M.appl3(PATH_STEP_OP, StatixTerms.term(), StatixTerms.term(), StatixTerms.term(), (t, p, l, s) -> {
            ImmutableList applArgs = ImmutableList.of((Object)p, (Object)l, (Object)s);
            return TermBuild.B.newAppl(PATH_STEP_OP, (Iterable<? extends ITerm>)applArgs, t.getAttachments());
        })));
    }

    public static TermMatch.IMatcher<IIntTerm> intTerm() {
        return TermMatch.M.appl1("Int", TermMatch.M.stringValue(), (t, integer) -> TermBuild.B.newInt(Integer.parseInt(integer), t.getAttachments()));
    }

    private static TermMatch.IMatcher<ITerm> positionTerm() {
        return TermMatch.M.cases(TermMatch.M.appl0(NOID_OP), TermMatch.M.appl1(WITHID_OP, StatixTerms.varTerm(), (t, v) -> v));
    }

    public static TermMatch.IMatcher<IListTerm> listTerm() {
        return TermMatch.M.casesFix(m -> Iterables2.from(StatixTerms.varTerm(), TermMatch.M.appl1("List", TermMatch.M.listElems((t, u) -> StatixTerms.term().match(t, u)), (t, elems) -> {
            ArrayList as = Lists.newArrayList();
            elems.stream().map(ITerm::getAttachments).forEach(as::add);
            as.add(t.getAttachments());
            return TermBuild.B.newList((Iterable<? extends ITerm>)elems, as);
        }), TermMatch.M.appl2("ListTail", TermMatch.M.listElems((t, u) -> StatixTerms.term().match(t, u)), m, (t, elems, tail) -> {
            ArrayList as = Lists.newArrayList();
            elems.stream().map(ITerm::getAttachments).forEach(as::add);
            return TermBuild.B.newListTail((Iterable<? extends ITerm>)elems, (IListTerm)tail, as).withAttachments((ImmutableClassToInstanceMap)t.getAttachments());
        })));
    }

    public static TermMatch.IMatcher<ITermVar> varTerm() {
        return TermMatch.M.preserveAttachments(TermMatch.M.appl1("Var", TermMatch.M.stringValue(), (t, name) -> TermBuild.B.newVar("", (String)name).withAttachments((ImmutableClassToInstanceMap)t.getAttachments())));
    }

    public static TermMatch.IMatcher<Pattern> pattern() {
        return TermMatch.M.casesFix(m -> Iterables2.from(StatixTerms.varPattern(), TermMatch.M.appl2("As", StatixTerms.varOrWld(), m, (t, var, pattern) -> var.map(v -> TermPattern.P.newAs((ITermVar)v, (Pattern)pattern)).orElseGet(() -> TermPattern.P.newAs((Pattern)pattern))), TermMatch.M.appl2("Op", TermMatch.M.stringValue(), TermMatch.M.listElems(m), (t, op, args) -> TermPattern.P.newAppl((String)op, (Iterable<? extends Pattern>)args, t.getAttachments())), TermMatch.M.appl1("Tuple", TermMatch.M.listElems(TermMatch.M.req(m)), (t, args) -> TermPattern.P.newTuple((Iterable<? extends Pattern>)args, t.getAttachments())), TermMatch.M.appl1("List", TermMatch.M.listElems((t, u) -> m.match(t, u)), (t, elems) -> TermPattern.P.newList((Iterable<? extends Pattern>)elems, t.getAttachments())), TermMatch.M.appl2("ListTail", TermMatch.M.listElems((t, u) -> m.match(t, u)), m, (t, elems, tail) -> TermPattern.P.newListTail((Iterable<? extends Pattern>)elems, (Pattern)tail, t.getAttachments())), TermMatch.M.appl1("Str", TermMatch.M.stringValue(), (t, string) -> TermPattern.P.newString((String)string, t.getAttachments())), TermMatch.M.appl1("Int", TermMatch.M.stringValue(), (t, integer) -> TermPattern.P.newInt(Integer.parseInt(integer), t.getAttachments())), TermMatch.M.appl3(OCCURRENCE_OP, TermMatch.M.stringValue(), TermMatch.M.listElems(m), StatixTerms.positionPattern(), (t, ns, args, pos) -> {
            ImmutableList applArgs = ImmutableList.of((Object)TermPattern.P.newString((String)ns), (Object)TermPattern.P.newList((Iterable<? extends Pattern>)args), (Object)pos);
            return TermPattern.P.newAppl(OCCURRENCE_OP, (Iterable<? extends Pattern>)applArgs, t.getAttachments());
        }), TermMatch.M.appl1(PATH_EMPTY_OP, m, (t, s) -> {
            ImmutableList applArgs = ImmutableList.of((Object)s);
            return TermPattern.P.newAppl(PATH_EMPTY_OP, (Iterable<? extends Pattern>)applArgs, t.getAttachments());
        }), TermMatch.M.appl3(PATH_STEP_OP, m, m, m, (t, p, l, s) -> {
            ImmutableList applArgs = ImmutableList.of((Object)p, (Object)l, (Object)s);
            return TermPattern.P.newAppl(PATH_STEP_OP, (Iterable<? extends Pattern>)applArgs, t.getAttachments());
        })));
    }

    public static TermMatch.IMatcher<Optional<ITermVar>> varOrWld() {
        return TermMatch.M.cases(TermMatch.M.appl0("Wld", t -> Optional.empty()), TermMatch.M.appl1("Var", TermMatch.M.stringValue(), (t, name) -> Optional.of(TermBuild.B.newVar("", (String)name, t.getAttachments()))));
    }

    public static TermMatch.IMatcher<Pattern> varPattern() {
        return StatixTerms.varOrWld().map(v -> v.map(TermPattern.P::newVar).orElse(TermPattern.P.newWld()));
    }

    private static TermMatch.IMatcher<Pattern> positionPattern() {
        return TermMatch.M.cases(TermMatch.M.appl0(NOID_OP, t -> TermPattern.P.newWld()), TermMatch.M.appl1(WITHID_OP, StatixTerms.varPattern(), (t, p) -> p));
    }

    public static TermMatch.IMatcher<Optional<IMessage>> message() {
        return TermMatch.M.cases(TermMatch.M.appl0("NoMessage", t -> Optional.empty()), TermMatch.M.appl3("Message", StatixTerms.messageKind(), StatixTerms.messageContent(), StatixTerms.messageOrigin(), (t, kind, content, origin) -> Optional.of(new Message((MessageKind)kind, (Iterable<IMessagePart>)content, origin.orElse(null)))));
    }

    public static TermMatch.IMatcher<List<IMessagePart>> messageContent() {
        return TermMatch.M.cases(TermMatch.M.appl1("Str", TermMatch.M.stringValue(), (t, text) -> ImmutableList.of((Object)new TextPart((String)text))), TermMatch.M.appl1("Formatted", TermMatch.M.listElems(StatixTerms.messagePart()), (t, parts) -> parts));
    }

    public static TermMatch.IMatcher<IMessagePart> messagePart() {
        return TermMatch.M.cases(TermMatch.M.appl1("Text", TermMatch.M.stringValue(), (t, text) -> new TextPart((String)text)), TermMatch.M.appl1("Term", StatixTerms.term(), (t, term) -> new TermPart((ITerm)term)));
    }

    public static TermMatch.IMatcher<MessageKind> messageKind() {
        return TermMatch.M.cases(TermMatch.M.appl0("Error", t -> MessageKind.ERROR), TermMatch.M.appl0("Warning", t -> MessageKind.WARNING), TermMatch.M.appl0("Note", t -> MessageKind.NOTE));
    }

    public static TermMatch.IMatcher<Optional<ITerm>> messageOrigin() {
        return TermMatch.M.cases(TermMatch.M.appl0("NoOrigin", t -> Optional.empty()), TermMatch.M.appl1("Origin", StatixTerms.varTerm(), (t, v) -> Optional.of(v)));
    }

    public static ITerm explicate(ITerm term) {
        return term.match(Terms.cases(appl -> {
            switch (appl.getOp()) {
                case "WithId": 
                case "TermIndex": 
                case "NoId": 
                case "Scope": 
                case "PathStep": 
                case "PathEmpty": {
                    return appl;
                }
                case "StxOccurrence": {
                    ITerm ns = appl.getArgs().get(0);
                    List args = TermMatch.M.listElems().map(ts -> StatixTerms.explicate(ts)).match(appl.getArgs().get(1)).orElseThrow(() -> new IllegalArgumentException());
                    ITerm pos = StatixTerms.explicatePosition(appl.getArgs().get(2));
                    return TermBuild.B.newAppl(appl.getOp(), ns, TermBuild.B.newList(args), pos);
                }
            }
            List<ITerm> args = StatixTerms.explicate(appl.getArgs());
            return TermBuild.B.newAppl("Op", TermBuild.B.newString(appl.getOp()), TermBuild.B.newList(args));
        }, list -> StatixTerms.explicate(list), string -> TermBuild.B.newAppl("Str", (ITerm)string), integer -> TermBuild.B.newAppl("Int", TermBuild.B.newString(integer.toString())), blob -> TermBuild.B.newString(blob.toString()), var -> StatixTerms.explicate(var))).withAttachments(term.getAttachments());
    }

    private static ITerm explicate(IListTerm list) {
        ArrayList terms = Lists.newArrayList();
        ArrayList attachments = Lists.newArrayList();
        Ref varTail = new Ref();
        while (list != null) {
            list = list.match(ListTerms.cases(cons -> {
                terms.add(StatixTerms.explicate(cons.getHead()));
                attachments.add(cons.getAttachments());
                return cons.getTail();
            }, nil -> {
                attachments.add(nil.getAttachments());
                return null;
            }, var -> {
                varTail.set(StatixTerms.explicate(var));
                attachments.add(ImmutableClassToInstanceMap.builder().build());
                return null;
            }));
        }
        list = TermBuild.B.newList(terms, attachments);
        if (varTail.get() != null) {
            return TermBuild.B.newAppl("ListTail", list, (ITerm)varTail.get());
        }
        return TermBuild.B.newAppl("List", list);
    }

    private static ITerm explicate(ITermVar var) {
        return TermBuild.B.newAppl("Var", Arrays.asList(TermBuild.B.newString(var.getName())));
    }

    public static List<ITerm> explicate(Iterable<? extends ITerm> terms) {
        return (List)Iterables2.stream(terms).map(StatixTerms::explicate).collect(ImmutableList.toImmutableList());
    }

    public static IListTerm explicateList(Iterable<? extends ITerm> terms) {
        return TermBuild.B.newList(StatixTerms.explicate(terms));
    }

    public static IListTerm explicateMapEntries(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> entries, IUniDisunifier unifier) {
        return TermBuild.B.newList((Iterable)Iterables2.stream(entries).map(e -> TermBuild.B.newTuple(StatixTerms.explicate((ITerm)e.getKey()), StatixTerms.explicate(unifier.findRecursive((ITerm)e.getValue())))).collect(ImmutableList.toImmutableList()));
    }

    public static ITerm explicate(IResolutionPath<Scope, ITerm, ITerm> path) {
        return TermBuild.B.newTuple(StatixTerms.explicate(path.getPath()), TermBuild.B.newTuple(path.getDatum()));
    }

    public static ITerm explicate(IScopePath<Scope, ITerm> path) {
        IApplTerm pathTerm = TermBuild.B.newAppl(PATH_EMPTY_OP, path.getSource());
        for (IStep iStep : path) {
            pathTerm = TermBuild.B.newAppl(PATH_STEP_OP, pathTerm, (ITerm)iStep.getLabel(), (ITerm)iStep.getTarget());
        }
        return pathTerm;
    }

    private static ITerm explicatePosition(ITerm pos) {
        return TermMatch.M.appl0(NOID_OP).match(pos).orElse(TermBuild.B.newAppl(WITHID_OP, StatixTerms.explicate(pos)));
    }
}

