/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.commons.vfs2.FileSystemManager;
import org.metaborg.core.analysis.AnalysisService;
import org.metaborg.core.analysis.IAnalysisService;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.analysis.IAnalyzeUnitUpdate;
import org.metaborg.core.build.BuildOutput;
import org.metaborg.core.build.Builder;
import org.metaborg.core.build.IBuildOutputInternal;
import org.metaborg.core.build.IBuilder;
import org.metaborg.core.build.dependency.DefaultDependencyService;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.build.paths.DependencyPathProvider;
import org.metaborg.core.build.paths.ILanguagePathProvider;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.build.paths.LanguagePathService;
import org.metaborg.core.build.paths.SourcePathProvider;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.ILanguageComponentConfigBuilder;
import org.metaborg.core.config.ILanguageComponentConfigService;
import org.metaborg.core.config.ILanguageComponentConfigWriter;
import org.metaborg.core.config.IProjectConfigBuilder;
import org.metaborg.core.config.IProjectConfigService;
import org.metaborg.core.config.IProjectConfigWriter;
import org.metaborg.core.config.LanguageComponentConfigBuilder;
import org.metaborg.core.config.LanguageComponentConfigService;
import org.metaborg.core.config.ProjectConfigBuilder;
import org.metaborg.core.config.ProjectConfigService;
import org.metaborg.core.config.YamlConfigurationReaderWriter;
import org.metaborg.core.context.ContextService;
import org.metaborg.core.context.IContextFactory;
import org.metaborg.core.context.IContextProcessor;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.context.IContextStrategy;
import org.metaborg.core.context.ProjectContextStrategy;
import org.metaborg.core.context.ResourceContextStrategy;
import org.metaborg.core.editor.DummyEditorRegistry;
import org.metaborg.core.editor.IEditorRegistry;
import org.metaborg.core.language.ILanguageCache;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.LanguageIdentifierService;
import org.metaborg.core.language.LanguageService;
import org.metaborg.core.processing.BlockingProcessor;
import org.metaborg.core.processing.ILanguageChangeProcessor;
import org.metaborg.core.processing.IProcessor;
import org.metaborg.core.processing.IProcessorRunner;
import org.metaborg.core.processing.LanguageChangeProcessor;
import org.metaborg.core.processing.ProcessorRunner;
import org.metaborg.core.processing.analyze.AnalysisResultProcessor;
import org.metaborg.core.processing.analyze.IAnalysisResultProcessor;
import org.metaborg.core.processing.analyze.IAnalysisResultRequester;
import org.metaborg.core.processing.analyze.IAnalysisResultUpdater;
import org.metaborg.core.processing.parse.IParseResultProcessor;
import org.metaborg.core.processing.parse.IParseResultRequester;
import org.metaborg.core.processing.parse.IParseResultUpdater;
import org.metaborg.core.processing.parse.ParseResultProcessor;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.project.ISimpleProjectService;
import org.metaborg.core.project.SimpleProjectService;
import org.metaborg.core.resource.DefaultFileSystemManagerProvider;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.resource.ResourceService;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.core.source.SourceTextService;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.testing.ITestReporterService;
import org.metaborg.core.testing.LoggingTestReporterService;
import org.metaborg.core.testing.TeamCityLogger;
import org.metaborg.core.testing.TeamCityWriter;
import org.metaborg.core.transform.ITransformUnit;

public class MetaborgModule
extends AbstractModule {
    private final ClassLoader resourceClassLoader;
    protected Multibinder<AutoCloseable> autoClosableBinder;
    protected Multibinder<AutoCloseable> lateAutoClosableBinder;
    protected Multibinder<ILanguageCache> languageCacheBinder;
    protected MapBinder<String, IContextFactory> contextFactoryBinder;
    protected MapBinder<String, IContextStrategy> contextStrategyBinder;
    protected Multibinder<ILanguagePathProvider> languagePathProviderBinder;

    public MetaborgModule() {
        this(MetaborgModule.class.getClassLoader());
    }

    public MetaborgModule(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    protected void configure() {
        this.autoClosableBinder = Multibinder.newSetBinder((Binder)this.binder(), AutoCloseable.class);
        this.lateAutoClosableBinder = Multibinder.newSetBinder((Binder)this.binder(), AutoCloseable.class, (Annotation)Names.named((String)"late"));
        this.languageCacheBinder = Multibinder.newSetBinder((Binder)this.binder(), ILanguageCache.class);
        this.contextFactoryBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, IContextFactory.class);
        this.contextStrategyBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, IContextStrategy.class);
        this.languagePathProviderBinder = Multibinder.newSetBinder((Binder)this.binder(), ILanguagePathProvider.class);
        this.bindResource();
        this.bindLanguage();
        this.bindContext();
        this.bindContextFactories(this.contextFactoryBinder);
        this.bindContextStrategies(this.contextStrategyBinder);
        this.bindProject();
        this.bindConfigMisc();
        this.bindProjectConfig();
        this.bindLanguageComponentConfig();
        this.bindLanguagePath();
        this.bindLanguagePathProviders(this.languagePathProviderBinder);
        this.bindDependency();
        this.bindSourceText();
        this.bindAnalysis();
        this.bindBuilder();
        this.bindProcessor();
        this.bindProcessorRunner();
        this.bindLanguageChangeProcessing();
        this.bindEditor();
        this.bindTestFramework();
        this.bindTestReporter();
        this.bind(ClassLoader.class).annotatedWith((Annotation)Names.named((String)"ResourceClassLoader")).toInstance((Object)this.resourceClassLoader);
    }

    protected void bindResource() {
        this.bind(ResourceService.class).in(Singleton.class);
        this.bind(IResourceService.class).to(ResourceService.class);
        this.lateAutoClosableBinder.addBinding().to(ResourceService.class);
        this.bind(FileSystemManager.class).toProvider(DefaultFileSystemManagerProvider.class).in(Singleton.class);
    }

    protected void bindLanguage() {
        this.bind(LanguageService.class).in(Singleton.class);
        this.bind(ILanguageService.class).to(LanguageService.class);
        this.autoClosableBinder.addBinding().to(LanguageService.class);
        this.bind(ILanguageIdentifierService.class).to(LanguageIdentifierService.class).in(Singleton.class);
    }

    protected void bindProject() {
        this.bind(SimpleProjectService.class).in(Singleton.class);
        this.bind(ISimpleProjectService.class).to(SimpleProjectService.class);
        this.bind(IProjectService.class).to(SimpleProjectService.class);
    }

    protected void bindContext() {
        this.bind(ContextService.class).in(Singleton.class);
        this.bind(IContextService.class).to(ContextService.class);
        this.bind(IContextProcessor.class).to(ContextService.class);
    }

    protected void bindContextFactories(MapBinder<String, IContextFactory> binder) {
    }

    protected void bindContextStrategies(MapBinder<String, IContextStrategy> binder) {
        binder.addBinding((Object)"resource").to(ResourceContextStrategy.class).in(Singleton.class);
        binder.addBinding((Object)"project").to(ProjectContextStrategy.class).in(Singleton.class);
    }

    protected void bindConfigMisc() {
        this.bind(AConfigurationReaderWriter.class).to(YamlConfigurationReaderWriter.class).in(Singleton.class);
    }

    protected void bindProjectConfig() {
        this.bind(ProjectConfigService.class).in(Singleton.class);
        this.bind(IProjectConfigService.class).to(ProjectConfigService.class);
        this.bind(IProjectConfigWriter.class).to(ProjectConfigService.class);
        this.bind(ProjectConfigBuilder.class);
        this.bind(IProjectConfigBuilder.class).to(ProjectConfigBuilder.class);
    }

    protected void bindLanguageComponentConfig() {
        this.bind(LanguageComponentConfigService.class).in(Singleton.class);
        this.bind(ILanguageComponentConfigWriter.class).to(LanguageComponentConfigService.class);
        this.bind(ILanguageComponentConfigService.class).to(LanguageComponentConfigService.class);
        this.bind(LanguageComponentConfigBuilder.class);
        this.bind(ILanguageComponentConfigBuilder.class).to(LanguageComponentConfigBuilder.class);
    }

    protected void bindLanguagePath() {
        this.bind(ILanguagePathService.class).to(LanguagePathService.class).in(Singleton.class);
    }

    protected void bindLanguagePathProviders(Multibinder<ILanguagePathProvider> binder) {
        binder.addBinding().to(SourcePathProvider.class);
        binder.addBinding().to(DependencyPathProvider.class);
    }

    protected void bindDependency() {
        this.bind(IDependencyService.class).to(DefaultDependencyService.class).in(Singleton.class);
    }

    protected void bindSourceText() {
        this.bind(ISourceTextService.class).to(SourceTextService.class).in(Singleton.class);
    }

    protected void bindAnalysis() {
        this.bind(IAnalysisService.class).to(AnalysisService.class).in(Singleton.class);
    }

    protected void bindBuilder() {
        this.bind(ParseResultProcessor.class).in(Singleton.class);
        this.bind(IParseResultRequester.class).to(ParseResultProcessor.class);
        this.bind(IParseResultUpdater.class).to(ParseResultProcessor.class);
        this.bind(IParseResultProcessor.class).to(ParseResultProcessor.class);
        this.autoClosableBinder.addBinding().to(ParseResultProcessor.class);
        this.bind(AnalysisResultProcessor.class).in(Singleton.class);
        this.bind(IAnalysisResultRequester.class).to(AnalysisResultProcessor.class);
        this.bind(IAnalysisResultUpdater.class).to(AnalysisResultProcessor.class);
        this.bind(IAnalysisResultProcessor.class).to(AnalysisResultProcessor.class);
        this.autoClosableBinder.addBinding().to(AnalysisResultProcessor.class);
        this.bind(IBuilder.class).to(Builder.class).in(Singleton.class);
        this.bind(new TypeLiteral<IBuildOutputInternal<IParseUnit, IAnalyzeUnit, IAnalyzeUnitUpdate, ITransformUnit<?>>>(){}).to(new TypeLiteral<BuildOutput<IParseUnit, IAnalyzeUnit, IAnalyzeUnitUpdate, ITransformUnit<?>>>(){});
    }

    protected void bindProcessorRunner() {
        this.bind(IProcessorRunner.class).to(ProcessorRunner.class).in(Singleton.class);
    }

    protected void bindProcessor() {
        this.bind(IProcessor.class).to(BlockingProcessor.class).in(Singleton.class);
    }

    protected void bindLanguageChangeProcessing() {
        this.bind(ILanguageChangeProcessor.class).to(LanguageChangeProcessor.class).in(Singleton.class);
    }

    protected void bindEditor() {
        this.bind(IEditorRegistry.class).to(DummyEditorRegistry.class).in(Singleton.class);
    }

    protected void bindTestFramework() {
        this.bind(TeamCityWriter.class).in(Singleton.class);
        this.bind(TeamCityLogger.class).in(Singleton.class);
    }

    protected void bindTestReporter() {
        this.bind(ITestReporterService.class).to(LoggingTestReporterService.class).in(Singleton.class);
    }
}

