/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build.paths;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.paths.ILanguagePathProvider;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.project.IProject;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.resource.ResourceUtils;

public class LanguagePathService
implements ILanguagePathService {
    private static final ILogger logger = LoggerUtils.logger(LanguagePathService.class);
    private final ILanguageIdentifierService languageIdentifierService;
    private final Set<ILanguagePathProvider> providers;

    @Inject
    public LanguagePathService(ILanguageIdentifierService languageIdentifierService, Set<ILanguagePathProvider> providers) {
        this.languageIdentifierService = languageIdentifierService;
        this.providers = providers;
    }

    public Set<FileObject> sourcePaths(IProject project, String languageName) {
        ImmutableSortedSet.Builder sources = ImmutableSortedSet.reverseOrder();
        for (ILanguagePathProvider provider : this.providers) {
            try {
                Iterable<FileObject> providedSources = provider.sourcePaths(project, languageName);
                sources.addAll(providedSources);
            }
            catch (MetaborgException e) {
                logger.error("Getting source paths from provider {} failed unexpectedly, skipping this provider", e, provider);
            }
        }
        return sources.build();
    }

    public Set<FileObject> includePaths(IProject project, String languageName) {
        ImmutableSortedSet.Builder includes = ImmutableSortedSet.reverseOrder();
        for (ILanguagePathProvider provider : this.providers) {
            try {
                Iterable<FileObject> providedIncludes = provider.includePaths(project, languageName);
                includes.addAll(providedIncludes);
            }
            catch (MetaborgException e) {
                logger.error("Getting include paths from provider {} failed unexpectedly, skipping this provider", e, provider);
            }
        }
        return includes.build();
    }

    @Override
    public Iterable<FileObject> sourceAndIncludePaths(IProject project, String languageName) {
        ImmutableList.Builder paths = ImmutableList.builder();
        paths.addAll(this.sourcePaths(project, languageName));
        paths.addAll(this.includePaths(project, languageName));
        return paths.build();
    }

    @Override
    public Iterable<IdentifiedResource> sourceFiles(IProject project, ILanguageImpl language) {
        Iterable sourcePaths = this.sourcePaths(project, language.belongsTo().name());
        return this.toFiles(sourcePaths, language);
    }

    @Override
    public Iterable<IdentifiedResource> includeFiles(IProject project, ILanguageImpl language) {
        Iterable includePaths = this.includePaths(project, language.belongsTo().name());
        return this.toFiles(includePaths, language);
    }

    @Override
    public Iterable<IdentifiedResource> sourceAndIncludeFiles(IProject project, ILanguageImpl language) {
        Iterable<FileObject> paths = this.sourceAndIncludePaths(project, language.belongsTo().name());
        return this.toFiles((Iterable)paths, language);
    }

    public Collection<IdentifiedResource> toFiles(Iterable<FileObject> paths, ILanguageImpl language) {
        Collection<FileObject> files = ResourceUtils.expand(paths);
        ArrayList identifiedFiles = Lists.newArrayListWithExpectedSize((int)files.size());
        for (FileObject file : files) {
            IdentifiedResource identifiedFile = this.languageIdentifierService.identifyToResource(file, Iterables2.singleton(language));
            if (identifiedFile == null) continue;
            identifiedFiles.add(identifiedFile);
        }
        return identifiedFiles;
    }
}

