/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.config.AConfigBuilder;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IGenerateConfig;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ILanguageComponentConfigBuilder;
import org.metaborg.core.config.JSGLR2Logging;
import org.metaborg.core.config.JSGLRVersion;
import org.metaborg.core.config.LanguageComponentConfig;
import org.metaborg.core.config.ProjectConfig;
import org.metaborg.core.config.ProjectConfigBuilder;
import org.metaborg.core.config.Sdf2tableVersion;
import org.metaborg.core.language.LanguageContributionIdentifier;
import org.metaborg.core.language.LanguageIdentifier;

public class LanguageComponentConfigBuilder
extends AConfigBuilder
implements ILanguageComponentConfigBuilder {
    protected final ProjectConfigBuilder projectConfigBuilder;
    @Nullable
    protected LanguageIdentifier identifier;
    @Nullable
    protected String name;
    @Nullable
    protected Set<LanguageContributionIdentifier> langContribs;
    @Nullable
    protected List<IGenerateConfig> generates;
    @Nullable
    protected List<IExportConfig> exports;
    @Nullable
    protected Boolean sdfEnabled;
    @Nullable
    protected String parseTable;
    @Nullable
    protected String completionsParseTable;
    @Nullable
    protected Sdf2tableVersion sdf2tableVersion;
    @Nullable
    protected Boolean checkOverlap;
    @Nullable
    protected Boolean checkPriorities;
    @Nullable
    protected Boolean dataDependent;
    @Nullable
    protected JSGLRVersion jsglrVersion;
    @Nullable
    protected JSGLR2Logging jsglr2Logging;

    @Inject
    public LanguageComponentConfigBuilder(AConfigurationReaderWriter configReaderWriter) {
        super(configReaderWriter);
        this.projectConfigBuilder = new ProjectConfigBuilder(configReaderWriter);
    }

    @Override
    public ILanguageComponentConfig build(@Nullable FileObject rootFolder) throws IllegalStateException {
        if (this.configuration == null) {
            this.configuration = this.configReaderWriter.create(null, rootFolder);
        }
        ProjectConfig projectConfig = this.projectConfigBuilder.build((HierarchicalConfiguration<ImmutableNode>)this.configuration);
        LanguageComponentConfig config = new LanguageComponentConfig((HierarchicalConfiguration<ImmutableNode>)this.configuration, projectConfig, this.identifier, this.name, this.sdfEnabled, this.parseTable, this.completionsParseTable, this.sdf2tableVersion, this.checkOverlap, this.checkPriorities, this.dataDependent, this.jsglrVersion, this.jsglr2Logging, this.langContribs, this.generates, this.exports);
        return config;
    }

    @Override
    public ILanguageComponentConfigBuilder reset() {
        this.projectConfigBuilder.reset();
        this.identifier = null;
        this.name = null;
        this.langContribs = null;
        this.generates = null;
        this.exports = null;
        this.parseTable = null;
        this.completionsParseTable = null;
        this.sdf2tableVersion = null;
        this.checkOverlap = null;
        this.checkPriorities = null;
        this.jsglrVersion = null;
        this.jsglr2Logging = null;
        this.sdfEnabled = null;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder copyFrom(ILanguageComponentConfig config) {
        if (config instanceof IConfig) {
            this.configuration = this.cloneConfiguration((IConfig)((Object)config));
            this.projectConfigBuilder.setConfiguration((HierarchicalConfiguration<ImmutableNode>)this.configuration);
        } else {
            this.withIdentifier(config.identifier());
            this.withName(config.name());
            this.withLangContribs(config.langContribs());
            this.withGenerates(config.generates());
            this.withExports(config.exports());
            this.withSdfTable(config.parseTable());
            this.withSdfCompletionsTable(config.completionsParseTable());
            this.withSdf2tableVersion(config.sdf2tableVersion());
            this.withJSGLRVersion(config.jsglrVersion());
            this.withJSGLR2Logging(config.jsglr2Logging());
            this.withCheckOverlap(config.checkOverlap());
            this.withCheckPriorities(config.checkPriorities());
            this.withSdfEnabled(config.sdfEnabled());
            this.projectConfigBuilder.copyValuesFrom(config);
        }
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withMetaborgVersion(String metaborgVersion) {
        this.projectConfigBuilder.withMetaborgVersion(metaborgVersion);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withCompileDeps(Iterable<LanguageIdentifier> deps) {
        this.projectConfigBuilder.withCompileDeps(deps);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder addCompileDeps(Iterable<LanguageIdentifier> deps) {
        this.projectConfigBuilder.addCompileDeps(deps);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withSourceDeps(Iterable<LanguageIdentifier> deps) {
        this.projectConfigBuilder.withSourceDeps(deps);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder addSourceDeps(Iterable<LanguageIdentifier> deps) {
        this.projectConfigBuilder.addSourceDeps(deps);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withJavaDeps(Iterable<LanguageIdentifier> deps) {
        this.projectConfigBuilder.withJavaDeps(deps);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder addJavaDeps(Iterable<LanguageIdentifier> deps) {
        this.projectConfigBuilder.addJavaDeps(deps);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withIdentifier(LanguageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withSdfEnabled(Boolean sdfEnabled) {
        this.sdfEnabled = sdfEnabled;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withSdfTable(String table) {
        this.parseTable = table;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withSdfCompletionsTable(String completionsTable) {
        this.completionsParseTable = completionsTable;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withSdf2tableVersion(Sdf2tableVersion sdf2tableVersion) {
        this.sdf2tableVersion = sdf2tableVersion;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withCheckPriorities(Boolean checkPriorities) {
        this.checkPriorities = checkPriorities;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withCheckOverlap(Boolean checkOverlap) {
        this.checkOverlap = checkOverlap;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withJSGLRVersion(JSGLRVersion jsglrVersion) {
        this.jsglrVersion = jsglrVersion;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withJSGLR2Logging(JSGLR2Logging jsglr2Logging) {
        this.jsglr2Logging = jsglr2Logging;
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withLangContribs(Iterable<LanguageContributionIdentifier> contribs) {
        if (this.langContribs != null) {
            this.langContribs.clear();
        }
        this.addLangContribs(contribs);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder addLangContribs(Iterable<LanguageContributionIdentifier> contribs) {
        if (this.langContribs == null) {
            this.langContribs = Sets.newHashSet();
        }
        Iterables.addAll(this.langContribs, contribs);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withGenerates(Iterable<IGenerateConfig> generates) {
        if (this.generates != null) {
            this.generates.clear();
        }
        this.addGenerates(generates);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder addGenerates(Iterable<IGenerateConfig> generates) {
        if (this.generates == null) {
            this.generates = Lists.newArrayList();
        }
        Iterables.addAll(this.generates, generates);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder withExports(Iterable<IExportConfig> exports) {
        if (this.exports != null) {
            this.exports.clear();
        }
        this.addExports(exports);
        return this;
    }

    @Override
    public ILanguageComponentConfigBuilder addExports(Iterable<IExportConfig> exports) {
        if (this.exports == null) {
            this.exports = Lists.newArrayList();
        }
        Iterables.addAll(this.exports, exports);
        return this;
    }
}

