/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.context;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.context.ContextException;
import org.metaborg.core.context.ContextFacet;
import org.metaborg.core.context.ContextIdentifier;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextFactory;
import org.metaborg.core.context.IContextInternal;
import org.metaborg.core.context.IContextProcessor;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.context.ITemporaryContext;
import org.metaborg.core.context.ITemporaryContextInternal;
import org.metaborg.core.context.NullContext;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.project.IProject;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ContextService
implements IContextService,
IContextProcessor {
    private static final ILogger logger = LoggerUtils.logger(ContextService.class);
    private final Injector injector;
    private final ConcurrentMap<ContextIdentifier, IContextInternal> idToContext = Maps.newConcurrentMap();
    private final ConcurrentMap<ILanguageImpl, ContextIdentifier> langToContextId = Maps.newConcurrentMap();

    @Inject
    public ContextService(Injector injector) {
        this.injector = injector;
    }

    @Override
    public IContext get(FileObject resource, IProject project, ILanguageImpl language) throws ContextException {
        if (this.available(language)) {
            ContextFacet facet = this.getFacet(resource, language);
            ContextIdentifier identifier = facet.strategy.get(resource, project, language);
            return this.getOrCreate(facet.factory, identifier);
        }
        return this.createNullContext(project, language);
    }

    @Override
    public ITemporaryContext getTemporary(FileObject resource, IProject project, ILanguageImpl language) throws ContextException {
        if (this.available(language)) {
            ContextIdentifier identifier;
            ContextFacet facet = this.getFacet(resource, language);
            try {
                identifier = facet.strategy.get(resource, project, language);
            }
            catch (ContextException e) {
                logger.debug("Could not create a context via context strategy of language {} (see exception), creating context with given resource {} instead", e, language, resource);
                identifier = new ContextIdentifier(resource, project, language);
            }
            return this.createTemporary(facet.factory, identifier);
        }
        return this.createNullContext(project, language);
    }

    @Override
    public void unload(IContext context) {
        IContextInternal contextInternal = (IContextInternal)context;
        contextInternal.unload();
        ContextIdentifier identifier = contextInternal.identifier();
        this.idToContext.remove(identifier);
        this.langToContextId.remove(identifier.language);
    }

    @Override
    public void update(LanguageImplChange change) {
        switch (change.kind) {
            case Remove: {
                IContextInternal removed;
                ContextIdentifier id = (ContextIdentifier)this.langToContextId.remove(change.impl);
                if (id == null || (removed = (IContextInternal)this.idToContext.remove(id)) == null) break;
                removed.unload();
                logger.debug("Removing {}", removed);
                break;
            }
        }
    }

    private boolean available(ILanguageImpl language) {
        ContextFacet facet = language.facet(ContextFacet.class);
        return facet != null;
    }

    private ContextFacet getFacet(FileObject resource, ILanguageImpl language) throws ContextException {
        ContextFacet facet = language.facet(ContextFacet.class);
        if (facet == null) {
            String message = logger.format("Cannot get a context, {} does not have a context facet", language);
            throw new ContextException(resource, language, message);
        }
        return facet;
    }

    private IContextInternal getOrCreate(IContextFactory factory, ContextIdentifier identifier) {
        IContextInternal newContext = this.create(factory, identifier);
        IContextInternal prevContext = this.idToContext.putIfAbsent(identifier, newContext);
        this.langToContextId.putIfAbsent(identifier.language, identifier);
        if (prevContext == null) {
            return newContext;
        }
        if (!prevContext.getClass().equals(newContext.getClass())) {
            logger.info("Context for {} changed type, ignoring existing context.", identifier);
            if (this.idToContext.replace(identifier, prevContext, newContext)) {
                try {
                    prevContext.reset();
                }
                catch (IOException e) {
                    logger.warn("Error occurred while resetting {}", prevContext, e);
                }
            } else {
                logger.warn("Race condition while replacing context {} with {}", prevContext, newContext);
            }
            return newContext;
        }
        return prevContext;
    }

    private IContextInternal create(IContextFactory factory, ContextIdentifier identifier) {
        return factory.create(identifier);
    }

    private ITemporaryContextInternal createTemporary(IContextFactory factory, ContextIdentifier identifier) {
        return factory.createTemporary(identifier);
    }

    private NullContext createNullContext(IProject project, ILanguageImpl language) {
        return new NullContext(project.location(), project, language, this.injector);
    }
}

