/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.testing;

import com.google.inject.Inject;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.time.StopWatch;
import org.metaborg.core.testing.TeamCityLogger;
import org.metaborg.core.testing.TeamCityWriter;
import org.metaborg.core.testing.TestReporterServiceBase;
import org.metaborg.util.log.ILogger;

public class TeamCityTestReporterService
extends TestReporterServiceBase {
    private final TeamCityWriter writer;
    private final TeamCityLogger logger;
    private StopWatch stopwatch = new StopWatch();
    private ByteArrayOutputStream outStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream errStream = new ByteArrayOutputStream();
    private PrintStream out = new PrintStream((OutputStream)this.outStream);
    private PrintStream err = new PrintStream((OutputStream)this.errStream);

    @Inject
    public TeamCityTestReporterService(TeamCityWriter writer, TeamCityLogger logger) {
        this.writer = writer;
        this.logger = logger;
    }

    @Override
    protected void onSessionStarted() {
    }

    @Override
    protected void onSessionFinished() {
    }

    @Override
    protected void onTestSuiteStarted(String name) {
        this.writer.send("testSuiteStarted", new TeamCityWriter.Attribute("name", name.trim()));
    }

    @Override
    protected void onTestSuiteFinished(String name) {
        this.writer.send("testSuiteFinished", new TeamCityWriter.Attribute("name", name.trim()));
    }

    @Override
    protected void onTestStarted(String name) {
        this.writer.send("testStarted", new TeamCityWriter.Attribute("name", name.trim()), new TeamCityWriter.Attribute("captureStandardOutput", false));
        this.startStopwatch();
    }

    @Override
    protected void onTestFailed(String name, @Nullable String reason, @Nullable String details) {
        long duration = this.stopStopwatch();
        this.printOutputs(name);
        this.writer.send("testFailed", new TeamCityWriter.Attribute("name", name.trim()), new TeamCityWriter.Attribute("message", reason), new TeamCityWriter.Attribute("details", details));
        this.finishTest(name, duration);
    }

    @Override
    protected void onTestPassed(String name) {
        long duration = this.stopStopwatch();
        this.printOutputs(name);
        this.finishTest(name, duration);
    }

    @Override
    protected void onTestIgnored(String name, @Nullable String reason) {
        long duration = this.stopStopwatch();
        this.printOutputs(name);
        this.writer.send("testIgnored", new TeamCityWriter.Attribute("name", name.trim()), new TeamCityWriter.Attribute("message", reason));
        this.finishTest(name, duration);
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public PrintStream getErr() {
        return this.err;
    }

    private void startStopwatch() {
        this.stopwatch.reset();
        this.stopwatch.start();
    }

    private long stopStopwatch() {
        this.stopwatch.stop();
        return this.stopwatch.getTime();
    }

    private void printOutputs(String name) {
        String outData = this.outStream.toString(StandardCharsets.UTF_8);
        String errData = this.errStream.toString(StandardCharsets.UTF_8);
        this.outStream.reset();
        this.errStream.reset();
        if (!outData.isEmpty()) {
            this.writer.send("testStdOut", new TeamCityWriter.Attribute("name", name.trim()), new TeamCityWriter.Attribute("out", this.out));
        }
        if (!errData.isEmpty()) {
            this.writer.send("testStdErr", new TeamCityWriter.Attribute("name", name.trim()), new TeamCityWriter.Attribute("out", this.err));
        }
    }

    private void finishTest(String name, long duration) {
        this.writer.send("testFinished", new TeamCityWriter.Attribute("name", name.trim()), new TeamCityWriter.Attribute("duration", duration));
    }
}

