/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.transform;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.metaborg.core.action.IActionService;
import org.metaborg.core.action.ITransformGoal;
import org.metaborg.core.action.TransformActionContrib;
import org.metaborg.core.analysis.IAnalysisService;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.transform.ITransformConfig;
import org.metaborg.core.transform.ITransformService;
import org.metaborg.core.transform.ITransformUnit;
import org.metaborg.core.transform.ITransformer;
import org.metaborg.core.transform.TransformException;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class TransformService<P extends IParseUnit, A extends IAnalyzeUnit, TP extends ITransformUnit<P>, TA extends ITransformUnit<A>>
implements ITransformService<P, A, TP, TA> {
    private static final ILogger logger = LoggerUtils.logger(TransformService.class);
    private final IActionService actionService;
    private final IAnalysisService<P, A, ?> analysisService;
    private final ITransformer<P, A, TP, TA> transformer;

    @Inject
    public TransformService(IActionService actionService, IAnalysisService<P, A, ?> analysisService, ITransformer<P, A, TP, TA> transformer) {
        this.actionService = actionService;
        this.analysisService = analysisService;
        this.transformer = transformer;
    }

    @Override
    public boolean available(ILanguageImpl language, ITransformGoal goal) {
        return this.actionService.available(language, goal);
    }

    @Override
    public boolean requiresAnalysis(ILanguageImpl language, ITransformGoal goal) {
        return this.actionService.requiresAnalysis(language, goal);
    }

    @Override
    public Collection<TP> transform(P input, IContext context, ITransformGoal goal, ITransformConfig config) throws TransformException {
        if (!input.valid()) {
            throw new TransformException("Cannot transform parse unit " + input + ", it is not valid");
        }
        Iterable<TransformActionContrib> actions = this.actionService.actionContributions(context.language(), goal);
        ArrayList results = Lists.newArrayList();
        for (TransformActionContrib action : actions) {
            if (this.analysisService.available(context.language())) {
                TransformService.checkAnalyzed(action);
            }
            TA result = this.transformer.transform(input, context, action, config);
            results.add(result);
        }
        return results;
    }

    @Override
    public TP transform(P input, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        if (!input.valid()) {
            throw new TransformException("Cannot transform parse unit " + input + ", it is not valid");
        }
        if (this.analysisService.available(context.language())) {
            TransformService.checkAnalyzed(action);
        }
        TA result = this.transformer.transform(input, context, action, config);
        return (TP)result;
    }

    @Override
    public Collection<TA> transform(A input, IContext context, ITransformGoal goal, ITransformConfig config) throws TransformException {
        if (!input.valid()) {
            throw new TransformException("Cannot transform analyze unit " + input + ", it is not valid");
        }
        Iterable<TransformActionContrib> actions = this.actionService.actionContributions(context.language(), goal);
        ArrayList results = Lists.newArrayList();
        for (TransformActionContrib action : actions) {
            if (!TransformService.isActionEnabled(action, context)) {
                logger.info("Skipped action '" + action.action.name() + "' because it is not enabled by the project or a compile dependency.");
                continue;
            }
            TA result = this.transformer.transform(input, context, action, config);
            results.add(result);
        }
        return results;
    }

    @Override
    public TA transform(A input, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        if (!input.valid()) {
            throw new TransformException("Cannot transform parse unit " + input + ", it is not valid");
        }
        TA result = this.transformer.transform(input, context, action, config);
        return result;
    }

    @Override
    public Collection<TP> transformAllParsed(Iterable<P> inputs, IContext context, ITransformGoal goal, ITransformConfig config) throws TransformException {
        Iterable<TransformActionContrib> actions = this.actionService.actionContributions(context.language(), goal);
        ArrayList results = Lists.newArrayList();
        for (TransformActionContrib action : actions) {
            if (this.analysisService.available(context.language())) {
                TransformService.checkAnalyzed(action);
            }
            Collection<TP> result = this.transformer.transformAllParsed(inputs, context, action, config);
            results.addAll(result);
        }
        return results;
    }

    @Override
    public Collection<TP> transformAllParsed(Iterable<P> inputs, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        if (this.analysisService.available(context.language())) {
            TransformService.checkAnalyzed(action);
        }
        Collection<TP> result = this.transformer.transformAllParsed(inputs, context, action, config);
        return result;
    }

    @Override
    public Collection<TA> transformAllAnalyzed(Iterable<A> inputs, IContext context, ITransformGoal goal, ITransformConfig config) throws TransformException {
        Iterable<TransformActionContrib> actions = this.actionService.actionContributions(context.language(), goal);
        ArrayList results = Lists.newArrayList();
        for (TransformActionContrib action : actions) {
            Collection<TA> result = this.transformer.transformAllAnalyzed(inputs, context, action, config);
            results.addAll(result);
        }
        return results;
    }

    @Override
    public Collection<TA> transformAllAnalyzed(Iterable<A> inputs, IContext context, TransformActionContrib action, ITransformConfig config) throws TransformException {
        Collection<TA> result = this.transformer.transformAllAnalyzed(inputs, context, action, config);
        return result;
    }

    private static void checkAnalyzed(TransformActionContrib action) throws TransformException {
        if (!action.action.flags().parsed) {
            String message = logger.format("Transformation {} requires an analyzed result, but a parsed result is given", action);
            throw new TransformException(message);
        }
    }

    private static boolean isActionEnabled(TransformActionContrib action, IContext context) {
        LanguageIdentifier actionContributorId = action.contributor.id();
        return context.project().config().compileDeps().contains(actionContributorId) || context.language().id().equals(actionContributorId);
    }
}

