/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.ParseTable;
import org.metaborg.parsetable.ParseTableReadException;
import org.metaborg.parsetable.actions.ActionType;
import org.metaborg.parsetable.actions.Goto;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IActionsFactory;
import org.metaborg.parsetable.actions.IGoto;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.characterclasses.CharacterClassReader;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.productions.Production;
import org.metaborg.parsetable.productions.ProductionReader;
import org.metaborg.parsetable.productions.ProductionType;
import org.metaborg.parsetable.query.ActionsPerCharacterClass;
import org.metaborg.parsetable.states.IState;
import org.metaborg.parsetable.states.IStateFactory;
import org.metaborg.parsetable.states.State;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

class ParseTableReaderDelegate {
    private final IActionsFactory actionsFactory;
    private final IStateFactory stateFactory;
    private final CharacterClassReader characterClassReader;
    private final ProductionReader productionReader;

    ParseTableReaderDelegate(IActionsFactory actionsFactory, IStateFactory stateFactory, CharacterClassReader characterClassReader, ProductionReader productionReader) {
        this.actionsFactory = actionsFactory;
        this.stateFactory = stateFactory;
        this.characterClassReader = characterClassReader;
        this.productionReader = productionReader;
    }

    public IParseTable read(IStrategoTerm pt) throws ParseTableReadException {
        int startStateId = TermUtils.toJavaIntAt(pt, 1);
        IStrategoList productionsTermList = TermUtils.toListAt(pt, 2);
        IStrategoList statesTermList = TermUtils.toListAt(pt.getSubterm(3), 0);
        IProduction[] productions = this.readProductions(productionsTermList);
        IState[] states = this.readStates(statesTermList, productions);
        this.markRejectableStates(states);
        return new ParseTable(states, startStateId, this.hasLayoutConstraint(productionsTermList));
    }

    private boolean hasLayoutConstraint(IStrategoList productionsTermList) {
        return productionsTermList.toString().contains("term(layout(");
    }

    private IProduction[] readProductions(IStrategoList productionsTermList) throws ParseTableReadException {
        int productionCount = productionsTermList.getSubtermCount();
        IProduction[] productions = new Production[257 + productionCount];
        for (IStrategoTerm productionWithIdTerm : productionsTermList) {
            IProduction production;
            productions[production.id()] = production = this.productionReader.read(productionWithIdTerm);
        }
        return productions;
    }

    private IState[] readStates(IStrategoList statesTermList, IProduction[] productions) throws ParseTableReadException {
        int stateCount = statesTermList.getSubtermCount();
        IState[] states = new IState[stateCount];
        for (IStrategoTerm stateTerm : statesTermList) {
            IState state;
            IStrategoNamed stateTermNamed = (IStrategoNamed)stateTerm;
            int stateId = TermUtils.toJavaIntAt(stateTermNamed, 0);
            IStrategoList gotosTermList = TermUtils.toListAt(stateTermNamed, 1);
            IStrategoList actionsTermList = TermUtils.toListAt(stateTermNamed, 2);
            IGoto[] gotos = this.readGotos(gotosTermList);
            ActionsPerCharacterClass[] actions = this.readActions(actionsTermList, productions);
            states[state.id()] = state = this.stateFactory.from(stateId, gotos, actions);
        }
        return states;
    }

    private IGoto[] readGotos(IStrategoList gotosTermList) {
        int gotoCount = gotosTermList.size();
        IGoto[] gotos = new IGoto[gotoCount];
        int i = 0;
        for (IStrategoTerm subterm : gotosTermList) {
            IStrategoNamed gotoTermNamed = (IStrategoNamed)subterm;
            IStrategoList productionsTermList = TermUtils.toListAt(gotoTermNamed, 0);
            int[] productionIds = this.readGotoProductions(productionsTermList);
            int gotoStateId = TermUtils.toJavaIntAt(gotoTermNamed, 1);
            gotos[i++] = new Goto(productionIds, gotoStateId);
        }
        return gotos;
    }

    private int[] readGotoProductions(IStrategoList productionsTermList) {
        int productionCount = productionsTermList.size();
        int[] productionIds = new int[productionCount];
        int i = 0;
        for (IStrategoTerm productionIdsTerm : productionsTermList) {
            if (!TermUtils.isInt(productionIdsTerm)) continue;
            int productionId = TermUtils.toJavaInt(productionIdsTerm);
            productionIds[i++] = productionId;
        }
        return productionIds;
    }

    private ActionsPerCharacterClass[] readActions(IStrategoList characterClassActionsTermList, IProduction[] productions) throws ParseTableReadException {
        int characterClassesWithActionsCount = characterClassActionsTermList.size();
        ArrayList<ActionsPerCharacterClass> actionsPerCharacterClasses = new ArrayList<ActionsPerCharacterClass>(characterClassesWithActionsCount);
        for (IStrategoTerm characterClassActionsTerm : characterClassActionsTermList) {
            IStrategoNamed characterClassActionsTermNamed = (IStrategoNamed)characterClassActionsTerm;
            IStrategoList characterClassTermList = TermUtils.toListAt(characterClassActionsTermNamed, 0);
            IStrategoList actionsTermList = TermUtils.toListAt(characterClassActionsTermNamed, 1);
            ICharacterClass characterClass = this.characterClassReader.read(characterClassTermList);
            IAction[] actions = this.readActionsForCharacterClass(actionsTermList, productions);
            actionsPerCharacterClasses.add(new ActionsPerCharacterClass(characterClass, actions));
        }
        return actionsPerCharacterClasses.toArray(new ActionsPerCharacterClass[0]);
    }

    private IAction[] readActionsForCharacterClass(IStrategoList actionsTermList, IProduction[] productions) throws ParseTableReadException {
        int actionCount = actionsTermList.size();
        IAction[] actions = new IAction[actionCount];
        int i = 0;
        for (IStrategoTerm subterm : actionsTermList) {
            IStrategoAppl actionTermAppl = (IStrategoAppl)subterm;
            IAction action = null;
            if (actionTermAppl.getName().equals("reduce")) {
                int arity = TermUtils.toJavaIntAt(actionTermAppl, 0);
                int productionId = TermUtils.toJavaIntAt(actionTermAppl, 1);
                ProductionType productionType = Production.typeFromInt(TermUtils.toJavaIntAt(actionTermAppl, 2));
                IProduction production = productions[productionId];
                if (actionTermAppl.getConstructor().getArity() == 3) {
                    action = this.actionsFactory.getReduce(production, productionType, arity);
                } else if (actionTermAppl.getConstructor().getArity() == 4) {
                    ICharacterClass[] followRestriction = this.readReduceLookaheadFollowRestriction(actionTermAppl.getSubterm(3).getSubterm(0));
                    action = this.actionsFactory.getReduceLookahead(production, productionType, arity, followRestriction);
                }
            } else if (actionTermAppl.getName().equals("accept")) {
                action = this.actionsFactory.getAccept();
            } else if (actionTermAppl.getName().equals("shift")) {
                int shiftStateId = TermUtils.toJavaIntAt(actionTermAppl, 0);
                action = this.actionsFactory.getShift(shiftStateId);
            } else {
                throw new IllegalStateException("invalid action type");
            }
            actions[i++] = action;
        }
        return actions;
    }

    private ICharacterClass[] readReduceLookaheadFollowRestriction(IStrategoTerm followRestrictionTerm) throws ParseTableReadException {
        if ("follow-restriction".equals(((IStrategoNamed)followRestrictionTerm).getName())) {
            IStrategoList followRestrictionCharacterClassList = TermUtils.toListAt(followRestrictionTerm, 0);
            int lookaheadLength = followRestrictionCharacterClassList.size();
            ICharacterClass[] followRestrictionCharacterClasses = new ICharacterClass[lookaheadLength];
            int i = 0;
            for (IStrategoTerm characterClassTerm : followRestrictionCharacterClassList) {
                followRestrictionCharacterClasses[i++] = this.characterClassReader.read((IStrategoList)characterClassTerm.getSubterm(0));
            }
            return followRestrictionCharacterClasses;
        }
        throw new ParseTableReadException("invalid follow restriction");
    }

    private void markRejectableStates(IState[] states) {
        Set rejectProductionIds = Stream.of(states).flatMap(state -> Stream.of(((State)state).actions())).filter(this::isReduceOrReduceLookahead).map(IReduce.class::cast).filter(IReduce::isRejectProduction).map(IReduce::production).map(IProduction::id).collect(Collectors.toSet());
        Set<Integer> rejectableStateIds = Stream.of(states).flatMap(state -> rejectProductionIds.stream().filter(((State)state)::hasGoto).map(state::getGotoId)).collect(Collectors.toSet());
        rejectableStateIds.forEach(gotoId -> ((State)states[gotoId]).markRejectable());
    }

    private boolean isReduceOrReduceLookahead(IAction action) {
        return action.actionType() == ActionType.REDUCE || action.actionType() == ActionType.REDUCE_LOOKAHEAD;
    }
}

