/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.productions;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.productions.ProductionAttributes;
import org.metaborg.parsetable.productions.ProductionType;
import org.metaborg.parsetable.symbols.ConcreteSyntaxContext;
import org.metaborg.parsetable.symbols.ILiteralSymbol;
import org.metaborg.parsetable.symbols.ISymbol;

public class Production
implements IProduction {
    private final ISymbol lhs;
    private final ISymbol[] rhs;
    private final ConcreteSyntaxContext concreteSyntaxContext;
    private final int productionId;
    private final boolean isStringLiteral;
    private final boolean isNumberLiteral;
    private final ProductionAttributes attributes;
    private final boolean isListConstructor;

    public Production(int productionId, ISymbol lhs, ISymbol[] rhs, boolean isStringLiteral, boolean isNumberLiteral, boolean isLexicalRhs, ProductionAttributes attributes) {
        this.productionId = productionId;
        this.lhs = lhs;
        this.rhs = rhs;
        this.isStringLiteral = isStringLiteral;
        this.isNumberLiteral = isNumberLiteral;
        this.attributes = attributes;
        this.isListConstructor = IProduction.isListConstructor(attributes.constructor);
        this.concreteSyntaxContext = lhs.concreteSyntaxContext() == ConcreteSyntaxContext.Layout ? ConcreteSyntaxContext.Layout : (lhs.concreteSyntaxContext() == ConcreteSyntaxContext.Literal ? ConcreteSyntaxContext.Literal : (lhs.concreteSyntaxContext() == ConcreteSyntaxContext.Lexical || isLexicalRhs ? ConcreteSyntaxContext.Lexical : ConcreteSyntaxContext.ContextFree));
    }

    @Override
    public int id() {
        return this.productionId;
    }

    @Override
    public ISymbol lhs() {
        return this.lhs;
    }

    public static ProductionType typeFromInt(int productionType) {
        switch (productionType) {
            case 1: {
                return ProductionType.REJECT;
            }
            case 2: {
                return ProductionType.PREFER;
            }
            case 4: {
                return ProductionType.AVOID;
            }
        }
        return ProductionType.NO_TYPE;
    }

    @Override
    public String sort() {
        return ISymbol.getSort(this.lhs);
    }

    @Override
    public String startSymbolSort() {
        if ("<START>".equals(this.sort())) {
            ISymbol[] iSymbolArray = this.rhs;
            int n = this.rhs.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbol symbol = iSymbolArray[n2];
                String sort = ISymbol.getSort(symbol);
                if (sort != null) {
                    return sort;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String constructor() {
        if (!this.isListConstructor) {
            return this.attributes.constructor;
        }
        return null;
    }

    @Override
    public String descriptor() {
        return String.valueOf(this.lhs.toString()) + (this.constructor() != null ? "." + this.constructor() : "") + " = " + Arrays.stream(this.rhs).map(Object::toString).collect(Collectors.joining(" "));
    }

    @Override
    public ConcreteSyntaxContext concreteSyntaxContext() {
        return this.concreteSyntaxContext;
    }

    @Override
    public boolean isContextFree() {
        return this.concreteSyntaxContext == ConcreteSyntaxContext.ContextFree;
    }

    @Override
    public boolean isLayout() {
        return this.concreteSyntaxContext == ConcreteSyntaxContext.Layout;
    }

    @Override
    public boolean isLiteral() {
        return this.concreteSyntaxContext == ConcreteSyntaxContext.Literal;
    }

    @Override
    public boolean isLexical() {
        return this.concreteSyntaxContext == ConcreteSyntaxContext.Lexical;
    }

    @Override
    public boolean isList() {
        return this.lhs.cardinality() != null && this.lhs.cardinality().isList || this.isListConstructor || this.attributes.isFlatten;
    }

    @Override
    public boolean isOptional() {
        return this.lhs.cardinality() != null && this.lhs.cardinality().isOptional;
    }

    @Override
    public boolean isStringLiteral() {
        return this.isStringLiteral;
    }

    @Override
    public boolean isNumberLiteral() {
        return this.isNumberLiteral;
    }

    @Override
    public boolean isOperator() {
        return this.isLiteral() && ((ILiteralSymbol)this.lhs).isOperator();
    }

    @Override
    public boolean isRecovery() {
        return this.attributes.isRecovery;
    }

    @Override
    public boolean isCompletion() {
        return this.attributes.isCompletion();
    }

    public String toString() {
        return this.descriptor();
    }

    public int hashCode() {
        return this.productionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Production that = (Production)o;
        return this.productionId == that.productionId;
    }

    @Override
    public boolean isIgnoreLayoutConstraint() {
        return this.attributes.isIgnoreLayout;
    }

    @Override
    public boolean isLongestMatch() {
        return this.attributes.isLongestMatch;
    }

    @Override
    public boolean isBracket() {
        return this.attributes.isBracket;
    }
}

