/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.productions;

import java.util.Iterator;
import org.metaborg.parsetable.ParseTableReadException;
import org.metaborg.parsetable.characterclasses.CharacterClassReader;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.productions.Production;
import org.metaborg.parsetable.productions.ProductionAttributes;
import org.metaborg.parsetable.productions.ProductionType;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.parsetable.symbols.SymbolReader;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.TermVisitor;
import org.spoofax.terms.util.TermUtils;

public class ProductionReader {
    private final CharacterClassReader characterClassReader;

    public ProductionReader(CharacterClassReader characterClassReader) {
        this.characterClassReader = characterClassReader;
    }

    public IProduction read(IStrategoTerm productionWithIdTerm) throws ParseTableReadException {
        int productionId = TermUtils.toJavaIntAt(productionWithIdTerm, 1);
        IStrategoAppl productionTerm = TermUtils.toApplAt(productionWithIdTerm, 0);
        IStrategoAppl lhsTerm = TermUtils.toApplAt(productionTerm, 1);
        IStrategoList rhsTerm = TermUtils.toListAt(productionTerm, 0);
        IStrategoAppl attributesTerm = TermUtils.toApplAt(productionTerm, 2);
        SymbolReader symbolReader = new SymbolReader(this.characterClassReader);
        ISymbol lhs = symbolReader.read(lhsTerm);
        ISymbol[] rhs = new ISymbol[rhsTerm.size()];
        int i = 0;
        while (i < rhsTerm.size()) {
            rhs[i] = symbolReader.read((IStrategoAppl)rhsTerm.getSubterm(i));
            ++i;
        }
        boolean isStringLiteral = this.getIsStringLiteral(rhsTerm);
        boolean isNumberLiteral = this.getIsNumberLiteral(rhsTerm);
        boolean isLexicalRhs = this.getIsLexicalRhs(rhsTerm);
        ProductionAttributes attributes = this.readProductionAttributes(attributesTerm);
        return new Production(productionId, lhs, rhs, isStringLiteral, isNumberLiteral, isLexicalRhs, attributes);
    }

    private boolean getIsLexicalRhs(IStrategoList rhs) {
        if (rhs.getSubtermCount() > 0) {
            IStrategoTerm[] iStrategoTermArray = rhs.getAllSubterms();
            int n = iStrategoTermArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm rhsPart = iStrategoTermArray[n2];
                if (!"char-class".equals(((IStrategoAppl)rhsPart).getConstructor().getName())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private boolean getIsStringLiteral(IStrategoTerm rhs) {
        return this.topdownHasSpaces(rhs);
    }

    private boolean getIsNumberLiteral(IStrategoTerm rhs) {
        IStrategoTerm range = this.getFirstRange(rhs);
        return range != null && TermUtils.toJavaIntAt(range, 0) == 48 && TermUtils.toJavaIntAt(range, 1) == 57;
    }

    private boolean topdownHasSpaces(IStrategoTerm term) {
        Iterator<IStrategoTerm> iterator = TermVisitor.tryGetListIterator(term);
        int i = 0;
        int max2 = term.getSubtermCount();
        while (i < max2) {
            IStrategoTerm child;
            IStrategoTerm iStrategoTerm = child = iterator == null ? term.getSubterm(i) : iterator.next();
            if (this.isRangeAppl(child)) {
                int start = TermUtils.toJavaIntAt(child, 0);
                int end = TermUtils.toJavaIntAt(child, 1);
                if (start <= 32 && 32 <= end) {
                    return true;
                }
            } else if (this.topdownHasSpaces(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRangeAppl(IStrategoTerm child) {
        return TermUtils.isAppl(child) && ((IStrategoAppl)child).getName().equals("range");
    }

    private IStrategoTerm getFirstRange(IStrategoTerm term) {
        int i = 0;
        while (i < term.getSubtermCount()) {
            IStrategoTerm child = term.getSubterm(i);
            if (this.isRangeAppl(child)) {
                return child;
            }
            if ((child = this.getFirstRange(child)) != null) {
                return child;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private ProductionAttributes readProductionAttributes(IStrategoAppl attributesTerm) throws ParseTableReadException {
        if (!attributesTerm.getName().equals("attrs")) {
            if (!attributesTerm.getName().equals("no-attrs")) throw new ParseTableReadException("Unknown production attribute type: " + attributesTerm);
            return new ProductionAttributes(ProductionType.NO_TYPE, null, false, false, false, false, false, false, false, false, false, false, false);
        }
        ProductionType type = ProductionType.NO_TYPE;
        IStrategoTerm constructor = null;
        boolean isRecover = false;
        boolean isBracket = false;
        boolean isCompletion = false;
        boolean isPlaceholderInsertion = false;
        boolean isLiteralCompletion = false;
        boolean isIgnoreLayout = false;
        boolean isNewlineEnforced = false;
        boolean isLongestMatch = false;
        boolean isCaseInsensitive = false;
        boolean isIndentPaddingLexical = false;
        boolean isFlatten = false;
        IStrategoList attributesTermsList = (IStrategoList)attributesTerm.getSubterm(0);
        block44: for (IStrategoTerm attributeTerm : attributesTermsList) {
            String attributeName;
            IStrategoNamed attributeTermNamed = (IStrategoNamed)attributeTerm;
            block10 : switch (attributeName = attributeTermNamed.getName()) {
                case "reject": {
                    type = ProductionType.REJECT;
                    break;
                }
                case "prefer": {
                    type = ProductionType.PREFER;
                    break;
                }
                case "avoid": {
                    type = ProductionType.AVOID;
                    break;
                }
                case "term": {
                    if (!(attributeTermNamed.getSubterm(0) instanceof IStrategoNamed)) continue block44;
                    IStrategoNamed attributeValueTermNamed = (IStrategoNamed)attributeTermNamed.getSubterm(0);
                    int subtermCount = attributeValueTermNamed.getSubtermCount();
                    String name = attributeValueTermNamed.getName();
                    if (subtermCount == 0) {
                        switch (name) {
                            case "recover": {
                                isRecover = true;
                                break block10;
                            }
                            case "completion": {
                                isCompletion = true;
                                break block10;
                            }
                            case "placeholder-insertion": {
                                isPlaceholderInsertion = true;
                                break block10;
                            }
                            case "literal-completion": {
                                isLiteralCompletion = true;
                                break block10;
                            }
                            case "ignore-indent": 
                            case "ignore-layout": 
                            case "no-lc": {
                                isIgnoreLayout = true;
                                break block10;
                            }
                            case "enforce-newline": {
                                isNewlineEnforced = true;
                                break block10;
                            }
                            case "longest-match": {
                                isLongestMatch = true;
                                break block10;
                            }
                            case "case-insensitive": {
                                isCaseInsensitive = true;
                                break block10;
                            }
                            case "indentpadding": {
                                isIndentPaddingLexical = true;
                                break block10;
                            }
                            case "flatten": {
                                isFlatten = true;
                                break block10;
                            }
                        }
                        break;
                    }
                    if (subtermCount != 1 || !name.equals("cons") || constructor != null) continue block44;
                    constructor = attributeValueTermNamed.getSubterm(0);
                    break;
                }
                case "id": {
                    constructor = attributeTermNamed.getSubterm(0);
                    break;
                }
                default: {
                    throw new ParseTableReadException("Unknown production attribute: " + attributeName);
                }
                case "deprecated": 
                case "assoc": 
                case "bracket": 
            }
        }
        return new ProductionAttributes(type, constructor, isRecover, isBracket, isCompletion, isPlaceholderInsertion, isLiteralCompletion, isIgnoreLayout, isNewlineEnforced, isLongestMatch, isCaseInsensitive, isIndentPaddingLexical, isFlatten);
    }
}

