/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.states;

import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.query.IActionQuery;
import org.metaborg.parsetable.query.IActionsForCharacter;
import org.metaborg.parsetable.query.IProductionToGoto;
import org.metaborg.parsetable.states.IState;

public final class State
implements IState {
    private final int stateId;
    private boolean rejectable;
    private final IActionsForCharacter actionsForCharacter;
    private final IProductionToGoto productionToGoto;

    public State(int stateId, IActionsForCharacter actionsForCharacter, IProductionToGoto productionToGoto) {
        this.stateId = stateId;
        this.actionsForCharacter = actionsForCharacter;
        this.productionToGoto = productionToGoto;
        this.rejectable = false;
    }

    @Override
    public int id() {
        return this.stateId;
    }

    @Override
    public boolean isRejectable() {
        return this.rejectable;
    }

    public void markRejectable() {
        this.rejectable = true;
    }

    public IAction[] actions() {
        return this.actionsForCharacter.getActions();
    }

    @Override
    public Iterable<IAction> getApplicableActions(IActionQuery actionQuery) {
        return this.actionsForCharacter.getApplicableActions(actionQuery);
    }

    @Override
    public Iterable<IReduce> getApplicableReduceActions(IActionQuery actionQuery) {
        return this.actionsForCharacter.getApplicableReduceActions(actionQuery);
    }

    public boolean hasGoto(int productionId) {
        return this.productionToGoto.contains(productionId);
    }

    @Override
    public int getGotoId(int productionId) {
        return this.productionToGoto.get(productionId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof State)) {
            return false;
        }
        State otherState = (State)obj;
        return this.stateId == otherState.stateId;
    }
}

