/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.engine;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.runtime.task.digest.NonDeterministicCountingTermDigester;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.engine.TaskEngine;
import org.metaborg.runtime.task.engine.TaskEngineFactory;
import org.metaborg.runtime.task.evaluation.TaskEvaluationQueue;
import org.metaborg.runtime.task.specific.RelationMatchTask;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.binary.SAFWriter;
import org.spoofax.terms.io.binary.TermReader;

public class TaskManager {
    public static ITaskEngine create(ITermFactory termFactory) {
        TaskEngine taskEngine = new TaskEngine(termFactory, new NonDeterministicCountingTermDigester());
        TaskEvaluationQueue taskEvaluationFrontend = new TaskEvaluationQueue(taskEngine, termFactory);
        RelationMatchTask.register(taskEvaluationFrontend, termFactory);
        taskEngine.setEvaluationFrontend(taskEvaluationFrontend);
        return taskEngine;
    }

    public static ITaskEngine read(FileObject taskEngineFile, ITermFactory termFactory) throws ParseError, IOException {
        IStrategoTerm term = TaskManager.readTerm(taskEngineFile, termFactory);
        TaskEngineFactory factory = TaskManager.factory();
        ITaskEngine taskEngine = TaskManager.create(termFactory);
        return factory.fromTerms(taskEngine, term, termFactory);
    }

    public static void write(ITaskEngine taskEngine, FileObject taskEngineFile, ITermFactory termFactory) throws IOException {
        taskEngineFile.createFile();
        TaskEngineFactory factory = TaskManager.factory();
        IStrategoTerm term = factory.toTerm(taskEngine, termFactory);
        TaskManager.writeTerm(taskEngineFile, term);
    }

    private static TaskEngineFactory factory() {
        return new TaskEngineFactory();
    }

    private static IStrategoTerm readTerm(FileObject file, ITermFactory termFactory) throws ParseError, IOException {
        TermReader termReader = new TermReader(termFactory);
        return termReader.parseFromStream(file.getContent().getInputStream());
    }

    private static void writeTerm(FileObject file, IStrategoTerm term) throws IOException {
        file.createFile();
        try (OutputStream output = file.getContent().getOutputStream();){
            SAFWriter.writeTermToSAFStream(term, output);
            output.flush();
        }
    }
}

