/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.ConstructorAttribute;
import org.metaborg.sdf2table.grammar.GrammarFactory;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.INormGrammar;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.ProductionReference;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.UniqueProduction;

public class NormGrammar
implements INormGrammar,
Serializable {
    private static final long serialVersionUID = -13739894962185282L;
    private final Set<File> filesRead = Sets.newHashSet();
    private final GrammarFactory gf = new GrammarFactory();
    private IProduction initialProduction;
    private final Set<ISymbol> symbols;
    private final Map<ProductionReference, Production> sortConsProductionMapping;
    private final SetMultimap<IProduction, IAttribute> productionAttributesMapping;
    private final Map<IProduction, ConstructorAttribute> constructors;
    private final Map<UniqueProduction, Production> uniqueProductionMapping = Maps.newLinkedHashMap();
    private final BiMap<Production, ContextualProduction> prodContextualProdMapping;
    private final Set<ContextualProduction> derivedContextualProds;
    private final Set<ContextualSymbol> contextualSymbols;
    private final SetMultimap<ISymbol, ISymbol> leftRecursiveSymbolsMapping;
    private final SetMultimap<ISymbol, ISymbol> rightRecursiveSymbolsMapping;
    private final SetMultimap<Symbol, Production> longestMatchProdsFront;
    private final SetMultimap<Symbol, Production> shortestMatchProdsFront;
    private final SetMultimap<Symbol, Production> longestMatchProdsBack;
    private final SetMultimap<Symbol, Production> shortestMatchProdsBack;
    private final Set<Priority> transitivePriorities;
    private final Set<Priority> nonTransitivePriorities;
    private final SetMultimap<Priority, Integer> priorities;
    private final SetMultimap<Priority, Integer> indexedPriorities;
    private final Set<Production> productionsOnPriorities;
    private final SetMultimap<Priority, Integer> transitivePriorityArgs;
    private final SetMultimap<Priority, Integer> nonTransitivePriorityArgs;
    private final SetMultimap<Production, Priority> higherPriorityProductions;
    private final SetMultimap<String, String> nonAssocPriorities;
    private final SetMultimap<String, String> nonNestedPriorities;
    private final HashMap<String, Symbol> cacheSymbolsRead;
    private final HashMap<String, Production> cacheProductionsRead;
    private final SetMultimap<ISymbol, IProduction> symbolProductionsMapping;
    private final SetMultimap<ISymbol, IProduction> literalProductionsMapping;
    private final SetMultimap<ISymbol, IProduction> expressionGrammars;
    private final Set<Set<IProduction>> combinedExpressionGrammars;
    private final SetMultimap<Symbol, Symbol> indirectlyRecursive;
    private final SetMultimap<Symbol, Symbol> nonRecursive;
    private final SetMultimap<ISymbol, ISymbol> leftDerivable;
    private final SetMultimap<ISymbol, ISymbol> rightDerivable;

    public NormGrammar() {
        this.sortConsProductionMapping = Maps.newHashMap();
        this.prodContextualProdMapping = HashBiMap.create();
        this.leftRecursiveSymbolsMapping = HashMultimap.create();
        this.rightRecursiveSymbolsMapping = HashMultimap.create();
        this.derivedContextualProds = Sets.newHashSet();
        this.contextualSymbols = Sets.newHashSet();
        this.longestMatchProdsFront = LinkedHashMultimap.create();
        this.longestMatchProdsBack = LinkedHashMultimap.create();
        this.shortestMatchProdsFront = LinkedHashMultimap.create();
        this.shortestMatchProdsBack = LinkedHashMultimap.create();
        this.productionAttributesMapping = HashMultimap.create();
        this.priorities = HashMultimap.create();
        this.indexedPriorities = HashMultimap.create();
        this.constructors = Maps.newHashMap();
        this.transitivePriorities = Sets.newHashSet();
        this.nonTransitivePriorities = Sets.newHashSet();
        this.productionsOnPriorities = Sets.newHashSet();
        this.transitivePriorityArgs = HashMultimap.create();
        this.nonTransitivePriorityArgs = HashMultimap.create();
        this.higherPriorityProductions = HashMultimap.create();
        this.nonAssocPriorities = HashMultimap.create();
        this.nonNestedPriorities = HashMultimap.create();
        this.symbolProductionsMapping = HashMultimap.create();
        this.cacheSymbolsRead = Maps.newHashMap();
        this.cacheProductionsRead = Maps.newHashMap();
        this.symbols = Sets.newHashSet();
        this.literalProductionsMapping = HashMultimap.create();
        this.expressionGrammars = HashMultimap.create();
        this.combinedExpressionGrammars = Sets.newHashSet();
        this.indirectlyRecursive = HashMultimap.create();
        this.nonRecursive = HashMultimap.create();
        this.leftDerivable = HashMultimap.create();
        this.rightDerivable = HashMultimap.create();
    }

    public Map<UniqueProduction, Production> syntax() {
        return this.getUniqueProductionMapping();
    }

    public void priorityTransitiveClosure() {
        for (Production intermediate_prod : this.getProductionsOnPriorities()) {
            for (Production first_prod : this.getProductionsOnPriorities()) {
                for (Production second_prod : this.getProductionsOnPriorities()) {
                    Priority first_sec = this.gf.createPriority(first_prod, second_prod, true);
                    Priority first_k = this.gf.createPriority(first_prod, intermediate_prod, true);
                    Priority k_second = this.gf.createPriority(intermediate_prod, second_prod, true);
                    if (!this.getTransitivePriorities().contains(first_sec)) {
                        if (!this.getTransitivePriorities().contains(first_k) || !this.getTransitivePriorities().contains(k_second)) continue;
                        this.getTransitivePriorities().add(first_sec);
                        this.getTransitivePriorityArgs().putAll((Object)first_sec, (Iterable)this.getTransitivePriorityArgs().get((Object)first_k));
                        continue;
                    }
                    if (!this.getTransitivePriorities().contains(first_k) || !this.getTransitivePriorities().contains(k_second)) continue;
                    this.getTransitivePriorityArgs().putAll((Object)first_sec, (Iterable)this.getTransitivePriorityArgs().get((Object)first_k));
                }
            }
        }
        this.priorities.putAll(this.getNonTransitivePriorityArgs());
        this.priorities.putAll(this.getTransitivePriorityArgs());
    }

    public IProduction getInitialProduction() {
        return this.initialProduction;
    }

    public SetMultimap<Priority, Integer> priorities() {
        return this.priorities;
    }

    public Set<File> getFilesRead() {
        return this.filesRead;
    }

    public Set<ISymbol> getSymbols() {
        return this.symbols;
    }

    public Map<ProductionReference, Production> getSortConsProductionMapping() {
        return this.sortConsProductionMapping;
    }

    public SetMultimap<IProduction, IAttribute> getProductionAttributesMapping() {
        return this.productionAttributesMapping;
    }

    public Map<UniqueProduction, Production> getUniqueProductionMapping() {
        return this.uniqueProductionMapping;
    }

    public BiMap<Production, ContextualProduction> getProdContextualProdMapping() {
        return this.prodContextualProdMapping;
    }

    public Set<ContextualProduction> getDerivedContextualProds() {
        return this.derivedContextualProds;
    }

    public Set<ContextualSymbol> getContextualSymbols() {
        return this.contextualSymbols;
    }

    public SetMultimap<ISymbol, ISymbol> getLeftRecursiveSymbolsMapping() {
        return this.leftRecursiveSymbolsMapping;
    }

    public SetMultimap<ISymbol, ISymbol> getRightRecursiveSymbolsMapping() {
        return this.rightRecursiveSymbolsMapping;
    }

    public SetMultimap<Symbol, Production> getLongestMatchProdsFront() {
        return this.longestMatchProdsFront;
    }

    public SetMultimap<Symbol, Production> getLongestMatchProdsBack() {
        return this.longestMatchProdsBack;
    }

    public SetMultimap<Symbol, Production> getShortestMatchProdsFront() {
        return this.shortestMatchProdsFront;
    }

    public SetMultimap<Symbol, Production> getShortestMatchProdsBack() {
        return this.shortestMatchProdsBack;
    }

    public Set<Priority> getTransitivePriorities() {
        return this.transitivePriorities;
    }

    public Set<Priority> getNonTransitivePriorities() {
        return this.nonTransitivePriorities;
    }

    public Set<Production> getProductionsOnPriorities() {
        return this.productionsOnPriorities;
    }

    public SetMultimap<Priority, Integer> getTransitivePriorityArgs() {
        return this.transitivePriorityArgs;
    }

    public SetMultimap<Priority, Integer> getNonTransitivePriorityArgs() {
        return this.nonTransitivePriorityArgs;
    }

    public HashMap<String, Symbol> getCacheSymbolsRead() {
        return this.cacheSymbolsRead;
    }

    public HashMap<String, Production> getCacheProductionsRead() {
        return this.cacheProductionsRead;
    }

    public SetMultimap<ISymbol, IProduction> getSymbolProductionsMapping() {
        return this.symbolProductionsMapping;
    }

    public SetMultimap<Production, Priority> getHigherPriorityProductions() {
        return this.higherPriorityProductions;
    }

    public void normalizeFollowRestrictionLookahead() {
        for (ISymbol s : this.symbols) {
            s.normalizeFollowRestrictionLookahead();
        }
    }

    public Map<IProduction, ConstructorAttribute> getConstructors() {
        return this.constructors;
    }

    public SetMultimap<ISymbol, IProduction> getLiteralProductionsMapping() {
        return this.literalProductionsMapping;
    }

    public SetMultimap<ISymbol, IProduction> getExpressionGrammars() {
        return this.expressionGrammars;
    }

    public SetMultimap<Symbol, Symbol> getIndirectlyRecursive() {
        return this.indirectlyRecursive;
    }

    public SetMultimap<Symbol, Symbol> getNonRecursive() {
        return this.nonRecursive;
    }

    public Set<Set<IProduction>> getCombinedExpressionGrammars() {
        return this.combinedExpressionGrammars;
    }

    public SetMultimap<String, String> getNonAssocPriorities() {
        return this.nonAssocPriorities;
    }

    public void setInitialProduction(Production prod) {
        this.initialProduction = prod;
    }

    public SetMultimap<Priority, Integer> getIndexedPriorities() {
        return this.indexedPriorities;
    }

    public SetMultimap<String, String> getNonNestedPriorities() {
        return this.nonNestedPriorities;
    }

    public GrammarFactory getGrammarFactory() {
        return this.gf;
    }

    public void cleanupGrammar() {
        this.cacheProductionsRead.clear();
        this.cacheSymbolsRead.clear();
        this.combinedExpressionGrammars.clear();
        this.contextualSymbols.clear();
        this.derivedContextualProds.clear();
        this.expressionGrammars.clear();
        this.indirectlyRecursive.clear();
        this.leftRecursiveSymbolsMapping.clear();
        this.rightRecursiveSymbolsMapping.clear();
        this.literalProductionsMapping.clear();
        this.longestMatchProdsBack.clear();
        this.longestMatchProdsFront.clear();
        this.nonAssocPriorities.clear();
        this.nonNestedPriorities.clear();
        this.nonRecursive.clear();
        this.nonTransitivePriorities.clear();
        this.nonTransitivePriorityArgs.clear();
        this.productionsOnPriorities.clear();
        this.symbolProductionsMapping.clear();
        this.transitivePriorities.clear();
        this.transitivePriorityArgs.clear();
        this.filesRead.clear();
    }

    public SetMultimap<ISymbol, ISymbol> getLeftDerivable() {
        return this.leftDerivable;
    }

    public SetMultimap<ISymbol, ISymbol> getRightDerivable() {
        return this.rightDerivable;
    }
}

