/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.symbols.SortCardinality;
import org.metaborg.parsetable.symbols.SyntaxContext;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.grammar.AltSymbol;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.IterSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.IterSymbol;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.Sort;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class Symbol
implements Serializable,
ISymbol {
    private static final long serialVersionUID = -9135946758836485558L;
    protected ICharacterClass followRestrictionsNoLookahead;
    protected List<ICharacterClass[]> followRestrictionsLookahead;
    private boolean nullable = false;

    @Override
    public abstract String name();

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public ICharacterClass followRestriction() {
        return this.followRestrictionsNoLookahead;
    }

    @Override
    public List<ICharacterClass[]> followRestrictionLookahead() {
        return this.followRestrictionsLookahead;
    }

    public void addFollowRestrictionsLookahead(List<ICharacterClass[]> frlList) {
        for (ICharacterClass[] frl : frlList) {
            if (frl.length != 2) {
                this.followRestrictionsLookahead.add(frl);
                continue;
            }
            boolean merged = false;
            for (ICharacterClass[] currentFRL : this.followRestrictionsLookahead) {
                ICharacterClass intersection;
                boolean equals;
                if (currentFRL.length != 2 || !(equals = (intersection = currentFRL[0].intersection(frl[0])).equals(currentFRL[0]))) continue;
                currentFRL[1] = currentFRL[1].union(frl[1]);
                merged = true;
            }
            if (merged) continue;
            this.followRestrictionsLookahead.add(frl);
        }
    }

    public void addFollowRestriction(ICharacterClass fr) {
        this.followRestrictionsNoLookahead = this.followRestrictionsNoLookahead == null ? fr : this.followRestrictionsNoLookahead.union(fr);
    }

    @Override
    public void normalizeFollowRestrictionLookahead() {
        if (this.followRestrictionsNoLookahead == null || this.followRestrictionsLookahead.isEmpty()) {
            return;
        }
        ArrayList redundantFRLookahead = Lists.newArrayList();
        for (ICharacterClass[] fr : this.followRestrictionsLookahead) {
            ICharacterClass intersection = fr[0].intersection(this.followRestrictionsNoLookahead);
            if (intersection.equals(fr[0])) {
                redundantFRLookahead.add(fr);
                continue;
            }
            fr[0] = fr[0].difference(intersection);
        }
        this.followRestrictionsLookahead.removeAll(redundantFRLookahead);
    }

    public static String getSort(ISymbol s) {
        if (s instanceof Sort && ((Sort)s).getType() == null) {
            return s.name();
        }
        if (s instanceof ContextFreeSymbol) {
            return Symbol.getSort(((ContextFreeSymbol)s).getSymbol());
        }
        if (s instanceof LexicalSymbol) {
            return Symbol.getSort(((LexicalSymbol)s).getSymbol());
        }
        if (s instanceof AltSymbol) {
            return String.valueOf(Symbol.getSort(((AltSymbol)s).left())) + "_" + Symbol.getSort(((AltSymbol)s).right());
        }
        return null;
    }

    public static boolean isListNonTerminal(ISymbol s) {
        if (s instanceof ContextFreeSymbol) {
            s = ((ContextFreeSymbol)s).getSymbol();
        } else if (s instanceof LexicalSymbol) {
            s = ((LexicalSymbol)s).getSymbol();
        }
        return s instanceof IterSepSymbol || s instanceof IterStarSepSymbol || s instanceof IterStarSymbol || s instanceof IterSymbol;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract IStrategoTerm toAterm(ITermFactory var1);

    public abstract IStrategoTerm toSDF3Aterm(ITermFactory var1, Map<Set<Context>, Integer> var2, Integer var3);

    @Override
    public org.metaborg.parsetable.symbols.ISymbol toParseTableSymbol() {
        return this.toParseTableSymbol(null, null);
    }

    public abstract org.metaborg.parsetable.symbols.ISymbol toParseTableSymbol(SyntaxContext var1, SortCardinality var2);
}

