/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.io;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.sdf2table.exceptions.ModuleNotFoundException;
import org.metaborg.sdf2table.exceptions.UnexpectedTermException;
import org.metaborg.sdf2table.grammar.ConstructorAttribute;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.FileStartSymbol;
import org.metaborg.sdf2table.grammar.GrammarFactory;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.LiteralType;
import org.metaborg.sdf2table.grammar.NormGrammar;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.ProductionReference;
import org.metaborg.sdf2table.grammar.Sort;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.UniqueProduction;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.io.binary.TermReader;
import org.spoofax.terms.util.TermUtils;

public class NormGrammarReader {
    private final Map<String, IStrategoTerm> moduleAsts = Maps.newHashMap();
    private final Set<String> processedModules = new HashSet<String>();
    private final NormGrammar grammar = new NormGrammar();
    private final List<String> paths;
    private final Collection<FileVisitor> fileVisitors;
    private final List<IStrategoAppl> prioritySections;
    private final GrammarFactory gf;

    public NormGrammarReader() {
        this.paths = Collections.emptyList();
        this.fileVisitors = new LinkedList<FileVisitor>();
        this.prioritySections = Lists.newArrayList();
        this.gf = this.grammar.getGrammarFactory();
    }

    public NormGrammarReader(List<String> paths) {
        this.paths = paths;
        this.fileVisitors = new LinkedList<FileVisitor>();
        this.prioritySections = Lists.newArrayList();
        this.gf = this.grammar.getGrammarFactory();
    }

    public void accept(FileVisitor fileVisitor) {
        this.fileVisitors.add(fileVisitor);
    }

    public void addModuleAst(IStrategoTerm module) {
        IStrategoAppl app;
        if (module instanceof IStrategoAppl && (app = (IStrategoAppl)module).getName().equals("Module")) {
            String modName = NormGrammarReader.moduleName(app);
            this.moduleAsts.put(modName, module);
        }
    }

    public NormGrammar readGrammar(File input) throws Exception {
        IStrategoTerm mainModule = this.termFromFile(input);
        return this.readGrammar(mainModule);
    }

    public NormGrammar readGrammar(IStrategoTerm mainModule) throws Exception {
        this.readModule(mainModule);
        for (IStrategoAppl section : this.prioritySections) {
            this.addPriorities(section);
        }
        this.grammar.priorityTransitiveClosure();
        this.grammar.normalizeFollowRestrictionLookahead();
        this.normalizeIndexedPriorities();
        return this.grammar;
    }

    private void normalizeIndexedPriorities() {
        for (Priority p : this.grammar.priorities().keys()) {
            for (Integer arg : this.grammar.priorities().get((Object)p)) {
                if (arg == -1 || arg == Integer.MIN_VALUE || arg == Integer.MAX_VALUE) continue;
                this.grammar.getIndexedPriorities().put((Object)p, (Object)arg);
            }
        }
        for (Priority p : this.grammar.getIndexedPriorities().keys()) {
            for (Integer arg : this.grammar.getIndexedPriorities().get((Object)p)) {
                this.grammar.priorities().get((Object)p).remove(arg);
            }
        }
    }

    private void readModule(IStrategoTerm module) throws Exception {
        block26: {
            IStrategoAppl app;
            if (!(module instanceof IStrategoAppl) || !(app = (IStrategoAppl)module).getName().equals("Module")) break block26;
            String modName = NormGrammarReader.moduleName(app);
            if (this.processedModules.contains(modName)) {
                return;
            }
            this.processedModules.add(modName);
            for (IStrategoTerm t : TermUtils.toListAt(app, 1)) {
                if (!(t instanceof IStrategoAppl) || !((IStrategoAppl)t).getName().equals("Imports")) continue;
                for (IStrategoTerm timport : TermUtils.toListAt(t, 0)) {
                    String iname;
                    if (!TermUtils.isAppl(timport, "Module") || (iname = NormGrammarReader.importName(timport)) == null) continue;
                    IStrategoTerm iModule = this.moduleAsts.get(iname);
                    if (iModule == null) {
                        for (String path : this.paths) {
                            String filename = String.valueOf(path) + "/" + iname + ".aterm";
                            File file = new File(filename);
                            if (!file.exists() || file.isDirectory()) continue;
                            iModule = this.termFromFile(file);
                            break;
                        }
                    }
                    if (iModule == null) {
                        throw new ModuleNotFoundException(iname, modName);
                    }
                    this.readModule(iModule);
                }
            }
            IStrategoList sdf_sections = TermUtils.toListAt(app, 2);
            for (IStrategoTerm t : sdf_sections) {
                IStrategoAppl tsection = null;
                if (!(t.getSubterm(0) instanceof IStrategoAppl)) continue;
                tsection = (IStrategoAppl)t.getSubterm(0);
                switch (tsection.getName()) {
                    case "ContextFreeSyntax": {
                        this.addProds(tsection);
                        break;
                    }
                    case "LexicalSyntax": {
                        this.addProds(tsection);
                        break;
                    }
                    case "Kernel": {
                        this.addProds(tsection);
                        break;
                    }
                    case "Restrictions": {
                        this.addRestrictions(tsection);
                        break;
                    }
                    case "Priorities": {
                        this.prioritySections.add(tsection);
                        break;
                    }
                    default: {
                        System.err.println("Unknown module section `" + tsection.getName() + "'");
                    }
                }
            }
        }
    }

    private void addProds(IStrategoAppl section) throws Exception {
        block4: {
            block5: {
                block3: {
                    if (!TermUtils.isAppl((IStrategoTerm)section, "ContextFreeSyntax")) break block3;
                    IStrategoList sdf_productions = TermUtils.toListAt(section, 0);
                    for (IStrategoTerm t : sdf_productions) {
                        this.processProduction(t);
                    }
                    break block4;
                }
                if (!TermUtils.isAppl((IStrategoTerm)section, "LexicalSyntax")) break block5;
                IStrategoList sdf_productions = TermUtils.toListAt(section, 0);
                for (IStrategoTerm t : sdf_productions) {
                    this.processProduction(t);
                }
                break block4;
            }
            if (!TermUtils.isAppl((IStrategoTerm)section, "Kernel")) break block4;
            IStrategoList sdf_productions = TermUtils.toListAt(section, 0);
            for (IStrategoTerm t : sdf_productions) {
                this.processProduction(t);
            }
        }
    }

    private Production processProduction(IStrategoTerm term) throws Exception {
        block34: {
            block35: {
                Symbol symbol;
                Production prod = null;
                prod = this.grammar.getCacheProductionsRead().get(term.toString());
                if (prod != null) {
                    return prod;
                }
                if (!TermUtils.isAppl(term)) break block34;
                IStrategoAppl app = (IStrategoAppl)term;
                boolean with_cons = false;
                if (!app.getName().equals("SdfProduction") && !(with_cons = app.getName().equals("SdfProductionWithCons"))) break block35;
                String cons = null;
                ConstructorAttribute cons_attr = null;
                ArrayList rhs_symbols = Lists.newArrayList();
                HashSet literals = Sets.newHashSet();
                if (with_cons) {
                    symbol = this.processSymbol(app.getSubterm(0).getSubterm(0));
                    cons = ((IStrategoString)app.getSubterm(0).getSubterm(1).getSubterm(0)).stringValue();
                } else {
                    symbol = this.processSymbol(app.getSubterm(0));
                }
                IStrategoList rhs = TermUtils.toListAt(app.getSubterm(1), 0);
                for (IStrategoTerm t : rhs) {
                    Symbol s = this.processSymbol(t);
                    if (s != null) {
                        rhs_symbols.add(s);
                    }
                    if (!(s instanceof Sort) || ((Sort)s).getType() == null) continue;
                    literals.add(s);
                }
                IStrategoAppl tattrs = (IStrategoAppl)app.getSubterm(2);
                HashSet attrs = Sets.newHashSet();
                switch (tattrs.getName()) {
                    case "Attrs": {
                        IStrategoList talist = TermUtils.toListAt(tattrs, 0);
                        for (IStrategoTerm ta : talist) {
                            IAttribute attr = this.processAttribute(ta);
                            if (attr == null) continue;
                            attrs.add(attr);
                        }
                        break;
                    }
                    default: {
                        throw new UnexpectedTermException(term.toString(), "Attributes");
                    }
                    case "NoAttrs": 
                }
                if (cons != null) {
                    cons_attr = this.gf.createConstructorAttribute(cons);
                    attrs.add(cons_attr);
                }
                UniqueProduction unique_prod = this.gf.createUniqueProduction(symbol, rhs_symbols);
                prod = this.grammar.getUniqueProductionMapping().get(unique_prod);
                if (prod != null) {
                    for (IAttribute a : attrs) {
                        this.grammar.getProductionAttributesMapping().put((Object)prod, (Object)a);
                    }
                    if (this.grammar != null && symbol != null) {
                        this.grammar.getCacheProductionsRead().put(term.toString(), prod);
                    }
                    return prod;
                }
                prod = this.gf.createProduction(symbol, rhs_symbols);
                for (ISymbol literal : literals) {
                    this.grammar.getLiteralProductionsMapping().put((Object)literal, (Object)prod);
                }
                if (cons_attr != null) {
                    this.grammar.getSortConsProductionMapping().put(this.gf.createProductionReference(symbol, cons_attr), prod);
                }
                if (symbol instanceof FileStartSymbol && this.grammar.getInitialProduction() == null) {
                    this.grammar.setInitialProduction(prod);
                }
                for (IAttribute a : attrs) {
                    ISymbol firstSymbol;
                    ISymbol lastSymbol;
                    if (a.toString().equals("longest-match")) {
                        lastSymbol = prod.rightHand().get(prod.arity() - 1);
                        firstSymbol = prod.rightHand().get(0);
                        if (Symbol.isListNonTerminal(lastSymbol)) {
                            this.grammar.getLongestMatchProdsBack().put((Object)((Symbol)lastSymbol), (Object)prod);
                        } else if (Symbol.isListNonTerminal(firstSymbol)) {
                            this.grammar.getLongestMatchProdsFront().put((Object)((Symbol)firstSymbol), (Object)prod);
                        }
                    }
                    if (a.toString().equals("shortest-match")) {
                        lastSymbol = prod.rightHand().get(prod.arity() - 1);
                        firstSymbol = prod.rightHand().get(0);
                        if (Symbol.isListNonTerminal(lastSymbol)) {
                            this.grammar.getShortestMatchProdsBack().put((Object)((Symbol)lastSymbol), (Object)prod);
                        } else if (Symbol.isListNonTerminal(firstSymbol)) {
                            this.grammar.getShortestMatchProdsFront().put((Object)((Symbol)firstSymbol), (Object)prod);
                        }
                    }
                    this.grammar.getProductionAttributesMapping().put((Object)prod, (Object)a);
                }
                if (this.grammar != null && symbol != null) {
                    this.grammar.getCacheProductionsRead().put(term.toString(), prod);
                }
                this.grammar.getSymbolProductionsMapping().put((Object)symbol, (Object)prod);
                this.grammar.getUniqueProductionMapping().put(unique_prod, prod);
                if (cons != null) {
                    this.grammar.getConstructors().put(prod, cons_attr);
                }
                return prod;
            }
            throw new UnexpectedTermException(term.toString(), "SdfProduction");
        }
        throw new UnexpectedTermException(term.toString(), "SdfProduction");
    }

    private Symbol processSymbol(IStrategoTerm term) {
        Symbol symbol;
        block60: {
            block58: {
                symbol = null;
                term = this.removeLabelFromSymbolTerm(term);
                symbol = this.grammar.getCacheSymbolsRead().get(term.toString());
                if (symbol != null) {
                    this.grammar.getSymbols().add(symbol);
                    return symbol;
                }
                if (!(term instanceof IStrategoAppl)) break block58;
                IStrategoAppl app = TermUtils.toAppl(term);
                switch (app.getName()) {
                    case "SortDef": 
                    case "Sort": {
                        symbol = this.gf.createSort(((IStrategoString)app.getSubterm(0)).stringValue());
                        break block60;
                    }
                    case "Layout": {
                        symbol = this.gf.createLayoutSymbol();
                        break block60;
                    }
                    case "CharClass": {
                        symbol = this.gf.createCharClassSymbol(this.processCharClass(term.getSubterm(0)));
                        break block60;
                    }
                    case "Lit": {
                        String enquoted = ((IStrategoString)app.getSubterm(0)).stringValue();
                        symbol = this.gf.createSort(enquoted.substring(1, enquoted.length() - 1), LiteralType.Lit);
                        break block60;
                    }
                    case "CiLit": {
                        String enquoted = ((IStrategoString)app.getSubterm(0)).stringValue();
                        symbol = this.gf.createSort(enquoted.substring(1, enquoted.length() - 1), LiteralType.CiLit);
                        break block60;
                    }
                    case "Opt": {
                        symbol = this.gf.createOptionalSymbol(this.processSymbol(app.getSubterm(0)));
                        break block60;
                    }
                    case "Alt": {
                        symbol = this.gf.createAltSymbol(this.processSymbol(app.getSubterm(0)), this.processSymbol(app.getSubterm(1)));
                        break block60;
                    }
                    case "Sequence": {
                        symbol = this.gf.createSequenceSymbol(this.processSymbol(app.getSubterm(0)), this.processSymbolList(app.getSubterm(1)));
                        break block60;
                    }
                    case "Iter": {
                        symbol = this.gf.createIterSymbol(this.processSymbol(app.getSubterm(0)));
                        break block60;
                    }
                    case "IterStar": {
                        symbol = this.gf.createIterStarSymbol(this.processSymbol(app.getSubterm(0)));
                        break block60;
                    }
                    case "IterSep": {
                        Sort sep = (Sort)this.processSymbol(app.getSubterm(1));
                        symbol = this.gf.createIterSepSymbol(this.processSymbol(app.getSubterm(0)), sep);
                        break block60;
                    }
                    case "IterStarSep": {
                        Sort sep = (Sort)this.processSymbol(app.getSubterm(1));
                        symbol = this.gf.createIterStarSepSymbol(this.processSymbol(app.getSubterm(0)), sep);
                        break block60;
                    }
                    case "Lex": {
                        symbol = this.gf.createLexicalSymbol(this.processSymbol(app.getSubterm(0)));
                        break block60;
                    }
                    case "Cf": {
                        symbol = this.gf.createContextFreeSymbol(this.processSymbol(app.getSubterm(0)));
                        break block60;
                    }
                    case "Start": {
                        symbol = this.gf.createStartSymbol();
                        break block60;
                    }
                    case "FileStart": {
                        symbol = this.gf.createFileStartSymbol();
                        break block60;
                    }
                    case "EOF": {
                        symbol = this.gf.createEOFSymbol();
                        break block60;
                    }
                    default: {
                        System.err.println("Unknown symbol type `" + app.getName() + "'. Is that normalized SDF3?");
                        return null;
                    }
                }
            }
            System.err.println("Malformed term. Application expected.");
            return null;
        }
        this.grammar.getCacheSymbolsRead().put(term.toString(), symbol);
        this.grammar.getSymbols().add(symbol);
        return symbol;
    }

    private IStrategoTerm removeLabelFromSymbolTerm(IStrategoTerm term) {
        if (!TermUtils.isAppl(term)) {
            return term;
        }
        IStrategoAppl app = TermUtils.toAppl(term);
        if (app.getName().equals("Label")) {
            return this.removeLabelFromSymbolTerm(app.getSubterm(1));
        }
        IStrategoTerm[] children = app.getAllSubterms();
        boolean changed = false;
        int i = 0;
        while (i < children.length) {
            IStrategoTerm newChild = this.removeLabelFromSymbolTerm(children[i]);
            if (newChild != children[i]) {
                changed = true;
                children[i] = newChild;
            }
            ++i;
        }
        if (changed) {
            return new StrategoAppl(app.getConstructor(), children, app.getAnnotations());
        }
        return term;
    }

    public List<Symbol> processSymbolList(IStrategoTerm term) {
        LinkedList list = Lists.newLinkedList();
        if (TermUtils.isList(term)) {
            IStrategoList slist = TermUtils.toList(term);
            for (IStrategoTerm t : slist) {
                Symbol s = this.processSymbol(t);
                if (s == null) continue;
                list.add(s);
            }
        } else {
            System.err.println("sdf2table : Symbol.fromStrategoList: this term is not a list.");
        }
        return list;
    }

    public ICharacterClass processCharClass(IStrategoTerm term) {
        block21: {
            if (!TermUtils.isAppl(term)) break block21;
            IStrategoAppl app = TermUtils.toAppl(term);
            CharacterClassFactory ccFactory = ParseTableIO.getCharacterClassFactory();
            switch (app.getName()) {
                case "Absent": {
                    return ccFactory.fromEmpty();
                }
                case "Simple": 
                case "Present": {
                    return this.processCharClass(app.getSubterm(0));
                }
                case "Range": {
                    return ccFactory.fromRange(this.processNumeric(app.getSubterm(0)), this.processNumeric(app.getSubterm(1)));
                }
                case "Numeric": {
                    return ccFactory.fromSingle(this.processNumeric(app));
                }
                case "Conc": {
                    ICharacterClass head = this.processCharClass(app.getSubterm(0));
                    return head.union(this.processCharClass(app.getSubterm(1)));
                }
            }
            System.err.println("Unknown character class `" + app + "'. Is that normalized SDF3?");
            return ccFactory.fromEmpty();
        }
        System.err.println("Malformed term. Application expected.");
        return null;
    }

    private int processNumeric(IStrategoTerm numeric) {
        if (numeric.getSubterm(0) instanceof IStrategoInt) {
            return ((IStrategoInt)numeric.getSubterm(0)).intValue();
        }
        return Integer.parseInt(((IStrategoString)numeric.getSubterm(0)).stringValue().substring(1));
    }

    private IAttribute processAttribute(IStrategoTerm ta) throws Exception {
        block75: {
            if (!TermUtils.isAppl(ta)) break block75;
            IStrategoAppl a = TermUtils.toAppl(ta);
            switch (a.getName()) {
                case "Assoc": {
                    IStrategoAppl assoc = (IStrategoAppl)a.getSubterm(0);
                    switch (assoc.getName()) {
                        case "Left": {
                            return this.gf.createGeneralAttribute("left");
                        }
                        case "Right": {
                            return this.gf.createGeneralAttribute("right");
                        }
                        case "Assoc": {
                            return this.gf.createGeneralAttribute("assoc");
                        }
                        case "NonAssoc": {
                            return this.gf.createGeneralAttribute("non-assoc");
                        }
                    }
                    System.err.println("Unknown associativity: `" + assoc.getName() + "'.");
                    break;
                }
                case "Recover": {
                    return this.gf.createGeneralAttribute("recover");
                }
                case "Reject": {
                    return this.gf.createGeneralAttribute("reject");
                }
                case "Prefer": {
                    return this.gf.createGeneralAttribute("prefer");
                }
                case "Avoid": {
                    return this.gf.createGeneralAttribute("avoid");
                }
                case "Bracket": {
                    return this.gf.createGeneralAttribute("bracket");
                }
                case "LayoutConstraint": {
                    return this.gf.createLayoutConstraintAttribute(a.getSubterm(0));
                }
                case "IgnoreLayout": {
                    return this.gf.createLayoutConstraintAttribute(a);
                }
                case "EnforceNewLine": {
                    return this.gf.createGeneralAttribute("enforce-newline");
                }
                case "LongestMatch": {
                    return this.gf.createGeneralAttribute("longest-match");
                }
                case "ShortestMatch": {
                    return this.gf.createGeneralAttribute("shortest-match");
                }
                case "CaseInsensitive": {
                    return this.gf.createGeneralAttribute("case-insensitive");
                }
                case "Deprecated": {
                    String message = "";
                    if (a.getSubtermCount() > 0) {
                        message = ((IStrategoString)a.getSubterm(0)).stringValue();
                    }
                    return this.gf.createDeprecatedAttribute(message);
                }
                case "Placeholder": {
                    return this.gf.createGeneralAttribute("placeholder");
                }
                case "PlaceholderInsertion": {
                    return this.gf.createGeneralAttribute("placeholder-insertion");
                }
                case "LiteralCompletion": {
                    return this.gf.createGeneralAttribute("literal-completion");
                }
                case "Term": {
                    IStrategoTerm def = a.getSubterm(0);
                    IStrategoAppl term = (IStrategoAppl)def.getSubterm(0);
                    try {
                        if (term.toString().equals("Fun(Unquoted(\"recover\"))")) {
                            return this.gf.createGeneralAttribute("recover");
                        }
                        IStrategoTerm termAttribute = this.createStrategoTermAttribute(term);
                        return this.gf.createTermAttribute(termAttribute, termAttribute.toString());
                    }
                    catch (Exception e) {
                        System.err.println("sdf2table : importAttribute: unknown term attribute `" + a.getName() + "'.");
                        throw new UnexpectedTermException(a.toString());
                    }
                }
                default: {
                    System.err.println("sdf2table : importAttribute: unknown attribute `" + a.getName() + "'.");
                    throw new UnexpectedTermException(a.toString());
                }
            }
        }
        return null;
    }

    private IStrategoTerm createStrategoTermAttribute(IStrategoAppl term) throws UnexpectedTermException {
        ITermFactory termFactory = ParseTableIO.getTermfactory();
        if (term.getConstructor().getName().equals("Appl")) {
            String cons_name = ((IStrategoString)term.getSubterm(0).getSubterm(0)).stringValue();
            int arity = term.getSubterm(1).getSubtermCount();
            IStrategoTerm[] subterms = new IStrategoTerm[arity];
            int i = 0;
            while (i < arity) {
                IStrategoTerm child = ((IStrategoList)term.getSubterm(1)).getSubterm(i);
                subterms[i] = this.createStrategoTermAttribute((IStrategoAppl)child);
                ++i;
            }
            return termFactory.makeAppl(termFactory.makeConstructor(cons_name, arity), subterms);
        }
        if (term.getConstructor().getName().equals("Fun")) {
            String termName = ((IStrategoString)term.getSubterm(0).getSubterm(0)).stringValue();
            if (((IStrategoAppl)term.getSubterm(0)).getConstructor().getName().equals("Quoted")) {
                termName = termName.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\'", "'").substring(1, termName.length() - 1);
            }
            return termFactory.makeString(termName);
        }
        if (term.getConstructor().getName().equals("Int")) {
            String svalue = ((IStrategoString)term.getSubterm(0).getSubterm(0)).stringValue();
            int ivalue = Integer.parseInt(svalue);
            return termFactory.makeInt(ivalue);
        }
        if (term.getConstructor().getName().equals("List")) {
            IStrategoList term_list = (IStrategoList)term.getSubterm(0);
            IStrategoList.Builder terms = termFactory.arrayListBuilder(term_list.size());
            for (IStrategoTerm t : term_list) {
                terms.add(this.createStrategoTermAttribute((IStrategoAppl)t));
            }
            return termFactory.makeList(terms);
        }
        System.err.println("sdf2table : importAttribute: unknown stratego term attribute `" + term.getName() + "'.");
        throw new UnexpectedTermException(term.toString());
    }

    private void addRestrictions(IStrategoAppl tsection) throws UnexpectedTermException {
        if (tsection.getName().equals("Restrictions")) {
            IStrategoList restrictions = TermUtils.toListAt(tsection, 0);
            for (IStrategoTerm restriction : restrictions) {
                this.processRestriction(restriction);
            }
        }
    }

    private void processRestriction(IStrategoTerm restriction) throws UnexpectedTermException {
        block10: {
            block8: {
                if (!TermUtils.isAppl(restriction)) break block8;
                IStrategoAppl res = TermUtils.toAppl(restriction);
                switch (res.getName()) {
                    case "Follow": {
                        ArrayList restrictionLookahead = Lists.newArrayList();
                        ICharacterClass restrictionNoLookahead = this.importFollowRestriction(res.getSubterm(1), restrictionLookahead);
                        IStrategoList subjects = TermUtils.toListAt(res, 0);
                        for (IStrategoTerm subject : subjects) {
                            Symbol s = this.processSymbol(subject);
                            s.addFollowRestriction(restrictionNoLookahead);
                            s.addFollowRestrictionsLookahead(restrictionLookahead);
                        }
                        break block10;
                    }
                    default: {
                        throw new UnexpectedTermException(res.getName());
                    }
                }
            }
            throw new UnexpectedTermException(restriction.toString());
        }
    }

    public ICharacterClass importFollowRestriction(IStrategoTerm term, List<ICharacterClass[]> restrictionsLookahead) throws UnexpectedTermException {
        ICharacterClass restriction;
        block14: {
            restriction = CharacterClassFactory.EMPTY_CHARACTER_CLASS;
            if (!TermUtils.isAppl(term)) break block14;
            IStrategoAppl app = TermUtils.toAppl(term);
            switch (app.getName()) {
                case "List": {
                    IStrategoList slist = TermUtils.toListAt(app, 0);
                    for (IStrategoTerm t : slist) {
                        restriction = this.importFollowRestriction(t, restrictionsLookahead).union(restriction);
                    }
                    break;
                }
                case "Seq": {
                    ArrayList lookahead = Lists.newArrayList((Object[])new ICharacterClass[]{this.processCharClass(app.getSubterm(0))});
                    this.createNewLookahead(app.getSubterm(1), lookahead, restrictionsLookahead);
                    break;
                }
                case "CharClass": {
                    restriction = restriction.union(this.processCharClass(app.getSubterm(0)));
                    break;
                }
                default: {
                    throw new UnexpectedTermException(app.toString(), "List or Seq or CharClass");
                }
            }
        }
        return restriction;
    }

    private void createNewLookahead(IStrategoTerm term, List<ICharacterClass> lookahead, List<ICharacterClass[]> restrictionsLookahead) throws UnexpectedTermException {
        block14: {
            if (!(term instanceof IStrategoAppl)) break block14;
            IStrategoAppl app = (IStrategoAppl)term;
            switch (app.getName()) {
                case "List": {
                    IStrategoList slist = TermUtils.toListAt(app, 0);
                    for (IStrategoTerm t : slist) {
                        ArrayList firstChars = Lists.newArrayList(lookahead);
                        this.createNewLookahead(t, firstChars, restrictionsLookahead);
                    }
                    break;
                }
                case "Seq": {
                    lookahead.add(this.processCharClass(app.getSubterm(0)));
                    this.createNewLookahead(app.getSubterm(1), lookahead, restrictionsLookahead);
                    break;
                }
                case "CharClass": {
                    ICharacterClass lastChar = this.processCharClass(app.getSubterm(0));
                    lookahead.add(lastChar);
                    restrictionsLookahead.add(lookahead.toArray(new ICharacterClass[0]));
                    break;
                }
                default: {
                    throw new UnexpectedTermException(app.toString(), "List or Seq or CharClass");
                }
            }
        }
    }

    private void addPriorities(IStrategoAppl tsection) throws Exception {
        if (tsection.getName().equals("Priorities")) {
            IStrategoList chains = TermUtils.toListAt(tsection, 0);
            for (IStrategoTerm chain : chains) {
                this.processPriorityChain(chain);
            }
        }
    }

    private void processPriorityChain(IStrategoTerm chain) throws Exception {
        if (TermUtils.isAppl(chain) && ((IStrategoAppl)chain).getName().equals("Chain")) {
            IStrategoTerm second_group;
            IStrategoList groups = (IStrategoList)chain.getSubterm(0);
            Production higher = null;
            Production lower = null;
            boolean transitive = true;
            List<Object> arguments = Lists.newArrayList();
            if (groups.size() != 2) {
                throw new Exception("Unexpected normalized priority: " + chain.toString() + ".\nExpecting only binary priority relations.");
            }
            IStrategoTerm first_group = groups.getSubterm(0);
            if (first_group instanceof IStrategoAppl && ((IStrategoAppl)first_group).getName().equals("NonTransitive")) {
                transitive = false;
                first_group = first_group.getSubterm(0);
            }
            if (first_group instanceof IStrategoAppl && ((IStrategoAppl)first_group).getName().equals("WithArguments")) {
                IStrategoAppl priority_args = (IStrategoAppl)first_group.getSubterm(1);
                if (!priority_args.getName().equals("Default")) {
                    throw new UnexpectedTermException(priority_args.toString(), "Default");
                }
                IStrategoList positions = (IStrategoList)priority_args.getSubterm(0);
                IStrategoTerm[] iStrategoTermArray = positions.getAllSubterms();
                int n = iStrategoTermArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStrategoTerm iStrategoTerm = iStrategoTermArray[n2];
                    if (!(iStrategoTerm instanceof IStrategoString)) {
                        throw new UnexpectedTermException(iStrategoTerm.toString(), "Argument Position");
                    }
                    arguments.add(Integer.parseInt(((IStrategoString)iStrategoTerm).stringValue()));
                    ++n2;
                }
                if ((first_group = first_group.getSubterm(0)) instanceof IStrategoAppl && ((IStrategoAppl)first_group).getName().equals("NonTransitive")) {
                    transitive = false;
                    first_group = first_group.getSubterm(0);
                }
            }
            higher = this.processGroup(first_group);
            if (first_group instanceof IStrategoAppl && ((IStrategoAppl)first_group).getName().equals("SimpleRefGroup")) {
                arguments = this.normalizePriorityArguments(higher, (List<Integer>)arguments);
            }
            if ((second_group = groups.getSubterm(1)) instanceof IStrategoAppl && ((IStrategoAppl)second_group).getName().equals("NonTransitive")) {
                second_group = second_group.getSubterm(0);
            }
            if (second_group instanceof IStrategoAppl && ((IStrategoAppl)second_group).getName().equals("WithArguments") && (second_group = second_group.getSubterm(0)) instanceof IStrategoAppl && ((IStrategoAppl)second_group).getName().equals("NonTransitive")) {
                second_group = second_group.getSubterm(0);
            }
            lower = this.processGroup(second_group);
            Priority p = this.gf.createPriority(higher, lower, transitive);
            if (transitive) {
                this.grammar.getTransitivePriorities().add(p);
                this.grammar.getProductionsOnPriorities().add(higher);
                this.grammar.getProductionsOnPriorities().add(lower);
                if (arguments.isEmpty()) {
                    this.grammar.getTransitivePriorityArgs().put((Object)p, (Object)-1);
                } else {
                    for (Integer n : arguments) {
                        this.grammar.getTransitivePriorityArgs().put((Object)p, (Object)n);
                    }
                }
            } else {
                this.grammar.getNonTransitivePriorities().add(p);
                if (arguments.isEmpty()) {
                    this.grammar.getNonTransitivePriorityArgs().put((Object)p, (Object)-1);
                } else {
                    for (Integer n : arguments) {
                        this.grammar.getNonTransitivePriorityArgs().put((Object)p, (Object)n);
                    }
                }
            }
        } else if (TermUtils.isAppl(chain) && ((IStrategoAppl)chain).getName().equals("Assoc")) {
            IStrategoTerm first_group = chain.getSubterm(0);
            IStrategoTerm assoc = chain.getSubterm(1);
            IStrategoTerm second_group = chain.getSubterm(2);
            Production higher = this.processGroup(first_group);
            Production lower = this.processGroup(second_group);
            Priority p = this.gf.createPriority(higher, lower, false);
            this.grammar.getNonTransitivePriorities().add(p);
            if (assoc.toString().contains("Left")) {
                this.grammar.getNonTransitivePriorityArgs().put((Object)p, (Object)Integer.MAX_VALUE);
            } else if (assoc.toString().contains("Right")) {
                this.grammar.getNonTransitivePriorityArgs().put((Object)p, (Object)Integer.MIN_VALUE);
            } else if (assoc.toString().contains("NonAssoc")) {
                this.grammar.getNonTransitivePriorityArgs().put((Object)p, (Object)Integer.MAX_VALUE);
                String higherSort = Symbol.getSort(p.higher().leftHand());
                String higherConstructor = this.grammar.getConstructors().get(p.higher()).getConstructor();
                String string = Symbol.getSort(p.lower().leftHand());
                String lowerConstructor = this.grammar.getConstructors().get(p.lower()).getConstructor();
                this.grammar.getNonAssocPriorities().put((Object)(String.valueOf(higherSort) + "." + higherConstructor), (Object)(String.valueOf(string) + "." + lowerConstructor));
            } else if (assoc.toString().contains("NonNested")) {
                String higherSort = Symbol.getSort(p.higher().leftHand());
                String higherConstructor = this.grammar.getConstructors().get(p.higher()).getConstructor();
                String string = Symbol.getSort(p.lower().leftHand());
                String lowerConstructor = this.grammar.getConstructors().get(p.lower()).getConstructor();
                this.grammar.getNonNestedPriorities().put((Object)(String.valueOf(higherSort) + "." + higherConstructor), (Object)(String.valueOf(string) + "." + lowerConstructor));
            }
        } else {
            throw new UnexpectedTermException(chain.toString(), "Chain or Assoc");
        }
    }

    private List<Integer> normalizePriorityArguments(Production production, List<Integer> arguments) {
        ContextFreeSymbol optLayout = this.gf.createContextFreeSymbol(this.gf.createOptionalSymbol(this.gf.createLayoutSymbol()));
        ArrayList norm_arguments = Lists.newArrayList();
        block0: for (int arg : arguments) {
            int norm_arg = 0;
            for (ISymbol s : production.rightHand()) {
                if (arg == 0 && norm_arg == 0) {
                    norm_arguments.add(norm_arg);
                    continue block0;
                }
                if (arg == 0) {
                    norm_arguments.add(++norm_arg);
                    continue block0;
                }
                if (!s.equals(optLayout)) {
                    --arg;
                }
                ++norm_arg;
            }
        }
        arguments = norm_arguments;
        return arguments;
    }

    private Production processGroup(IStrategoTerm group) throws UnexpectedTermException, Exception {
        Production production = null;
        if (group instanceof IStrategoAppl && ((IStrategoAppl)group).getName().equals("SimpleGroup")) {
            production = this.processProduction(group.getSubterm(0));
        } else if (group instanceof IStrategoAppl && ((IStrategoAppl)group).getName().equals("SimpleRefGroup")) {
            IStrategoTerm sort = group.getSubterm(0).getSubterm(0);
            IStrategoTerm constructor = group.getSubterm(0).getSubterm(1);
            String cons_name = ((IStrategoString)constructor.getSubterm(0)).stringValue();
            ProductionReference prod_ref = this.gf.createProductionReference(this.processSymbol(sort), this.gf.createConstructorAttribute(cons_name));
            production = this.grammar.getSortConsProductionMapping().get(prod_ref);
            if (production == null) {
                throw new Exception("Production referenced by " + prod_ref + " could not be found.");
            }
        } else {
            throw new Exception("Normalized priority relation should be on SimpleGroups only.");
        }
        if (production == null) {
            throw new Exception("Group " + group + " could not be processed.");
        }
        return production;
    }

    private IStrategoTerm termFromFile(File file) throws Exception {
        IStrategoTerm term;
        this.fileVisitors.forEach(visitor -> visitor.visit(file));
        TermReader termReader = new TermReader(ParseTableIO.getTermfactory());
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                term = termReader.parseFromStream(fileInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new Exception("Cannot open module file '" + file.getPath() + "'. Try cleaning the project and rebuilding.");
        }
        this.grammar.getFilesRead().add(file);
        return term;
    }

    private static String moduleName(IStrategoTerm term) {
        IStrategoString tname = (IStrategoString)term.getSubterm(0).getSubterm(0);
        return tname.stringValue();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static String importName(IStrategoTerm term) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl20 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl20 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface FileVisitor {
        public void visit(File var1);
    }
}

