/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.io;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.parsetable.IParseTableGenerator;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.states.IState;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.grammar.GeneralAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.NormGrammar;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.io.NormGrammarReader;
import org.metaborg.sdf2table.parsetable.Action;
import org.metaborg.sdf2table.parsetable.Goto;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.sdf2table.parsetable.ParseTableConfiguration;
import org.metaborg.sdf2table.parsetable.State;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;

public class ParseTableIO
implements IParseTableGenerator {
    private static final ILogger logger = LoggerUtils.logger(ParseTableIO.class);
    private File input;
    private File outputFile;
    private File ctxGrammarFile;
    private File persistedTableFile;
    private List<String> paths;
    private static final ITermFactory termFactory = new TermFactory();
    private static final CharacterClassFactory ccFactory = new CharacterClassFactory();
    private boolean tableCreated = false;
    private ParseTable pt;

    public ParseTableIO(File input, File output, File persistedTable, File ctxGrammar, List<String> paths) {
        this.input = input;
        this.outputFile = output;
        this.paths = paths;
        this.persistedTableFile = persistedTable;
        this.ctxGrammarFile = ctxGrammar;
    }

    public ParseTableIO(File tableFile) throws Exception {
        this(new FileInputStream(tableFile));
    }

    public ParseTableIO(FileObject tableFile) throws Exception {
        this(tableFile.getContent().getInputStream());
    }

    public ParseTableIO(InputStream is) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), is);){
            this.pt = (ParseTable)ois.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.tableCreated = true;
    }

    public void createParseTable(ParseTableConfiguration config) throws Exception {
        NormGrammar grammar = new NormGrammarReader(this.paths).readGrammar(this.input);
        this.pt = new ParseTable(grammar, config);
        this.tableCreated = true;
    }

    public void outputTable(ParseTableConfiguration config) throws Exception {
        if (!this.tableCreated) {
            try {
                this.createParseTable(config);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw e;
            }
        }
        boolean generateContextualGrammar = false;
        if (this.ctxGrammarFile != null && generateContextualGrammar) {
            IStrategoTerm ctxGrammar = ParseTableIO.generateATermContextualGrammar(this.pt);
            ParseTableIO.outputToFile(ctxGrammar, this.ctxGrammarFile);
        }
        if (this.persistedTableFile != null) {
            ParseTableIO.persistObjectToFile(this.pt, this.persistedTableFile);
        }
        if (this.outputFile != null) {
            IStrategoTerm ptAterm = ParseTableIO.generateATerm(this.pt);
            ParseTableIO.outputToFile(ptAterm, this.outputFile);
        }
    }

    public static IStrategoTerm generateATerm(ParseTable pt) throws Exception {
        logger.trace("Starting generation of parsetable ATerm. ");
        IStrategoInt version = termFactory.makeInt(7);
        IStrategoInt initialState = termFactory.makeInt(0);
        IStrategoTerm labels = ParseTableIO.generateLabelsAterm(pt);
        IStrategoTerm priorities = ParseTableIO.generatePrioritiesAterm(pt);
        IStrategoTerm states = ParseTableIO.generateStatesAterm(pt);
        return termFactory.makeAppl(termFactory.makeConstructor("parse-table", 5), version, initialState, labels, states, priorities);
    }

    public static IStrategoTerm generateATermContextualGrammar(ParseTable pt) {
        IStrategoList.Builder productions = termFactory.arrayListBuilder(pt.productionLabels().size());
        IStrategoList.Builder priorities = termFactory.arrayListBuilder(0);
        HashSet<ISymbol> recursiveSymbols = new HashSet<ISymbol>();
        GeneralAttribute placeholder = pt.normalizedGrammar().getGrammarFactory().createGeneralAttribute("placeholder");
        GeneralAttribute placeholder_insertion = pt.normalizedGrammar().getGrammarFactory().createGeneralAttribute("placeholder-insertion");
        for (IProduction p : pt.productionLabels().keySet()) {
            if (pt.isLayoutSymbol(p.leftHand()) || (p instanceof Production ? ((Production)p).leftRecursivePosition() == -1 && ((Production)p).rightRecursivePosition() == -1 || p.leftHand() instanceof LexicalSymbol : p instanceof ContextualProduction && (((ContextualProduction)p).getOrigProduction().leftRecursivePosition() == -1 && ((ContextualProduction)p).getOrigProduction().rightRecursivePosition() == -1 || p.leftHand() instanceof LexicalSymbol))) continue;
            recursiveSymbols.add(p.leftHand());
        }
        for (IProduction p : pt.productionLabels().keySet()) {
            Set attrs;
            if (!recursiveSymbols.contains(p.leftHand())) continue;
            if (p instanceof Production) {
                attrs = pt.normalizedGrammar().getProductionAttributesMapping().get((Object)p);
                if (attrs.contains(placeholder)) continue;
                productions.add(((Production)p).toSDF3Aterm(pt.normalizedGrammar().getProductionAttributesMapping(), pt.getCtxUniqueInt(), null));
                continue;
            }
            if (!(p instanceof ContextualProduction) || (attrs = pt.normalizedGrammar().getProductionAttributesMapping().get((Object)((ContextualProduction)p).getOrigProduction())).contains(placeholder)) continue;
            productions.add(((ContextualProduction)p).toSDF3Aterm(pt.normalizedGrammar().getProductionAttributesMapping(), pt.getCtxUniqueInt(), null));
        }
        IStrategoAppl syntaxSection = termFactory.makeAppl(termFactory.makeConstructor("SDFSection", 1), termFactory.makeAppl(termFactory.makeConstructor("Kernel", 1), termFactory.makeList(productions)));
        IStrategoAppl prioritiesSection = termFactory.makeAppl(termFactory.makeConstructor("SDFSection", 1), termFactory.makeAppl(termFactory.makeConstructor("Priorities", 1), termFactory.makeList(priorities)));
        IStrategoAppl restrictionsSection = termFactory.makeAppl(termFactory.makeConstructor("SDFSection", 1), termFactory.makeAppl(termFactory.makeConstructor("Restrictions", 1), termFactory.makeList(priorities)));
        return termFactory.makeAppl(termFactory.makeConstructor("Module", 3), termFactory.makeAppl(termFactory.makeConstructor("Unparameterized", 1), termFactory.makeString("contextual-grammar")), termFactory.makeList(), termFactory.makeList(syntaxSection, prioritiesSection, restrictionsSection));
    }

    private static IStrategoTerm generateStatesAterm(ParseTable pt) {
        IStrategoList.Builder terms = termFactory.arrayListBuilder(pt.totalStates());
        int i = 0;
        while (i < pt.totalStates()) {
            State s = pt.stateLabels().get(i);
            IStrategoList.Builder goto_terms = termFactory.arrayListBuilder(s.gotos().size());
            for (Goto goto_action : s.gotos()) {
                goto_terms.add(goto_action.toAterm(termFactory));
            }
            IStrategoList.Builder action_terms = termFactory.arrayListBuilder(s.actionsMapping().keySet().size());
            for (ICharacterClass cc : s.actionsMapping().keySet()) {
                Set actionSet = s.actionsMapping().get((Object)cc);
                IStrategoList.Builder actions = termFactory.arrayListBuilder(actionSet.size());
                for (Action a : actionSet) {
                    actions.add(a.toAterm(termFactory, pt));
                }
                action_terms.add(termFactory.makeAppl(termFactory.makeConstructor("action", 2), cc.toAtermList(termFactory), termFactory.makeList(actions)));
            }
            terms.add(termFactory.makeAppl(termFactory.makeConstructor("state-rec", 3), termFactory.makeInt(s.id()), termFactory.makeList(goto_terms), termFactory.makeList(action_terms)));
            ++i;
        }
        return termFactory.makeAppl(termFactory.makeConstructor("states", 1), termFactory.makeList(terms));
    }

    private static IStrategoTerm generatePrioritiesAterm(ParseTable pt) throws Exception {
        HashMultimap allPriorities = HashMultimap.create();
        allPriorities.putAll(pt.normalizedGrammar().priorities());
        allPriorities.putAll(pt.normalizedGrammar().getIndexedPriorities());
        IStrategoList.Builder terms = termFactory.arrayListBuilder(allPriorities.size());
        for (Map.Entry e : allPriorities.entries()) {
            IStrategoAppl prio_term;
            IProduction prod_higher = ((Priority)e.getKey()).higher();
            IProduction prod_lower = ((Priority)e.getKey()).lower();
            if (pt.normalizedGrammar().getProdContextualProdMapping().containsKey((Object)prod_higher)) {
                prod_higher = (IProduction)pt.normalizedGrammar().getProdContextualProdMapping().get((Object)((Priority)e.getKey()).higher());
            }
            if (pt.normalizedGrammar().getProdContextualProdMapping().containsKey((Object)prod_lower)) {
                prod_lower = (IProduction)pt.normalizedGrammar().getProdContextualProdMapping().get((Object)((Priority)e.getKey()).lower());
            }
            Integer label_higher = (Integer)pt.productionLabels().get((Object)prod_higher);
            Integer label_lower = (Integer)pt.productionLabels().get((Object)prod_lower);
            if (label_higher == null || label_lower == null) {
                throw new Exception("Production label not found.");
            }
            if ((Integer)e.getValue() == -1) {
                prio_term = termFactory.makeAppl(termFactory.makeConstructor("gtr-prio", 2), termFactory.makeInt(label_higher), termFactory.makeInt(label_lower));
                terms.add(prio_term);
                continue;
            }
            if ((Integer)e.getValue() == Integer.MAX_VALUE || (Integer)e.getValue() == Integer.MIN_VALUE) continue;
            prio_term = termFactory.makeAppl(termFactory.makeConstructor("arg-gtr-prio", 3), termFactory.makeInt(label_higher), termFactory.makeInt((Integer)e.getValue()), termFactory.makeInt(label_lower));
            terms.add(prio_term);
        }
        return termFactory.makeAppl(termFactory.makeConstructor("priorities", 1), termFactory.makeList(terms));
    }

    private static IStrategoTerm generateLabelsAterm(ParseTable pt) {
        IStrategoList.Builder terms = termFactory.arrayListBuilder(pt.productionLabels().size());
        int i = 257 + pt.productionLabels().size() - 1;
        while (i >= 257) {
            IProduction p = (IProduction)pt.productionLabels().inverse().get((Object)i);
            IStrategoAppl p_term = p instanceof Production ? termFactory.makeAppl(termFactory.makeConstructor("label", 2), ((Production)p).toAterm(pt.normalizedGrammar().getProductionAttributesMapping()), termFactory.makeInt(i)) : termFactory.makeAppl(termFactory.makeConstructor("label", 2), ((ContextualProduction)p).toAterm(pt.normalizedGrammar().getProductionAttributesMapping()), termFactory.makeInt(i));
            terms.add(p_term);
            --i;
        }
        return termFactory.makeList(terms);
    }

    @Override
    public ParseTable getParseTable() {
        return this.pt;
    }

    public void setParseTable(ParseTable pt) {
        this.pt = pt;
    }

    @Override
    public IStrategoTerm getStateAterm(IState is) {
        State s = (State)is;
        IStrategoList.Builder goto_terms = termFactory.arrayListBuilder(s.gotos().size());
        for (Goto goto_action : s.gotos()) {
            goto_terms.add(goto_action.toAterm(termFactory));
        }
        IStrategoList.Builder action_terms = termFactory.arrayListBuilder(s.actionsMapping().size());
        for (ICharacterClass cc : s.actionsMapping().keySet()) {
            Set actionSet = s.actionsMapping().get((Object)cc);
            IStrategoList.Builder actions = termFactory.arrayListBuilder(actionSet.size());
            for (Action a : actionSet) {
                actions.add(a.toAterm(termFactory, this.pt));
            }
            action_terms.add(termFactory.makeAppl(termFactory.makeConstructor("action", 2), cc.toAtermList(termFactory), termFactory.makeList(actions)));
        }
        return termFactory.makeAppl(termFactory.makeConstructor("state-rec", 3), termFactory.makeInt(s.id()), termFactory.makeList(goto_terms), termFactory.makeList(action_terms));
    }

    public static void outputToFile(IStrategoTerm parseTable, File output) {
        logger.trace("Outputting parsetable without creating a string for it first. ");
        if (output != null) {
            output.getParentFile().mkdirs();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileWriter out = new FileWriter(output);){
                    parseTable.writeAsString(out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("Could not write parse table", e);
            }
        }
    }

    public static void persistObjectToFile(ParseTable pt, File output) {
        String name = output.getAbsolutePath();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ObjectOutputStream outObj = new ObjectOutputStream(new FileOutputStream(name));){
                outObj.writeObject(pt);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Could not persist normalized grammar", e);
        }
    }

    public static ITermFactory getTermfactory() {
        return termFactory;
    }

    public static CharacterClassFactory getCharacterClassFactory() {
        return ccFactory;
    }

    @Override
    public SetMultimap<String, String> getNonAssocPriorities() {
        SetMultimap<String, String> result = null;
        if (this.tableCreated) {
            result = this.pt.normalizedGrammar().getNonAssocPriorities();
        }
        if (result != null) {
            return result;
        }
        return HashMultimap.create();
    }

    @Override
    public SetMultimap<String, String> getNonNestedPriorities() {
        SetMultimap<String, String> result = null;
        if (this.tableCreated) {
            result = this.pt.normalizedGrammar().getNonNestedPriorities();
        }
        if (result != null) {
            return result;
        }
        return HashMultimap.create();
    }
}

