/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.productions.ProductionType;
import org.metaborg.parsetable.symbols.ConcreteSyntaxContext;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.CharacterClassSymbol;
import org.metaborg.sdf2table.grammar.ConstructorAttribute;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.GeneralAttribute;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.IterSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.IterSymbol;
import org.metaborg.sdf2table.grammar.Layout;
import org.metaborg.sdf2table.grammar.LayoutConstraintAttribute;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.OptionalSymbol;
import org.metaborg.sdf2table.grammar.SequenceSymbol;
import org.metaborg.sdf2table.grammar.Sort;
import org.metaborg.sdf2table.grammar.StartSymbol;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.TermAttribute;
import org.metaborg.sdf2table.grammar.layoutconstraints.IgnoreLayoutConstraint;
import org.metaborg.sdf2table.io.ParseTableIO;

public class ParseTableProduction
implements org.metaborg.parsetable.productions.IProduction,
Serializable {
    private static final long serialVersionUID = -7825374345958769969L;
    private final IProduction p;
    private final int productionNumber;
    private final String sort;
    private final boolean isContextFree;
    private final boolean isLayout;
    private final boolean isLiteral;
    private final boolean isLexical;
    private final boolean isList;
    private final boolean isOptional;
    private final boolean isStringLiteral;
    private final boolean isNumberLiteral;
    private final boolean isBracket;
    private final boolean isOperator;
    private final boolean isRecovery;
    private final boolean isCompletion;
    private final ConstructorAttribute constructor;
    private final ProductionType type;
    private final Set<LayoutConstraintAttribute> layoutConstraints;
    private final boolean isIgnoreLayoutConstraint;
    private final boolean isLongestMatch;
    private final long cachedContextBitmapL;
    private final long cachedContextBitmapR;

    public ParseTableProduction(int productionNumber, IProduction p, Set<IAttribute> attrs, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
        boolean isLexicalRhs;
        boolean isLayout;
        this.p = p;
        this.cachedContextBitmapL = leftmostContextsMapping.containsKey(productionNumber) ? 1L << leftmostContextsMapping.get(productionNumber) : 0L;
        if (rightmostContextsMapping.containsKey(productionNumber)) {
            int offset = leftmostContextsMapping.keySet().size();
            this.cachedContextBitmapR = 1L << rightmostContextsMapping.get(productionNumber) + offset;
        } else {
            this.cachedContextBitmapR = 0L;
        }
        if (p instanceof ContextualProduction) {
            p = ((ContextualProduction)p).getOrigProduction();
        }
        this.productionNumber = productionNumber;
        this.sort = Symbol.getSort(p.leftHand());
        boolean isRecovery = false;
        boolean isCompletion = false;
        ConstructorAttribute c = null;
        ProductionType t = ProductionType.NO_TYPE;
        boolean isBracket = false;
        for (IAttribute attr : attrs) {
            if (attr instanceof ConstructorAttribute) {
                c = (ConstructorAttribute)attr;
            }
            if (attr instanceof TermAttribute || attr instanceof GeneralAttribute) {
                if (attr.toString().equals("completion") || attr.toString().equals("literal-completion")) {
                    isCompletion = true;
                }
                if (attr.toString().equals("recover")) {
                    isRecovery = true;
                }
            }
            if (!(attr instanceof GeneralAttribute)) continue;
            GeneralAttribute ga = (GeneralAttribute)attr;
            if (ga.getName().equals("bracket")) {
                isBracket = true;
            }
            if (ga.getName().equals("reject")) {
                t = ProductionType.REJECT;
                continue;
            }
            if (ga.getName().equals("prefer")) {
                t = ProductionType.PREFER;
                continue;
            }
            if (!ga.getName().equals("avoid")) continue;
            t = ProductionType.AVOID;
        }
        this.isRecovery = isRecovery;
        this.isCompletion = isCompletion;
        this.isBracket = isBracket;
        boolean isList = false;
        if (org.metaborg.parsetable.productions.IProduction.isListConstructor(c != null ? c.getConstructor() : null)) {
            isList = true;
            c = null;
        }
        this.constructor = c;
        this.type = t;
        this.isLayout = isLayout = this.getIsLayout();
        boolean isLiteral = false;
        if (p.leftHand() instanceof Sort && ((Sort)p.leftHand()).getType() != null) {
            isLiteral = true;
        }
        this.isLiteral = isLiteral;
        if (p.arity() > 0) {
            boolean lexRhs = true;
            for (org.metaborg.sdf2table.grammar.ISymbol s : p.rightHand()) {
                if (s instanceof CharacterClassSymbol) continue;
                lexRhs = false;
                break;
            }
            isLexicalRhs = lexRhs;
        } else {
            isLexicalRhs = false;
        }
        this.isLexical = p.leftHand() instanceof LexicalSymbol || isLexicalRhs;
        this.isContextFree = !isLayout && !isLiteral && !this.isLexical && !isLexicalRhs;
        org.metaborg.sdf2table.grammar.ISymbol symb2 = p.leftHand();
        if (symb2 instanceof OptionalSymbol) {
            symb2 = ((OptionalSymbol)symb2).getSymbol();
        }
        if (symb2 instanceof ContextFreeSymbol) {
            symb2 = ((ContextFreeSymbol)symb2).getSymbol();
        }
        if (symb2 instanceof SequenceSymbol || this.isIterSymbol(symb2)) {
            isList = true;
        }
        this.isList = isList;
        this.isOptional = this.containsOptSymbol(p.leftHand());
        this.isStringLiteral = this.topdownHasSpaces(p.rightHand());
        CharacterClassSymbol cc = this.checkFirstRange(p.rightHand());
        this.isNumberLiteral = cc != null;
        this.isOperator = isLiteral && this.checkNotIsLetter(p.leftHand());
        this.layoutConstraints = Sets.newHashSet();
        boolean ignoreLayout = false;
        boolean longestMatch = false;
        for (IAttribute attr : attrs) {
            if (attr instanceof LayoutConstraintAttribute) {
                if (((LayoutConstraintAttribute)attr).getLayoutConstraint() instanceof IgnoreLayoutConstraint) {
                    ignoreLayout = true;
                } else {
                    this.layoutConstraints.add(this.normalizeConstraint((LayoutConstraintAttribute)attr, p.rightHand()));
                }
            }
            if (!(attr instanceof GeneralAttribute) || !((GeneralAttribute)attr).getName().equals("longest-match")) continue;
            longestMatch = true;
        }
        this.isLongestMatch = longestMatch;
        this.isIgnoreLayoutConstraint = ignoreLayout;
    }

    private LayoutConstraintAttribute normalizeConstraint(LayoutConstraintAttribute attr, List<org.metaborg.sdf2table.grammar.ISymbol> rightHand) {
        attr.getLayoutConstraint().normalizeConstraint(rightHand);
        return attr;
    }

    private boolean getIsLayout() {
        boolean isLayout = false;
        org.metaborg.sdf2table.grammar.ISymbol symb = this.getProduction().leftHand();
        if (symb instanceof ContextFreeSymbol) {
            symb = ((ContextFreeSymbol)symb).getSymbol();
        }
        if (symb instanceof OptionalSymbol) {
            symb = ((OptionalSymbol)symb).getSymbol();
        }
        if (symb instanceof Layout) {
            isLayout = true;
        }
        return isLayout;
    }

    private boolean checkNotIsLetter(org.metaborg.sdf2table.grammar.ISymbol s) {
        if (s instanceof Sort) {
            return s.name().codePoints().noneMatch(Character::isLetter);
        }
        return false;
    }

    private CharacterClassSymbol checkFirstRange(List<org.metaborg.sdf2table.grammar.ISymbol> rhs) {
        for (org.metaborg.sdf2table.grammar.ISymbol s : rhs) {
            if (!((s = this.getFirstRange(s)) instanceof CharacterClassSymbol)) continue;
            CharacterClassSymbol characterClassSymbol = (CharacterClassSymbol)s;
            ICharacterClass cc = characterClassSymbol.getCC();
            ICharacterClass intCC = ParseTableIO.getCharacterClassFactory().fromRange(48, 57);
            if (!cc.isEmpty()) {
                if (!cc.equals(intCC.intersection(cc))) continue;
                return characterClassSymbol;
            }
            return null;
        }
        return null;
    }

    private org.metaborg.sdf2table.grammar.ISymbol getFirstRange(org.metaborg.sdf2table.grammar.ISymbol s) {
        if (s instanceof LexicalSymbol) {
            return this.getFirstRange(((LexicalSymbol)s).getSymbol());
        }
        if (s instanceof IterStarSymbol) {
            return this.getFirstRange(((IterStarSymbol)s).getSymbol());
        }
        if (s instanceof IterSymbol) {
            return this.getFirstRange(((IterSymbol)s).getSymbol());
        }
        if (s instanceof CharacterClassSymbol) {
            return s;
        }
        return null;
    }

    private boolean topdownHasSpaces(List<org.metaborg.sdf2table.grammar.ISymbol> rightHand) {
        return rightHand.stream().anyMatch(this::topdownHasSpaces);
    }

    private boolean topdownHasSpaces(org.metaborg.sdf2table.grammar.ISymbol s) {
        if (s instanceof CharacterClassSymbol && ((CharacterClassSymbol)s).getCC().contains(32)) {
            return true;
        }
        if (s instanceof LexicalSymbol) {
            return this.topdownHasSpaces(((LexicalSymbol)s).getSymbol());
        }
        if (s instanceof IterStarSepSymbol) {
            return this.topdownHasSpaces(((IterStarSepSymbol)s).getSymbol());
        }
        if (s instanceof IterStarSymbol) {
            return this.topdownHasSpaces(((IterStarSymbol)s).getSymbol());
        }
        if (s instanceof IterSepSymbol) {
            return this.topdownHasSpaces(((IterSepSymbol)s).getSymbol());
        }
        if (s instanceof IterSymbol) {
            return this.topdownHasSpaces(((IterSymbol)s).getSymbol());
        }
        return false;
    }

    private boolean containsOptSymbol(org.metaborg.sdf2table.grammar.ISymbol s) {
        if (s instanceof ContextFreeSymbol) {
            return this.containsOptSymbol(((ContextFreeSymbol)s).getSymbol());
        }
        if (s instanceof LexicalSymbol) {
            return this.containsOptSymbol(((LexicalSymbol)s).getSymbol());
        }
        return s instanceof OptionalSymbol;
    }

    private boolean isIterSymbol(org.metaborg.sdf2table.grammar.ISymbol s) {
        return s instanceof IterSymbol || s instanceof IterStarSymbol || s instanceof IterStarSepSymbol || s instanceof IterSepSymbol;
    }

    public IProduction getProduction() {
        return this.p;
    }

    @Override
    public String sort() {
        return this.sort;
    }

    @Override
    public String constructor() {
        if (this.constructor != null) {
            return this.constructor.getConstructor();
        }
        return null;
    }

    @Override
    public String descriptor() {
        return "";
    }

    @Override
    public ConcreteSyntaxContext concreteSyntaxContext() {
        if (this.isLayout) {
            return ConcreteSyntaxContext.Layout;
        }
        if (this.isLiteral) {
            return ConcreteSyntaxContext.Literal;
        }
        if (this.isLexical) {
            return ConcreteSyntaxContext.Lexical;
        }
        return ConcreteSyntaxContext.ContextFree;
    }

    @Override
    public boolean isContextFree() {
        return this.isContextFree;
    }

    @Override
    public boolean isLayout() {
        return this.isLayout;
    }

    @Override
    public boolean isLiteral() {
        return this.isLiteral;
    }

    @Override
    public boolean isLexical() {
        return this.isLexical;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isRecovery() {
        return this.isRecovery;
    }

    @Override
    public boolean isCompletion() {
        return this.isCompletion;
    }

    @Override
    public boolean isStringLiteral() {
        return this.isStringLiteral;
    }

    @Override
    public boolean isNumberLiteral() {
        return this.isNumberLiteral;
    }

    @Override
    public boolean isOperator() {
        return this.isOperator;
    }

    @Override
    public boolean isIgnoreLayoutConstraint() {
        return this.isIgnoreLayoutConstraint;
    }

    public String toString() {
        String s = this.p.leftHand().toString();
        if (this.constructor != null) {
            s = String.valueOf(s) + "." + this.constructor();
        }
        s = String.valueOf(s) + " = ";
        int i = 0;
        while (i < this.p.arity()) {
            if (i != 0) {
                s = String.valueOf(s) + " ";
            }
            s = String.valueOf(s) + this.p.rightHand().get(i).toString();
            ++i;
        }
        return s;
    }

    public ProductionType getProductionType() {
        return this.type;
    }

    public Set<LayoutConstraintAttribute> getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public final long contextL() {
        return this.cachedContextBitmapL;
    }

    public final long contextR() {
        return this.cachedContextBitmapR;
    }

    @Override
    public ISymbol lhs() {
        return this.p.leftHand().toParseTableSymbol();
    }

    @Override
    public int id() {
        return this.productionNumber;
    }

    @Override
    public String startSymbolSort() {
        if (this.getProduction().leftHand() instanceof StartSymbol) {
            for (org.metaborg.sdf2table.grammar.ISymbol s : this.getProduction().rightHand()) {
                if (s instanceof ContextualSymbol) {
                    s = ((ContextualSymbol)s).getOrigSymbol();
                }
                if (Symbol.getSort(s) == null) continue;
                return Symbol.getSort(s);
            }
        }
        return null;
    }

    @Override
    public boolean isLongestMatch() {
        return this.isLongestMatch;
    }

    @Override
    public boolean isBracket() {
        return this.isBracket;
    }
}

