/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.analysis.constraint;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mb.flowspec.terms.B;
import mb.nabl2.terms.stratego.StrategoTermIndices;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.analysis.IAnalyzeResults;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.spoofax.core.analysis.AnalysisCommon;
import org.metaborg.spoofax.core.analysis.AnalysisFacet;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzer;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.context.constraint.IConstraintContext;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.spoofax.core.unit.AnalyzeContrib;
import org.metaborg.spoofax.core.unit.AnalyzeUpdateData;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnitUpdate;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public abstract class AbstractConstraintAnalyzer
implements ISpoofaxAnalyzer {
    private static final ILogger logger = LoggerUtils.logger(AbstractConstraintAnalyzer.class);
    protected final AnalysisCommon analysisCommon;
    protected final IResourceService resourceService;
    protected final IStrategoRuntimeService runtimeService;
    protected final IStrategoCommon strategoCommon;
    protected final ISpoofaxTracingService tracingService;
    protected final ISpoofaxUnitService unitService;
    protected final ITermFactory termFactory;

    public AbstractConstraintAnalyzer(AnalysisCommon analysisCommon, IResourceService resourceService, IStrategoRuntimeService runtimeService, IStrategoCommon strategoCommon, ITermFactory termFactory, ISpoofaxTracingService tracingService, ISpoofaxUnitService unitService) {
        this.analysisCommon = analysisCommon;
        this.resourceService = resourceService;
        this.runtimeService = runtimeService;
        this.strategoCommon = strategoCommon;
        this.tracingService = tracingService;
        this.unitService = unitService;
        this.termFactory = termFactory;
    }

    protected abstract boolean multifile();

    @Override
    public ISpoofaxAnalyzeResult analyze(ISpoofaxParseUnit input, IContext genericContext, IProgress progress, ICancel cancel) throws AnalysisException {
        IAnalyzeResults results = this.analyzeAll((Iterable)Iterables2.singleton(input), genericContext, progress, cancel);
        if (results.results().isEmpty()) {
            throw new AnalysisException(genericContext, "Analysis failed, no result was returned.");
        }
        return new SpoofaxAnalyzeResult((ISpoofaxAnalyzeUnit)Iterables.getOnlyElement(results.results()), results.updates(), results.context());
    }

    @Override
    public ISpoofaxAnalyzeResults analyzeAll(Iterable<ISpoofaxParseUnit> inputs, IContext genericContext, IProgress progress, ICancel cancel) throws AnalysisException {
        HybridInterpreter runtime;
        IConstraintContext context;
        try {
            context = (IConstraintContext)genericContext;
        }
        catch (ClassCastException ex) {
            throw new AnalysisException(genericContext, "Constraint context required.", ex);
        }
        ILanguageImpl langImpl = context.language();
        FacetContribution<AnalysisFacet> facetContribution = langImpl.facetContribution(AnalysisFacet.class);
        if (facetContribution == null) {
            logger.debug("No analysis required for {}", langImpl);
            return new SpoofaxAnalyzeResults(context);
        }
        AnalysisFacet facet = (AnalysisFacet)facetContribution.facet;
        try {
            runtime = this.runtimeService.runtime(facetContribution.contributor, context);
        }
        catch (MetaborgException e) {
            throw new AnalysisException(context, "Failed to get Stratego runtime", e);
        }
        HashMap changed = Maps.newHashMap();
        HashMap removed = Maps.newHashMap();
        HashMap invalid = Maps.newHashMap();
        for (ISpoofaxParseUnit input : inputs) {
            if (input.detached() || input.source() == null) {
                logger.warn("Ignoring detached units");
                continue;
            }
            String source = context.resourceKey(input.source());
            if (!input.valid() || !input.success()) {
                invalid.put(source, (ISpoofaxAnalyzeUnit)this.unitService.emptyAnalyzeUnit(input, context));
                continue;
            }
            if (!this.isEmptyAST(input.ast())) {
                changed.put(source, input);
                continue;
            }
            removed.put(source, (ISpoofaxAnalyzeUnit)this.unitService.emptyAnalyzeUnit(input, context));
        }
        return this.doAnalysis(changed, removed, invalid, context, runtime, facet.strategyName, progress, cancel);
    }

    private boolean isEmptyAST(IStrategoTerm ast) {
        return TermUtils.isTuple(ast, 0);
    }

    /*
     * WARNING - void declaration
     */
    private ISpoofaxAnalyzeResults doAnalysis(Map<String, ISpoofaxParseUnit> changed, Map<String, ISpoofaxAnalyzeUnit> removed, Map<String, ISpoofaxAnalyzeUnit> invalid, IConstraintContext context, HybridInterpreter runtime, String strategy, IProgress progress, ICancel cancel) throws AnalysisException {
        IStrategoTerm allResultsTerm;
        IStrategoTerm analysis;
        String resource;
        IStrategoTuple projectChange;
        ArrayList<IStrategoTuple> changes = new ArrayList<IStrategoTuple>();
        HashMap<String, Expect> expects = new HashMap<String, Expect>();
        if (this.multifile()) {
            Expect expect;
            IStrategoTerm change;
            String string = context.resourceKey(context.root());
            Iterator<Map.Entry<String, Object>> ast = this.projectAST(string);
            if (context.contains(string)) {
                IStrategoTerm analysis2 = context.get(string);
                change = this.build("Cached", analysis2);
                expect = new Update(string, context);
                context.remove(string);
            } else {
                change = this.build("Added", new IStrategoTerm[]{ast});
                expect = new Project(string, context);
            }
            expects.put(string, expect);
            projectChange = this.termFactory.makeTuple(this.termFactory.makeString(string), change);
        } else {
            projectChange = null;
        }
        for (Map.Entry entry : removed.entrySet()) {
            resource = (String)entry.getKey();
            if (!context.contains((String)entry.getKey())) continue;
            analysis = context.get(resource);
            changes.add(this.termFactory.makeTuple(this.termFactory.makeString(resource), this.build("Removed", analysis)));
            context.remove(resource);
        }
        for (Map.Entry<String, ISpoofaxParseUnit> entry : changed.entrySet()) {
            void var17_25;
            resource = entry.getKey();
            ISpoofaxParseUnit input = entry.getValue();
            IStrategoTerm ast = input.ast();
            if (context.contains(resource)) {
                IStrategoTerm analysis3 = context.get(resource);
                IStrategoTerm iStrategoTerm = this.build("Changed", ast, analysis3);
                context.remove(resource);
            } else {
                IStrategoTerm iStrategoTerm = this.build("Added", ast);
            }
            expects.put(resource, new Full(resource, input, context));
            changes.add(this.termFactory.makeTuple(new IStrategoTerm[]{this.termFactory.makeString(resource), var17_25}));
        }
        if (this.multifile()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                resource = entry.getKey();
                analysis = (IStrategoTerm)entry.getValue();
                if (changed.containsKey(resource)) continue;
                IStrategoTerm change = this.build("Cached", analysis);
                expects.put(resource, new Update(resource, context));
                changes.add(this.termFactory.makeTuple(this.termFactory.makeString(resource), change));
            }
        }
        HashMap<String, IStrategoTerm> hashMap = new HashMap<String, IStrategoTerm>();
        IStrategoTerm action = this.multifile() ? this.build("AnalyzeMulti", projectChange, this.termFactory.makeList(changes), B.blob(progress), B.blob(cancel)) : this.build("AnalyzeSingle", this.termFactory.makeList(changes), B.blob(progress), B.blob(cancel));
        try {
            allResultsTerm = this.strategoCommon.invoke(runtime, action, strategy);
        }
        catch (MetaborgException ex) {
            throw new AnalysisException((IContext)context, (Throwable)ex);
        }
        if (allResultsTerm == null) {
            throw new AnalysisException((IContext)context, "Analysis strategy failed");
        }
        List<IStrategoTerm> allResultTerms = this.match(allResultsTerm, "AnalysisResult", 1);
        if (allResultTerms == null) {
            throw new AnalysisException((IContext)context, "Invalid analysis result, got " + allResultsTerm);
        }
        IStrategoTerm resultsTerm = allResultTerms.get(0);
        if (!TermUtils.isList(resultsTerm)) {
            throw new AnalysisException((IContext)context, "Expected list of results, got " + resultsTerm);
        }
        IStrategoTerm[] iStrategoTermArray = resultsTerm.getAllSubterms();
        int n = iStrategoTermArray.length;
        int analysis3 = 0;
        while (analysis3 < n) {
            IStrategoTerm iStrategoTerm = iStrategoTermArray[analysis3];
            if (!TermUtils.isTuple(iStrategoTerm, 2)) {
                throw new AnalysisException((IContext)context, "Expected tuple result, got " + iStrategoTerm);
            }
            IStrategoTerm resourceTerm = iStrategoTerm.getSubterm(0);
            IStrategoTerm resultTerm = iStrategoTerm.getSubterm(1);
            if (!TermUtils.isString(resourceTerm)) {
                throw new AnalysisException((IContext)context, "Expected resource string as first component, got " + resourceTerm);
            }
            String resource3 = TermUtils.toJavaString(resourceTerm);
            hashMap.put(resource3, resultTerm);
            ++analysis3;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String resource4 = (String)entry.getKey();
            IStrategoTerm result = (IStrategoTerm)entry.getValue();
            if (expects.containsKey(resource4)) {
                ((Expect)expects.get(resource4)).accept(result);
                continue;
            }
            logger.warn("Got result for invalid file.");
        }
        for (Map.Entry<Object, Object> entry : changed.entrySet()) {
            String resource5 = (String)entry.getKey();
            if (hashMap.containsKey(resource5)) continue;
            ((Expect)expects.get(resource5)).failMessage("Missing analysis result");
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Map.Entry entry : expects.entrySet()) {
            Expect expect = (Expect)entry.getValue();
            arrayListMultimap.putAll(expect.messages);
        }
        HashSet fullResults = Sets.newHashSet();
        HashSet updateResults = Sets.newHashSet();
        for (Expect expect : expects.values()) {
            List fileMessages = arrayListMultimap.get((Object)expect.resource().getName());
            expect.result(fileMessages, fullResults, updateResults);
        }
        fullResults.addAll(removed.values());
        fullResults.addAll(invalid.values());
        return new SpoofaxAnalyzeResults(fullResults, updateResults, context, null);
    }

    private IStrategoTerm projectAST(String resource) {
        IStrategoTuple ast = this.termFactory.makeTuple(new IStrategoTerm[0]);
        ast = StrategoTermIndices.put(TermIndex.of(resource, 0), ast, this.termFactory);
        TermOrigin.of(resource).put(ast);
        return ast;
    }

    protected boolean success(Collection<IMessage> messages) {
        return messages.stream().noneMatch(m -> m.severity().equals(MessageSeverity.ERROR));
    }

    protected IStrategoTerm build(String op, IStrategoTerm ... subterms) {
        return this.termFactory.makeAppl(this.termFactory.makeConstructor(op, subterms.length), subterms);
    }

    @Nullable
    protected List<IStrategoTerm> match(IStrategoTerm term, String op, int n) {
        if (term == null || !TermUtils.isAppl(term) || !TermUtils.isAppl(term, op, n)) {
            return null;
        }
        return ImmutableList.copyOf((Object[])term.getAllSubterms());
    }

    private abstract class Expect {
        protected final String resource;
        protected final IConstraintContext context;
        protected final ListMultimap<FileName, IMessage> messages;

        protected Expect(String resource, IConstraintContext context) {
            this.resource = resource;
            this.context = context;
            this.messages = ArrayListMultimap.create();
        }

        protected FileObject resource() {
            return this.context.keyResource(this.resource);
        }

        protected void resultMessages(IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes) {
            FileName resource = this.resource().getName();
            if (AbstractConstraintAnalyzer.this.multifile()) {
                AbstractConstraintAnalyzer.this.analysisCommon.messages(MessageSeverity.ERROR, errors).forEach(m -> {
                    boolean bl = this.messages.put((Object)(m.source() != null ? m.source().getName() : resource), m);
                });
                AbstractConstraintAnalyzer.this.analysisCommon.messages(MessageSeverity.WARNING, warnings).forEach(m -> {
                    boolean bl = this.messages.put((Object)(m.source() != null ? m.source().getName() : resource), m);
                });
                AbstractConstraintAnalyzer.this.analysisCommon.messages(MessageSeverity.NOTE, notes).forEach(m -> {
                    boolean bl = this.messages.put((Object)(m.source() != null ? m.source().getName() : resource), m);
                });
            } else {
                AbstractConstraintAnalyzer.this.analysisCommon.messages(this.resource(), MessageSeverity.ERROR, errors).forEach(m -> {
                    boolean bl = this.messages.put((Object)resource, m);
                });
                AbstractConstraintAnalyzer.this.analysisCommon.messages(this.resource(), MessageSeverity.WARNING, warnings).forEach(m -> {
                    boolean bl = this.messages.put((Object)resource, m);
                });
                AbstractConstraintAnalyzer.this.analysisCommon.messages(this.resource(), MessageSeverity.NOTE, notes).forEach(m -> {
                    boolean bl = this.messages.put((Object)resource, m);
                });
            }
        }

        protected void failMessage(String message) {
            this.messages.put((Object)this.resource().getName(), (Object)MessageFactory.newAnalysisErrorAtTop(this.resource(), message, null));
        }

        abstract void accept(IStrategoTerm var1);

        abstract void result(Collection<IMessage> var1, Collection<ISpoofaxAnalyzeUnit> var2, Collection<ISpoofaxAnalyzeUnitUpdate> var3);
    }

    private class Full
    extends Expect {
        private ISpoofaxParseUnit input;
        private IStrategoTerm ast;
        private IStrategoTerm analysis;

        public Full(String resource, ISpoofaxParseUnit input, IConstraintContext context) {
            super(resource, context);
            this.input = input;
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Full", 5);
            if (results != null) {
                this.ast = results.get(0);
                this.analysis = results.get(1);
                this.resultMessages(results.get(2), results.get(3), results.get(4));
                if (!this.input.detached()) {
                    this.context.put(this.resource, this.analysis);
                }
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.ast = null;
                this.analysis = null;
                this.failMessage("Analysis failed");
                if (!this.input.detached()) {
                    this.context.remove(this.resource);
                }
            } else {
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            fullResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnit(this.input, new AnalyzeContrib(this.ast != null, AbstractConstraintAnalyzer.this.success(messages), true, this.ast, messages, -1L), this.context));
        }
    }

    private class Project
    extends Expect {
        private IStrategoTerm analysis;

        public Project(String resource, IConstraintContext context) {
            super(resource, context);
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Full", 5);
            if (results != null) {
                this.analysis = results.get(1);
                this.resultMessages(results.get(2), results.get(3), results.get(4));
                this.context.put(this.resource, this.analysis);
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.analysis = null;
                this.failMessage("Analysis failed");
                this.context.remove(this.resource);
            } else {
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            updateResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnitUpdate(this.resource(), new AnalyzeUpdateData(messages), this.context));
        }
    }

    private class Update
    extends Expect {
        private IStrategoTerm analysis;

        private Update(String resource, IConstraintContext context) {
            super(resource, context);
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Update", 4);
            if (results != null) {
                this.analysis = results.get(0);
                this.resultMessages(results.get(1), results.get(2), results.get(3));
                this.context.put(this.resource, this.analysis);
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.analysis = null;
                this.failMessage("Analysis failed");
                this.context.remove(this.resource);
            } else {
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            updateResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnitUpdate(this.resource(), new AnalyzeUpdateData(messages), this.context));
        }
    }
}

