/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.build;

import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.build.CommonPaths;
import org.metaborg.core.project.NameUtil;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class SpoofaxCommonPaths
extends CommonPaths {
    static final ILogger logger = LoggerUtils.logger(SpoofaxCommonPaths.class);

    public SpoofaxCommonPaths(FileObject root) {
        super(root);
    }

    public FileObject iconsDir() {
        return this.resolve(this.root(), "icons");
    }

    public FileObject srcMainDir() {
        return this.resolve(this.root(), "src", "main");
    }

    public FileObject spxArchiveFile(String languageId) {
        return this.resolve(this.targetDir(), String.valueOf(languageId) + ".spoofax-language");
    }

    @Nullable
    public FileObject findEsvMainFile(Iterable<FileObject> sources) {
        return this.find(sources, "Main.esv");
    }

    @Nullable
    public FileObject findSyntaxMainFile(Iterable<FileObject> sources, String languageName) {
        return this.find(sources, String.valueOf(languageName) + ".sdf");
    }

    public FileObject syntaxCompletionMainFile(String languageName) {
        return this.resolve(this.syntaxCompletionSrcGenDir(), String.valueOf(languageName) + ".sdf");
    }

    public FileObject syntaxCompletionMainFileNormalized(String languageName) {
        return this.resolve(this.syntaxNormalizedCompletionSrcGenDir(), String.valueOf(languageName) + "-norm.aterm");
    }

    public FileObject syntaxNormDir() {
        return this.resolve(this.syntaxSrcGenDir(), "normalized");
    }

    public FileObject syntaxSrcGenDir() {
        return this.resolve(this.srcGenDir(), "syntax");
    }

    public FileObject syntaxCompletionSrcGenDir() {
        return this.resolve(this.syntaxSrcGenDir(), "completion");
    }

    private FileObject syntaxNormalizedCompletionSrcGenDir() {
        return this.resolve(this.syntaxNormDir(), "completion");
    }

    public FileObject syntaxSrcGenMainFile(String languageName) {
        return this.resolve(this.syntaxSrcGenDir(), String.valueOf(languageName) + ".sdf");
    }

    public FileObject syntaxSrcGenMainNormFile(String languageName) {
        return this.resolve(this.syntaxNormDir(), String.valueOf(languageName) + "-norm.aterm");
    }

    public FileObject syntaxSrcGenSignatureDir() {
        return this.resolve(this.srcGenDir(), "signatures");
    }

    public FileObject syntaxSrcGenPpDir() {
        return this.resolve(this.srcGenDir(), "pp");
    }

    @Nullable
    public FileObject findStrMainFile(Iterable<FileObject> sources, String languageName) {
        return this.find(sources, String.valueOf(NameUtil.toJavaId(languageName.toLowerCase())) + ".str");
    }

    public String strJavaTransPkg(String languageId) {
        return String.valueOf(NameUtil.toJavaId(languageId)) + ".trans";
    }

    public FileObject strJavaStratDir() {
        return this.resolve(this.srcMainDir(), "strategies");
    }

    public String strJavaStratPkg(String languageId) {
        String pkg = String.valueOf(NameUtil.toJavaId(languageId)) + ".strategies";
        return pkg;
    }

    public String strJavaStratPkgPath(String languageId) {
        String pkg = this.strJavaStratPkg(languageId);
        String pkgPath = pkg.replace('.', '/');
        return pkgPath;
    }

    public FileObject strMainJavaStratFile(String languageId) {
        String path = this.strJavaStratPkgPath(languageId);
        return this.resolve(this.strJavaStratDir(), path, "Main.java");
    }

    public FileObject strCacheDir() {
        return this.resolve(this.targetDir(), "stratego-cache");
    }

    public FileObject strSepCompSrcGenDir() {
        return this.resolve(this.srcGenDir(), "stratego_sugar");
    }

    public FileObject strSepCompStrategyDir(String strategy) {
        return this.resolve(this.strSepCompSrcGenDir(), this.capitalsForDollars(strategy));
    }

    public FileObject strSepCompStrategyFile(String projectName, String moduleName, String strategy) {
        return this.resolve(this.strSepCompStrategyDir(strategy), String.valueOf(this.prepareModuleName(projectName, moduleName)) + ".aterm");
    }

    public FileObject strSepCompConstrListFile(String projectName, String moduleName, String strategy) {
        return this.resolve(this.strSepCompStrategyDir(strategy), String.valueOf(this.prepareConstrListName(projectName, moduleName)) + ".aterm");
    }

    public FileObject strSepCompOverlayDir(String overlayName) {
        return this.resolve(this.strSepCompSrcGenDir(), "overlays", this.capitalsForDollars(overlayName));
    }

    public FileObject strSepCompOverlayFile(String projectName, String moduleName, String overlayName) {
        return this.resolve(this.strSepCompOverlayDir(overlayName), String.valueOf(this.prepareModuleName(projectName, moduleName)) + ".aterm");
    }

    public FileObject strSepCompBoilerplateFile(String projectName, String moduleName) {
        return this.resolve(this.strSepCompSrcGenDir(), String.valueOf(this.prepareModuleName(projectName, moduleName)) + ".aterm");
    }

    public FileObject strSepCompPackedStrategyFile(String strategy) {
        return this.resolve(this.strSepCompStrategyDir(strategy), "packed$.aterm");
    }

    public FileObject strSepCompPackedBoilerplateFile() {
        return this.resolve(this.strSepCompSrcGenDir(), "packed$.aterm");
    }

    public String capitalsForDollars(String strategy) {
        return strategy.replaceAll("[A-Z]", "\\$$0");
    }

    public String prepareModuleName(String projectName, String moduleName) {
        return String.valueOf(projectName) + "&" + this.capitalsForDollars(moduleName).replace('/', '+');
    }

    public String prepareConstrListName(String projectName, String moduleName) {
        return String.valueOf(projectName) + "&" + this.capitalsForDollars(moduleName).replace('/', '+') + "&constrs";
    }

    @Nullable
    public FileObject findDsMainFile(Iterable<FileObject> sources, String languageName) {
        return this.find(sources, String.valueOf(languageName) + ".ds");
    }

    public FileObject dsManualJavaDir() {
        return this.resolve(this.srcMainDir(), "ds");
    }

    public FileObject dsSrcGenJavaDir() {
        return this.resolve(this.srcGenDir(), "ds-java");
    }

    public Collection<FileObject> javaSrcDirs(String languageId) {
        return Lists.newArrayList((Object[])new FileObject[]{this.strJavaStratDir(), this.dsManualJavaDir(), this.dsSrcGenJavaDir()});
    }
}

