/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.config;

import com.google.inject.Inject;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.AConfigService;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;
import org.metaborg.core.project.IProject;
import org.metaborg.spoofax.core.config.ISpoofaxProjectConfig;
import org.metaborg.spoofax.core.config.ISpoofaxProjectConfigService;
import org.metaborg.spoofax.core.config.ISpoofaxProjectConfigWriter;
import org.metaborg.spoofax.core.config.SpoofaxProjectConfig;
import org.metaborg.spoofax.core.config.SpoofaxProjectConfigBuilder;

public class SpoofaxProjectConfigService
extends AConfigService<IProject, ISpoofaxProjectConfig>
implements ISpoofaxProjectConfigService,
ISpoofaxProjectConfigWriter {
    private final SpoofaxProjectConfigBuilder configBuilder;

    @Inject
    public SpoofaxProjectConfigService(AConfigurationReaderWriter configReaderWriter, SpoofaxProjectConfigBuilder configBuilder) {
        super(configReaderWriter);
        this.configBuilder = configBuilder;
    }

    @Override
    public IProjectConfig defaultConfig(FileObject rootFolder) {
        this.configBuilder.reset();
        return this.configBuilder.build(rootFolder);
    }

    @Override
    @Nullable
    public ISpoofaxProjectConfig get(IProject project) {
        if (project.config() instanceof ISpoofaxProjectConfig) {
            return (ISpoofaxProjectConfig)project.config();
        }
        return null;
    }

    @Override
    protected FileObject getRootDirectory(IProject project) throws FileSystemException {
        return project.location();
    }

    @Override
    protected FileObject getConfigFile(FileObject rootFolder) throws FileSystemException {
        return rootFolder.resolveFile("metaborg.yaml");
    }

    @Override
    protected ConfigRequest<ISpoofaxProjectConfig> toConfig(HierarchicalConfiguration<ImmutableNode> config, FileObject configFile) {
        SpoofaxProjectConfig projectConfig = new SpoofaxProjectConfig(config);
        MessageBuilder mb = MessageBuilder.create().asError().asInternal().withSource(configFile);
        Collection<IMessage> messages = projectConfig.validate(mb);
        return new ConfigRequest<ISpoofaxProjectConfig>(projectConfig, messages);
    }

    @Override
    protected HierarchicalConfiguration<ImmutableNode> fromConfig(ISpoofaxProjectConfig config) {
        if (!(config instanceof IConfig)) {
            this.configBuilder.reset();
            this.configBuilder.copyFrom(config);
            config = this.configBuilder.build((FileObject)null);
        }
        return ((IConfig)((Object)config)).getConfig();
    }
}

