/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language.dialect;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.IdentificationFacet;
import org.metaborg.core.language.dialect.IDialectIdentifier;
import org.metaborg.core.language.dialect.IDialectService;
import org.metaborg.core.language.dialect.IdentifiedDialect;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.binary.TermReader;
import org.spoofax.terms.util.TermUtils;

public class DialectIdentifier
implements IDialectIdentifier {
    private static final ILogger logger = LoggerUtils.logger(DialectIdentifier.class);
    private final ILanguageService languageService;
    private final IDialectService dialectService;
    private final ITermFactory termFactory;

    @Inject
    public DialectIdentifier(ILanguageService languageService, IDialectService dialectService, ITermFactory termFactory) {
        this.languageService = languageService;
        this.dialectService = dialectService;
        this.termFactory = termFactory;
    }

    @Override
    public IdentifiedDialect identify(FileObject resource) throws MetaborgException {
        String name;
        block9: {
            FileObject metaResource;
            block8: {
                ILanguage strategoLanguage = this.languageService.getLanguage("Stratego-Sugar");
                if (strategoLanguage == null) {
                    String message = logger.format("Could not find Stratego language, Stratego dialects cannot be identified for resource: {}", resource);
                    throw new MetaborgRuntimeException(message);
                }
                ILanguageImpl strategoImpl = strategoLanguage.activeImpl();
                if (strategoImpl == null) {
                    return null;
                }
                IdentificationFacet facet = strategoImpl.facet(IdentificationFacet.class);
                if (facet == null || !facet.identify(resource)) {
                    return null;
                }
                metaResource = DialectIdentifier.metaResource(resource);
                if (metaResource != null) break block8;
                return null;
            }
            TermReader termReader = new TermReader(this.termFactory);
            IStrategoTerm term = termReader.parseFromStream(metaResource.getContent().getInputStream());
            name = DialectIdentifier.getSyntaxName(term.getSubterm(0));
            if (name != null) break block9;
            return null;
        }
        try {
            ILanguageImpl dialect = this.dialectService.getDialect(name);
            if (dialect == null) {
                String message = String.format("Resource %s requires dialect %s, but that dialect does not exist", resource, name);
                throw new MetaborgException(message);
            }
            ILanguageImpl base = this.dialectService.getBase(dialect);
            return new IdentifiedDialect(dialect, base);
        }
        catch (IOException | ParseError e) {
            throw new MetaborgException("Unable to open or parse .meta file", e);
        }
    }

    @Override
    public boolean identify(FileObject resource, ILanguageImpl dialect) throws MetaborgException {
        IdentifiedDialect identified = this.identify(resource);
        return dialect.equals(identified.dialect);
    }

    public static FileObject metaResource(FileObject resource) {
        FileObject metaResource;
        block7: {
            FileObject parent;
            String metaResourceName;
            block6: {
                String fileName;
                block5: {
                    try {
                        String path = resource.getName().getPath();
                        fileName = FilenameUtils.getBaseName((String)path);
                        if (!fileName.isEmpty()) break block5;
                        return null;
                    }
                    catch (FileSystemException e) {
                        return null;
                    }
                }
                metaResourceName = String.valueOf(fileName) + ".meta";
                parent = resource.getParent();
                if (parent != null) break block6;
                return null;
            }
            metaResource = parent.getChild(metaResourceName);
            if (metaResource != null && metaResource.exists()) break block7;
            return null;
        }
        return metaResource;
    }

    private static String getSyntaxName(IStrategoTerm entries) {
        IStrategoTerm[] iStrategoTermArray = entries.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm entry = iStrategoTermArray[n2];
            String cons = ((IStrategoAppl)entry).getConstructor().getName();
            if (cons.equals("Syntax")) {
                return TermUtils.toJavaStringAt(entry, 0);
            }
            ++n2;
        }
        return null;
    }
}

