/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.config.JSGLRVersion;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.messages.MessageUtils;
import org.metaborg.core.source.SourceRegion;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.spoofax.core.syntax.IParserConfig;
import org.metaborg.spoofax.core.syntax.JSGLRI;
import org.metaborg.spoofax.core.syntax.JSGLRParserConfiguration;
import org.metaborg.spoofax.core.syntax.SourceAttachment;
import org.metaborg.spoofax.core.unit.ParseContrib;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr2.JSGLR2;
import org.spoofax.jsglr2.JSGLR2Logging;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.JSGLR2Result;
import org.spoofax.jsglr2.JSGLR2Spec;
import org.spoofax.jsglr2.JSGLR2Success;
import org.spoofax.jsglr2.JSGLR2Variant;
import org.spoofax.jsglr2.messages.Message;

public class JSGLR2I
extends JSGLRI<IParseTable> {
    private final JSGLR2<IStrategoTerm> parser;

    public JSGLR2I(IParserConfig config, ITermFactory termFactory, ILanguageImpl language, ILanguageImpl dialect, JSGLRVersion jsglrVersion, org.metaborg.core.config.JSGLR2Logging jsglr2Logging) throws IOException {
        super(config, termFactory, language, dialect);
        this.parseTable = (IParseTable)this.getParseTable(config.getParseTableProvider());
        this.parser = this.getJSGLR2Spec(jsglrVersion, jsglr2Logging).getJSGLR2((IParseTable)this.parseTable);
    }

    private JSGLR2Spec getJSGLR2Spec(JSGLRVersion jsglrVersion, org.metaborg.core.config.JSGLR2Logging jsglr2Logging) {
        return new JSGLR2Spec(this.jsglrVersionToJSGLR2Preset(jsglrVersion), this.getJSGLR2Logging(jsglr2Logging));
    }

    private JSGLR2Variant.Preset jsglrVersionToJSGLR2Preset(JSGLRVersion jsglrVersion) {
        switch (jsglrVersion) {
            case dataDependent: {
                return JSGLR2Variant.Preset.dataDependent;
            }
            case incremental: {
                return JSGLR2Variant.Preset.incremental;
            }
            case layoutSensitive: {
                return JSGLR2Variant.Preset.layoutSensitive;
            }
            case recovery: {
                return JSGLR2Variant.Preset.recovery;
            }
            case recoveryIncremental: {
                return JSGLR2Variant.Preset.recoveryIncremental;
            }
        }
        return JSGLR2Variant.Preset.standard;
    }

    private JSGLR2Logging getJSGLR2Logging(org.metaborg.core.config.JSGLR2Logging jsglr2Logging) {
        switch (jsglr2Logging) {
            case all: {
                return JSGLR2Logging.All;
            }
            case minimal: {
                return JSGLR2Logging.Minimal;
            }
            case parsing: {
                return JSGLR2Logging.Parsing;
            }
            case recovery: {
                return JSGLR2Logging.Recovery;
            }
        }
        return JSGLR2Logging.None;
    }

    @Override
    public ParseContrib parse(@Nullable JSGLRParserConfiguration parserConfig, @Nullable FileObject resource, String input) {
        if (parserConfig == null) {
            parserConfig = new JSGLRParserConfiguration();
        }
        String fileName = resource != null ? resource.getName().getURI() : "";
        String startSymbol = this.getOrDefaultStartSymbol(parserConfig);
        Timer timer = new Timer(true);
        JSGLR2Request request = new JSGLR2Request(input, fileName, startSymbol, 5, 10, parserConfig.completion ? Optional.of(parserConfig.cursorPosition) : Optional.empty());
        JSGLR2Result<IStrategoTerm> result = this.parser.parseResult(request);
        IStrategoTerm ast = result.isSuccess() ? (IStrategoTerm)((JSGLR2Success)result).ast : null;
        boolean isAmbiguous = result.isSuccess() && ((JSGLR2Success)result).isAmbiguous();
        Collection<IMessage> messages = this.mapMessages(resource, result.messages);
        messages.addAll(this.addDisambiguationWarnings(ast, resource));
        long duration = timer.stop();
        boolean hasAst = ast != null;
        boolean hasErrors = MessageUtils.containsSeverity(messages, MessageSeverity.ERROR);
        if (hasAst && resource != null) {
            SourceAttachment.putSource(ast, resource);
        }
        return new ParseContrib(hasAst, hasAst && !hasErrors, isAmbiguous, ast, messages, duration);
    }

    private Collection<IMessage> mapMessages(FileObject resource, Collection<Message> messages) {
        return messages.stream().map(message -> {
            MessageSeverity severity;
            SourceRegion region = null;
            if (message.region != null) {
                region = new SourceRegion(message.region.startOffset, message.region.startRow, message.region.startColumn, message.region.endOffset, message.region.endRow, message.region.endColumn);
            }
            switch (message.severity) {
                case WARNING: {
                    severity = MessageSeverity.WARNING;
                    break;
                }
                default: {
                    severity = MessageSeverity.ERROR;
                }
            }
            return MessageFactory.newParseMessage(resource, region, message.message, severity, null);
        }).collect(Collectors.toList());
    }

    @Override
    public Set<BadTokenException> getCollectedErrors() {
        return Collections.emptySet();
    }

    @Override
    public SetMultimap<String, String> getNonAssocPriorities() {
        return ((ParseTable)this.parseTable).normalizedGrammar().getNonAssocPriorities();
    }

    @Override
    public SetMultimap<String, String> getNonNestedPriorities() {
        return ((ParseTable)this.parseTable).normalizedGrammar().getNonNestedPriorities();
    }
}

