/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.spoofax.core.syntax.IParseTableProvider;
import org.metaborg.spoofax.core.syntax.IParserConfig;
import org.metaborg.spoofax.core.syntax.JSGLRParserConfiguration;
import org.metaborg.spoofax.core.syntax.JSGLRSourceRegionFactory;
import org.metaborg.spoofax.core.unit.ParseContrib;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.terms.util.TermUtils;

public abstract class JSGLRI<PT> {
    protected final IParserConfig config;
    protected final ITermFactory termFactory;
    protected final ILanguageImpl language;
    protected final ILanguageImpl dialect;
    protected PT parseTable;

    public JSGLRI(IParserConfig config, ITermFactory termFactory, ILanguageImpl language, ILanguageImpl dialect) {
        this.config = config;
        this.termFactory = termFactory;
        this.language = language;
        this.dialect = dialect;
    }

    protected PT getParseTable(IParseTableProvider parseTableProvider) throws IOException {
        return (PT)parseTableProvider.parseTable();
    }

    public abstract ParseContrib parse(@Nullable JSGLRParserConfiguration var1, @Nullable FileObject var2, String var3);

    public abstract Set<BadTokenException> getCollectedErrors();

    protected String getOrDefaultStartSymbol(@Nullable JSGLRParserConfiguration parserConfig) {
        if (parserConfig != null && parserConfig.overridingStartSymbol != null) {
            return parserConfig.overridingStartSymbol;
        }
        return this.config.getStartSymbol();
    }

    public IParserConfig getConfig() {
        return this.config;
    }

    public ILanguageImpl getLanguage() {
        return this.language;
    }

    public ILanguageImpl getDialect() {
        return this.dialect;
    }

    public abstract SetMultimap<String, String> getNonAssocPriorities();

    public abstract SetMultimap<String, String> getNonNestedPriorities();

    protected Collection<? extends IMessage> addDisambiguationWarnings(IStrategoTerm ast, @Nullable FileObject resource) {
        ArrayList result = Lists.newArrayList();
        boolean addedMessage = false;
        if (TermUtils.isAppl(ast) && ast.getAllSubterms().length >= 1) {
            ISourceRegion region;
            String sortConsChild;
            String sortConsParent = String.valueOf(ImploderAttachment.getSort(ast)) + "." + ((IStrategoAppl)ast).getConstructor().getName();
            IStrategoTerm firstChild = ast.getSubterm(0);
            IStrategoTerm lastChild = ast.getSubterm(ast.getSubtermCount() - 1);
            if (TermUtils.isAppl(firstChild)) {
                IStrategoAppl leftMostChild = (IStrategoAppl)firstChild;
                ImploderAttachment leftMostChildAttachment = ImploderAttachment.get(leftMostChild);
                sortConsChild = String.valueOf(ImploderAttachment.getSort(ast)) + "." + leftMostChild.getConstructor().getName();
                if (leftMostChildAttachment != null && !leftMostChildAttachment.isBracket() && this.parseTable instanceof ParseTable && this.getNonAssocPriorities().containsEntry((Object)sortConsParent, (Object)sortConsChild)) {
                    region = JSGLRSourceRegionFactory.fromTokens(ImploderAttachment.getLeftToken(ast), ImploderAttachment.getRightToken(ast));
                    result.add(MessageFactory.newParseWarning(resource, region, "Operator is non-associative", null));
                    addedMessage = true;
                }
            }
            if (TermUtils.isAppl(lastChild)) {
                IStrategoAppl rightMostChild = (IStrategoAppl)lastChild;
                ImploderAttachment rightMostChildAttachment = ImploderAttachment.get(rightMostChild);
                sortConsChild = String.valueOf(ImploderAttachment.getSort(ast)) + "." + rightMostChild.getConstructor().getName();
                if (rightMostChildAttachment != null && !rightMostChildAttachment.isBracket() && this.parseTable instanceof ParseTable && this.getNonNestedPriorities().containsEntry((Object)sortConsParent, (Object)sortConsChild)) {
                    region = JSGLRSourceRegionFactory.fromTokens(ImploderAttachment.getLeftToken(ast), ImploderAttachment.getRightToken(ast));
                    result.add(MessageFactory.newParseWarning(resource, region, "Operator is non-nested", null));
                    addedMessage = true;
                }
            }
        }
        if (ast != null && !addedMessage) {
            IStrategoTerm[] iStrategoTermArray = ast.getAllSubterms();
            int n = iStrategoTermArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm child = iStrategoTermArray[n2];
                result.addAll(this.addDisambiguationWarnings(child, resource));
                ++n2;
            }
        }
        return result;
    }
}

