/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.syntax.FenceCharacters;
import org.metaborg.core.syntax.MultiLineCommentCharacters;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.spoofax.core.syntax.ImploderImplementation;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.resource.ResourceUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.terms.util.TermUtils;

public class SyntaxFacetFromESV {
    @Nullable
    public static SyntaxFacet create(IStrategoAppl esv, FileObject location) throws FileSystemException {
        String parseTableLocation = SyntaxFacetFromESV.parseTableLocation(esv);
        FileObject parseTable = parseTableLocation == null ? null : ResourceUtils.resolveFile(location, parseTableLocation);
        FileObject completionParseTable = null;
        Iterable<String> startSymbols = SyntaxFacetFromESV.startSymbols(esv);
        Iterable<String> singleLineCommentPrefixes = SyntaxFacetFromESV.singleLineCommentPrefixes(esv);
        Iterable<MultiLineCommentCharacters> multiLineCommentCharacters = SyntaxFacetFromESV.multiLineCommentCharacters(esv);
        Iterable<FenceCharacters> fenceCharacters = SyntaxFacetFromESV.fenceCharacters(esv);
        ImploderImplementation imploder = SyntaxFacetFromESV.imploder(esv);
        SyntaxFacet syntaxFacet = new SyntaxFacet(parseTable, completionParseTable, startSymbols, singleLineCommentPrefixes, multiLineCommentCharacters, fenceCharacters, imploder);
        return syntaxFacet;
    }

    private static ImploderImplementation imploder(IStrategoAppl document) {
        IStrategoAppl imploder = ESVReader.findTerm(document, "Imploder");
        if (imploder == null) {
            return ImploderImplementation.java;
        }
        IStrategoAppl imploderImpl = TermUtils.toApplAt(imploder, 0);
        switch (imploderImpl.getName()) {
            case "Stratego": {
                return ImploderImplementation.stratego;
            }
            case "Java": {
                return ImploderImplementation.java;
            }
        }
        return ImploderImplementation.java;
    }

    @Nullable
    private static String parseTableLocation(IStrategoAppl document) {
        String file = ESVReader.getProperty(document, "Table");
        if (file == null) {
            return null;
        }
        if (!file.endsWith(".tbl")) {
            file = String.valueOf(file) + ".tbl";
        }
        return file;
    }

    private static Iterable<String> startSymbols(IStrategoAppl document) {
        IStrategoAppl result = ESVReader.findTerm(document, "StartSymbols");
        if (result == null) {
            return null;
        }
        String contents = ESVReader.termContents(result.getSubterm(0).getSubterm(0));
        return Iterables2.singleton(contents);
    }

    private static Iterable<String> singleLineCommentPrefixes(IStrategoAppl document) {
        LinkedList lineCommentPrefixes = Lists.newLinkedList();
        ArrayList<IStrategoAppl> terms = ESVReader.collectTerms(document, "LineCommentPrefix");
        for (IStrategoAppl term : terms) {
            lineCommentPrefixes.add(ESVReader.termContents(term.getSubterm(0)));
        }
        return lineCommentPrefixes;
    }

    private static Iterable<MultiLineCommentCharacters> multiLineCommentCharacters(IStrategoAppl document) {
        LinkedList multiLineCommentCharacters = Lists.newLinkedList();
        ArrayList<IStrategoAppl> terms = ESVReader.collectTerms(document, "BlockCommentDef");
        for (IStrategoAppl term : terms) {
            String prefix = ESVReader.termContents(term.getSubterm(0));
            String postfix = ESVReader.termContents(term.getSubterm(2));
            multiLineCommentCharacters.add(new MultiLineCommentCharacters(prefix, postfix));
        }
        return multiLineCommentCharacters;
    }

    private static Iterable<FenceCharacters> fenceCharacters(IStrategoAppl document) {
        LinkedList fenceCharacters = Lists.newLinkedList();
        ArrayList<IStrategoAppl> terms = ESVReader.collectTerms(document, "FenceDef");
        for (IStrategoAppl term : terms) {
            String open = ESVReader.termContents(term.getSubterm(0));
            String close = ESVReader.termContents(term.getSubterm(1));
            fenceCharacters.add(new FenceCharacters(open, close));
        }
        return fenceCharacters;
    }
}

