/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import io.usethesource.capsule.BinaryRelation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.interpreter.util.EntryAsPairIterator;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;

public class StrategoImmutableRelation
extends StrategoTerm
implements IStrategoTerm {
    public final BinaryRelation.Immutable<IStrategoTerm, IStrategoTerm> backingRelation;

    public StrategoImmutableRelation(BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm> backingRelation) {
        super(TermFactory.EMPTY_LIST);
        this.backingRelation = backingRelation;
    }

    public StrategoImmutableRelation() {
        this((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)BinaryRelation.Immutable.of());
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EntryAsPairIterator(this.backingRelation.entryIterator());
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return AbstractTermFactory.EMPTY_TERM_ARRAY;
    }

    @Override
    @Deprecated
    public int getTermType() {
        return this.getType().getValue();
    }

    @Override
    public TermType getType() {
        return TermType.BLOB;
    }

    @Override
    public void prettyPrint(ITermPrinter pp) {
        pp.print(this.toString());
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        if (!(second instanceof StrategoImmutableRelation)) {
            return false;
        }
        BinaryRelation.Immutable<IStrategoTerm, IStrategoTerm> secondRelation = ((StrategoImmutableRelation)second).backingRelation;
        return this.backingRelation.equals(secondRelation);
    }

    @Override
    protected int hashFunction() {
        return this.backingRelation.hashCode();
    }

    @Override
    public String toString(int maxDepth) {
        return this.backingRelation.toString();
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.toString());
    }

    public IStrategoTerm withWrapper(ITermFactory factory) {
        return factory.makeAppl("ImmutableRelation", this);
    }

    public static StrategoImmutableRelation union(StrategoImmutableRelation one, StrategoImmutableRelation other) {
        BinaryRelation.Transient result = one.backingRelation.asTransient();
        for (Map.Entry e : other.backingRelation.entrySet()) {
            result.__insert((Object)((IStrategoTerm)e.getKey()), (Object)((IStrategoTerm)e.getValue()));
        }
        return new StrategoImmutableRelation((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)result.freeze());
    }

    public static StrategoImmutableRelation intersect(StrategoImmutableRelation one, StrategoImmutableRelation other) {
        BinaryRelation.Transient result = BinaryRelation.Transient.of();
        for (Map.Entry e : one.backingRelation.entrySet()) {
            if (!other.backingRelation.containsEntry(e.getKey(), e.getValue())) continue;
            result.__insert((Object)((IStrategoTerm)e.getKey()), (Object)((IStrategoTerm)e.getValue()));
        }
        return new StrategoImmutableRelation((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)result.freeze());
    }

    public static StrategoImmutableRelation subtract(StrategoImmutableRelation left, StrategoImmutableRelation right) {
        BinaryRelation.Transient result = left.backingRelation.asTransient();
        for (Map.Entry e : right.backingRelation.entrySet()) {
            result.__remove((Object)((IStrategoTerm)e.getKey()), (Object)((IStrategoTerm)e.getValue()));
        }
        return new StrategoImmutableRelation((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)result.freeze());
    }

    public static StrategoImmutableRelation compose(StrategoImmutableRelation left, StrategoImmutableRelation right) {
        BinaryRelation.Transient result = BinaryRelation.Transient.of();
        for (Map.Entry e : left.backingRelation.entrySet()) {
            for (IStrategoTerm value : right.backingRelation.get(e.getValue())) {
                result.__insert((Object)((IStrategoTerm)e.getKey()), (Object)value);
            }
        }
        return new StrategoImmutableRelation((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)result.freeze());
    }

    public static StrategoImmutableRelation reflexiveClosure(StrategoImmutableRelation map) {
        BinaryRelation.Transient result = map.backingRelation.asTransient();
        for (Map.Entry e : map.backingRelation.entrySet()) {
            IStrategoTerm key = (IStrategoTerm)e.getKey();
            IStrategoTerm value = (IStrategoTerm)e.getValue();
            result.__insert((Object)key, (Object)key);
            result.__insert((Object)value, (Object)value);
        }
        return new StrategoImmutableRelation((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)result.freeze());
    }

    public static StrategoImmutableRelation transitiveClosure(StrategoImmutableRelation map) {
        LinkedList<AbstractMap.SimpleImmutableEntry<IStrategoTerm, IStrategoTerm>> worklist = new LinkedList<AbstractMap.SimpleImmutableEntry<IStrategoTerm, IStrategoTerm>>(map.backingRelation.entrySet());
        BinaryRelation.Transient result = map.backingRelation.asTransient();
        while (!worklist.isEmpty()) {
            Map.Entry e = (Map.Entry)worklist.pop();
            for (IStrategoTerm post : map.backingRelation.get(e.getValue())) {
                if (result.containsEntry(e.getKey(), (Object)post)) continue;
                result.__insert((Object)((IStrategoTerm)e.getKey()), (Object)post);
                worklist.add(new AbstractMap.SimpleImmutableEntry<IStrategoTerm, IStrategoTerm>((IStrategoTerm)e.getKey(), post));
            }
        }
        return new StrategoImmutableRelation((BinaryRelation.Immutable<? extends IStrategoTerm, ? extends IStrategoTerm>)result.freeze());
    }
}

