/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.util.DebugUtil;
import org.spoofax.terms.util.TermUtils;

public class CallT
extends Strategy {
    private final String name;
    private final Strategy[] svars;
    private final IStrategoTerm[] tvars;
    static int depth = 0;

    public CallT(String name, Strategy[] svars, IStrategoTerm[] tvars) {
        this.name = name;
        this.svars = svars;
        this.tvars = tvars;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        Object actual;
        Object formal;
        CallT.debug("CallT.eval() - ", env.current());
        SDefT sdef = env.lookupSVar(this.name);
        if (sdef == null) {
            throw new UndefinedStrategyException("Not found '" + this.name + "'", this.name);
        }
        boolean isCompiledStrategy = sdef.isCompiledStrategy();
        if (!isCompiledStrategy) {
            env.getStackTracer().push(this.name);
        }
        if (DebugUtil.tracing) {
            System.err.println("[" + depth + "] - " + sdef.getName());
            ++depth;
        }
        String[] formalTermArgs = sdef.getTermParams();
        SDefT.SVar[] formalStrategyArgs = sdef.getStrategyParams();
        if (DebugUtil.isDebugging()) {
            CallT.printStrategyCall(sdef.getName(), formalStrategyArgs, this.svars, formalTermArgs, this.tvars);
        }
        if (this.svars.length != formalStrategyArgs.length) {
            throw new InterpreterException("Incorrect strategy arguments calling '" + this.name + "', expected " + formalStrategyArgs.length + " got " + this.svars.length);
        }
        if (this.tvars.length != formalTermArgs.length) {
            throw new InterpreterException("Incorrect aterm arguments calling '" + this.name + "' , expected " + formalTermArgs.length + " got " + this.tvars.length);
        }
        VarScope newScope = new VarScope(sdef.getScope());
        int i = 0;
        while (i < this.svars.length) {
            formal = formalStrategyArgs[i];
            actual = this.svars[i];
            SDefT target = null;
            if (actual instanceof CallT && ((CallT)actual).getStrategyArguments().length == 0 && ((CallT)actual).getTermArguments().length == 0) {
                String n = ((CallT)actual).getTargetStrategyName();
                target = env.lookupSVar(n);
                if (target == null) {
                    if (DebugUtil.isDebugging()) {
                        CallT.debug(env.getVarScope().dump(" "));
                    }
                    System.out.println(env.getVarScope());
                    throw new InterpreterException("No strategy '" + n + "'");
                }
            } else {
                SDefT.SVar[] stratArgs = new SDefT.SVar[]{};
                String[] termArgs = new String[]{};
                target = new SDefT(SDefT.createAnonymousName(((SDefT.SVar)formal).name), stratArgs, termArgs, (Strategy)actual, env.getVarScope());
            }
            newScope.addSVar(((SDefT.SVar)formal).name, target);
            ++i;
        }
        i = 0;
        while (i < this.tvars.length) {
            formal = formalTermArgs[i];
            actual = this.tvars[i];
            if (Tools.isVar((IStrategoAppl)actual, env)) {
                actual = env.lookupVar(TermUtils.toJavaStringAt((IStrategoAppl)actual, 0));
            }
            newScope.add((String)formal, (IStrategoTerm)actual);
            ++i;
        }
        VarScope oldVarScope = env.getVarScope();
        env.setVarScope(newScope);
        return this.addHook(sdef.getBody(), isCompiledStrategy, oldVarScope);
    }

    public Strategy evalWithArgs(IContext env, Strategy[] sv, IStrategoTerm[] actualTVars) throws InterpreterException {
        Object formal;
        CallT.debug("CallT.eval() - ", env.current());
        SDefT sdef = env.lookupSVar(this.name);
        if (sdef == null) {
            throw new UndefinedStrategyException("Not found '" + this.name + "'", this.name);
        }
        boolean isCompiledStrategy = sdef.isCompiledStrategy();
        if (!isCompiledStrategy) {
            env.getStackTracer().push(this.name);
        }
        String[] formalTermArgs = sdef.getTermParams();
        SDefT.SVar[] formalStrategyArgs = sdef.getStrategyParams();
        if (DebugUtil.isDebugging()) {
            CallT.printStrategyCall(sdef.getName(), formalStrategyArgs, sv, formalTermArgs, actualTVars);
        }
        if (sv.length != formalStrategyArgs.length) {
            throw new InterpreterException("Incorrect strategy arguments, expected " + formalStrategyArgs.length + " got " + sv.length);
        }
        if (actualTVars.length != formalTermArgs.length) {
            throw new InterpreterException("Incorrect aterm arguments, expected " + formalTermArgs.length + " got " + actualTVars.length);
        }
        VarScope newScope = new VarScope(sdef.getScope());
        int i = 0;
        while (i < sv.length) {
            formal = formalStrategyArgs[i];
            Strategy actual = sv[i];
            SDefT target = null;
            if (actual instanceof CallT && ((CallT)actual).getStrategyArguments().length == 0 && ((CallT)actual).getTermArguments().length == 0) {
                String n = ((CallT)actual).getTargetStrategyName();
                target = env.lookupSVar(n);
                if (target == null) {
                    if (DebugUtil.isDebugging()) {
                        CallT.debug(env.getVarScope().dump(" "));
                    }
                    System.out.println(env.getVarScope());
                    throw new InterpreterException("No strategy '" + n + "'");
                }
            } else {
                SDefT.SVar[] stratArgs = new SDefT.SVar[]{};
                String[] termArgs = new String[]{};
                target = new SDefT(SDefT.createAnonymousName(((SDefT.SVar)formal).name), stratArgs, termArgs, actual, env.getVarScope());
            }
            newScope.addSVar(((SDefT.SVar)formal).name, target);
            ++i;
        }
        i = 0;
        while (i < actualTVars.length) {
            formal = formalTermArgs[i];
            newScope.add((String)formal, actualTVars[i]);
            ++i;
        }
        VarScope oldVarScope = env.getVarScope();
        env.setVarScope(newScope);
        return this.addHook(sdef.getBody(), isCompiledStrategy, oldVarScope);
    }

    private Strategy addHook(Strategy strategy, final boolean isCompiledStrategy, final VarScope oldVarScope) {
        strategy.getHook().push(new Hook(){

            @Override
            public IConstruct onSuccess(IContext env) throws InterpreterException {
                env.setVarScope(oldVarScope);
                if (!isCompiledStrategy) {
                    env.getStackTracer().popOnSuccess();
                }
                return CallT.this.getHook().pop().onSuccess(env);
            }

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.setVarScope(oldVarScope);
                if (!isCompiledStrategy) {
                    env.getStackTracer().popOnFailure();
                }
                return CallT.this.getHook().pop().onFailure(env);
            }
        });
        return strategy;
    }

    private IStrategoTerm[] getTermArguments() {
        return this.tvars;
    }

    @Override
    public String toString() {
        return "CallT(\"" + this.getTargetStrategyName() + "\"," + this.svars + "," + this.tvars + ")";
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("CallT(\n");
        sf.bump(6);
        sf.append("  \"" + this.name + "\"\n");
        sf.append(", " + this.svars + "\n");
        sf.append(", " + this.tvars + "\n");
        sf.append(")");
    }

    static void printStrategyCall(String name, SDefT.SVar[] formalStrategyArgs, IConstruct[] sv, String[] formalTermArgs, IStrategoTerm[] tvarsActual) {
        StringBuilder sb = DebugUtil.buildIndent(2);
        sb.append("call : ").append(name).append("( ");
        String svarNoName = "<s_noname_";
        int i = 0;
        while (i < sv.length) {
            String sVarName;
            String string = sVarName = formalStrategyArgs != null ? formalStrategyArgs[i].name : "<s_noname_" + i + ">";
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(sVarName).append(" = ").append(sv[i]);
            ++i;
        }
        sb.append(" | ");
        String tNoName = "<t_noname_";
        int i2 = 0;
        while (i2 < tvarsActual.length) {
            String termName;
            String string = termName = formalTermArgs != null ? formalTermArgs[i2] : "<t_noname_" + i2 + ">";
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(termName).append(" = ").append(tvarsActual[i2]);
            ++i2;
        }
        sb.append(" ) ");
        CallT.debug(sb);
    }

    public String getTargetStrategyName() {
        return this.name;
    }

    public Strategy[] getStrategyArguments() {
        return this.svars;
    }

    @Override
    protected final String getTraceName() {
        return "call of(" + this.getTargetStrategyName() + ")";
    }

    public boolean evaluateWithArgs(IContext env, Strategy[] sv, IStrategoTerm[] tv) throws InterpreterException {
        Strategy.ResultHook hook = new Strategy.ResultHook();
        this.getHook().push(hook);
        IConstruct c = this.evalWithArgs(env, sv, tv);
        while (c != null) {
            c = c.eval(env);
        }
        return hook.result;
    }
}

