/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.terms;

import org.spoofax.interpreter.terms.ITermPrinter;

public class PrettyPrinter
implements ITermPrinter {
    private int indentationLevel;
    private char[] indentationPrefix;
    private char[] spaces = new char[1024];
    private StringBuilder builder;
    private boolean nextIndentOff;

    public PrettyPrinter() {
        int i = 0;
        while (i < this.spaces.length) {
            this.spaces[i] = 32;
            ++i;
        }
        this.indentationLevel = 0;
        this.builder = new StringBuilder();
        this.indentationPrefix = "".toCharArray();
    }

    @Override
    public void println(String s) {
        this.println(s, true);
    }

    @Override
    public void println(String s, boolean indent) {
        this.print(s, indent);
        this.builder.append('\n');
    }

    @Override
    public void indent(int delta) {
        this.indentationLevel += delta;
        this.recomputeIndentationPrefix();
    }

    @Override
    public void print(String s) {
        this.print(s, true);
    }

    @Override
    public void outdent(int delta) {
        this.indentationLevel -= delta;
        this.recomputeIndentationPrefix();
    }

    private void recomputeIndentationPrefix() {
        this.indentationPrefix = new char[this.indentationLevel];
        int i = 0;
        while (i < this.indentationLevel) {
            this.indentationPrefix[i] = this.spaces[i];
            ++i;
        }
    }

    @Override
    public String getString() {
        return this.builder.toString();
    }

    public void print(String s, boolean indent) {
        this.printIndent(indent);
        this.builder.append(s);
    }

    private void printIndent(boolean doit) {
        if (doit && !this.nextIndentOff) {
            this.builder.append(this.indentationPrefix);
        }
        this.nextIndentOff = false;
    }

    @Override
    public void nextIndentOff() {
        this.nextIndentOff = true;
    }
}

