/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import org.spoofax.jsglr.client.editregion.detection.LCS;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr.client.imploder.Token;

public class DamagedTokenAnalyzer {
    private final AbstractTokenizer tokens;
    private final LCS<Character> lcs;
    private final ArrayList<IToken> tokensDamagedByInsertion;
    private final ArrayList<IToken> tokensDamagedByDeletion;

    public ITokens getTokens() {
        return this.tokens;
    }

    public ArrayList<IToken> getTokensDamagedByInsertion() {
        ArrayList<IToken> result = new ArrayList<IToken>();
        result.addAll(this.tokensDamagedByInsertion);
        return result;
    }

    public ArrayList<IToken> getTokensDamagedByDeletion() {
        ArrayList<IToken> result = new ArrayList<IToken>();
        result.addAll(this.tokensDamagedByDeletion);
        return result;
    }

    public DamagedTokenAnalyzer(AbstractTokenizer tokens, LCS<Character> lcs) {
        this.tokens = tokens;
        this.lcs = lcs;
        this.tokensDamagedByInsertion = new ArrayList();
        this.tokensDamagedByDeletion = new ArrayList();
        this.analyzeDamagedTokens();
    }

    public boolean isDamagedByDeletion(IToken t) {
        ArrayList<Integer> deletions = this.getOffsetsDeletions(t);
        return !deletions.isEmpty();
    }

    public ArrayList<Integer> getOffsetsDeletions(IToken t) {
        int startOffset = t.getStartOffset();
        int endOffset = t.getEndOffset();
        ArrayList<Integer> deletions = new ArrayList<Integer>();
        int j = startOffset;
        while (j <= endOffset) {
            if (this.lcs.getMatchIndexInElems2(j) == -1) {
                deletions.add(j);
            }
            ++j;
        }
        return deletions;
    }

    public boolean isDamagedByInsertion(IToken t) {
        int startOffset = t.getStartOffset();
        int endOffset = t.getEndOffset();
        int offsetPreviousMatch = -1;
        int j = startOffset;
        while (j <= endOffset) {
            int matchIndexInElems2 = this.lcs.getMatchIndexInElems2(j);
            if (offsetPreviousMatch != -1 && matchIndexInElems2 > offsetPreviousMatch + 1) {
                return true;
            }
            offsetPreviousMatch = matchIndexInElems2;
            ++j;
        }
        return false;
    }

    public boolean isDamagingLayoutDeletion(IToken token) {
        int numberOfDeletions = this.getOffsetsDeletions(token).size();
        int startOffset = token.getStartOffset();
        int endOffset = token.getEndOffset();
        if (numberOfDeletions == endOffset - startOffset + 1) {
            int firstMatchedOffsetInPrefix = -1;
            int firstMatchedOffsetInSuffix = -1;
            int offsetInPrefix = startOffset - 1;
            while (offsetInPrefix >= 0) {
                if (this.lcs.getMatchIndexInElems2(offsetInPrefix) != -1) {
                    firstMatchedOffsetInPrefix = offsetInPrefix;
                    break;
                }
                --offsetInPrefix;
            }
            int offsetInSuffix = endOffset + 1;
            while (offsetInSuffix < this.lcs.getElems1().size()) {
                if (this.lcs.getMatchIndexInElems2(offsetInSuffix) != -1) {
                    firstMatchedOffsetInSuffix = offsetInSuffix;
                    break;
                }
                ++offsetInSuffix;
            }
            int firstMatchedOffsetInPrefix_2 = this.lcs.getMatchIndexInElems2(firstMatchedOffsetInPrefix);
            int firstMatchedOffsetInSuffix_2 = this.lcs.getMatchIndexInElems2(firstMatchedOffsetInSuffix);
            return firstMatchedOffsetInSuffix_2 == firstMatchedOffsetInPrefix_2 + 1 && firstMatchedOffsetInPrefix_2 != -1 && firstMatchedOffsetInSuffix_2 != -1 && !this.isOffsetOfLayoutChar((AbstractTokenizer)token.getTokenizer(), firstMatchedOffsetInPrefix) && !this.isOffsetOfLayoutChar((AbstractTokenizer)token.getTokenizer(), firstMatchedOffsetInSuffix);
        }
        return false;
    }

    private boolean isOffsetOfLayoutChar(AbstractTokenizer tokens, int offset) {
        boolean precedingLayout = tokens.getTokenAtOffset(offset).getKind() == IToken.Kind.TK_LAYOUT;
        return precedingLayout;
    }

    private void analyzeDamagedTokens() {
        int i = 0;
        while (i < this.tokens.getTokenCount()) {
            boolean possibleDamaged;
            Token t = this.tokens.getTokenAt(i);
            boolean bl = possibleDamaged = t.getEndOffset() >= this.lcs.getMatchedPrefixSize() - 1 && t.getStartOffset() <= this.lcs.getElems1().size() - this.lcs.getMatchedSuffixSize() + 1;
            if (possibleDamaged) {
                if (this.isDamagedByDeletion(t)) {
                    this.tokensDamagedByDeletion.add(t);
                }
                if (this.isDamagedByInsertion(t)) {
                    this.tokensDamagedByInsertion.add(t);
                }
            }
            ++i;
        }
    }
}

