/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import java.util.List;
import org.spoofax.jsglr.client.editregion.detection.LCSCommand;

public class LCS<T> {
    private final LCSCommand<T> lcsCommand;
    private ArrayList<T> elems1 = new ArrayList();
    private ArrayList<T> elems2 = new ArrayList();
    private ArrayList<Integer> matchedIndices1 = new ArrayList();
    private ArrayList<Integer> matchedIndices2 = new ArrayList();
    private ArrayList<Integer> unMatchedIndices1 = null;
    private ArrayList<Integer> unMatchedIndices2 = null;
    private ArrayList<T> resultLCS1 = null;
    private ArrayList<T> resultLCS2 = null;
    private ArrayList<T> resultUnmatched1 = null;
    private ArrayList<T> resultUnmatched2 = null;
    private int matchedPrefixSize;
    private int matchedSuffixSize;

    public ArrayList<T> getElems1() {
        return this.elems1;
    }

    public ArrayList<T> getElems2() {
        return this.elems2;
    }

    public int getMatchIndex(int index, boolean isInCorrectInputString) {
        if (isInCorrectInputString) {
            return this.getMatchIndexInElems2(index);
        }
        return this.getMatchIndexInElems1(index);
    }

    public int getMatchIndexInElems2(int indexElems1) {
        int lcsIndex = this.matchedIndices1.indexOf(indexElems1);
        if (lcsIndex >= 0) {
            return this.matchedIndices2.get(lcsIndex);
        }
        return -1;
    }

    public int getMatchIndexInElems1(int indexElems2) {
        int lcsIndex = this.matchedIndices2.indexOf(indexElems2);
        if (lcsIndex > 0) {
            return this.matchedIndices1.get(lcsIndex);
        }
        return -1;
    }

    public ArrayList<Integer> getMatchedIndices1() {
        return this.matchedIndices1;
    }

    public ArrayList<Integer> getMatchedIndices2() {
        return this.matchedIndices2;
    }

    public ArrayList<Integer> getUnMatchedIndices1() {
        if (this.unMatchedIndices1 == null) {
            this.unMatchedIndices1 = this.getUnmatchedIndices(this.elems1, this.matchedIndices1);
        }
        return this.unMatchedIndices1;
    }

    public ArrayList<Integer> getUnMatchedIndices2() {
        if (this.unMatchedIndices2 == null) {
            this.unMatchedIndices2 = this.getUnmatchedIndices(this.elems2, this.matchedIndices2);
        }
        return this.unMatchedIndices2;
    }

    public ArrayList<T> getResultLCS1() {
        if (this.resultLCS1 == null) {
            this.resultLCS1 = this.getIncludedElems(this.elems1, this.matchedIndices1);
        }
        return this.resultLCS1;
    }

    public ArrayList<T> getResultLCS2() {
        if (this.resultLCS2 == null) {
            this.resultLCS2 = this.getIncludedElems(this.elems2, this.matchedIndices2);
        }
        return this.resultLCS2;
    }

    public ArrayList<T> getResultUnmatched1() {
        if (this.resultUnmatched1 == null) {
            this.resultUnmatched1 = this.getIncludedElems(this.elems1, this.getUnMatchedIndices1());
        }
        return this.resultUnmatched1;
    }

    public ArrayList<T> getResultUnmatched2() {
        if (this.resultUnmatched2 == null) {
            this.resultUnmatched2 = this.getIncludedElems(this.elems2, this.getUnMatchedIndices2());
        }
        return this.resultUnmatched2;
    }

    public int getLCSSize() {
        return this.matchedIndices1.size();
    }

    public int getMatchedPrefixSize() {
        if (this.matchedPrefixSize == -1) {
            this.matchedPrefixSize = 0;
            while (this.matchedPrefixSize < this.getLCSSize() && this.matchedIndices1.get(this.matchedPrefixSize) == this.matchedPrefixSize && this.matchedIndices2.get(this.matchedPrefixSize) == this.matchedPrefixSize) {
                ++this.matchedPrefixSize;
            }
        }
        return this.matchedPrefixSize;
    }

    public int getMatchedSuffixSize() {
        if (this.matchedSuffixSize == -1) {
            this.matchedSuffixSize = 0;
            int elems1Size = this.elems1.size();
            int elems2Size = this.elems2.size();
            while (this.matchedSuffixSize < this.getLCSSize() && this.matchedIndices1.get(this.getLCSSize() - 1 - this.matchedSuffixSize) == elems1Size - 1 - this.matchedSuffixSize && this.matchedIndices2.get(this.getLCSSize() - 1 - this.matchedSuffixSize) == elems2Size - 1 - this.matchedSuffixSize) {
                ++this.matchedSuffixSize;
            }
        }
        return this.matchedSuffixSize;
    }

    public LCS(LCSCommand<T> lcsCommand) {
        this.lcsCommand = lcsCommand;
        this.matchedPrefixSize = -1;
        this.matchedSuffixSize = -1;
    }

    public LCS<T> createLCSResultsOptimized(List<T> elems1, List<T> elems2) {
        this.clearResults();
        this.elems1.addAll(elems1);
        this.elems2.addAll(elems2);
        return this.createLCSResultsOptimized();
    }

    public LCS<T> createLCSResults(List<T> elems1, List<T> elems2) {
        this.clearResults();
        this.elems1.addAll(elems1);
        this.elems2.addAll(elems2);
        this.lcs(elems1, elems2, 0);
        this.checkAssertions(elems1, elems2);
        return this;
    }

    private void clearResults() {
        this.elems1.clear();
        this.elems2.clear();
        this.matchedIndices1.clear();
        this.matchedIndices2.clear();
        this.unMatchedIndices1 = null;
        this.unMatchedIndices2 = null;
        this.resultLCS1 = null;
        this.resultLCS2 = null;
        this.resultUnmatched1 = null;
        this.resultUnmatched2 = null;
        this.matchedPrefixSize = -1;
        this.matchedSuffixSize = -1;
    }

    private ArrayList<Integer> getUnmatchedIndices(List<T> elems, ArrayList<Integer> indices) {
        assert (elems.size() >= indices.size());
        ArrayList<Integer> unmatchedIndices = new ArrayList<Integer>();
        int indexIndices = 0;
        int nextIncludedIndex = -1;
        if (indexIndices < indices.size()) {
            nextIncludedIndex = indices.get(indexIndices);
        }
        int elems_index = 0;
        while (elems_index < elems.size()) {
            if (elems_index == nextIncludedIndex) {
                nextIncludedIndex = -1;
                if (++indexIndices < indices.size()) {
                    nextIncludedIndex = indices.get(indexIndices);
                }
            } else {
                unmatchedIndices.add(elems_index);
            }
            ++elems_index;
        }
        assert (unmatchedIndices.size() + indices.size() == elems.size());
        return unmatchedIndices;
    }

    private ArrayList<T> getIncludedElems(List<T> elems, ArrayList<Integer> indices) {
        assert (elems.size() >= indices.size());
        ArrayList<T> includedElems = new ArrayList<T>();
        int indexIndices = 0;
        int nextIncludedIndex = -1;
        if (indexIndices < indices.size()) {
            nextIncludedIndex = indices.get(indexIndices);
        }
        int elems_index = 0;
        while (elems_index < elems.size()) {
            if (elems_index == nextIncludedIndex) {
                includedElems.add(elems.get(elems_index));
                nextIncludedIndex = -1;
                if (++indexIndices < indices.size()) {
                    nextIncludedIndex = indices.get(indexIndices);
                }
            }
            ++elems_index;
        }
        assert (includedElems.size() == indices.size());
        return includedElems;
    }

    private LCS<T> createLCSResultsOptimized() {
        int commonPrefixLength = this.commonPrefixLength();
        int commonSuffixLength = this.commonSuffixLength(commonPrefixLength);
        this.addPrefixIndices(commonPrefixLength);
        this.addMidIndices(commonPrefixLength, commonSuffixLength);
        this.addSuffixIndices(commonSuffixLength);
        this.checkAssertions(this.elems1, this.elems2);
        return this;
    }

    private void addMidIndices(int commonPrefixLength, int commonSuffixLength) {
        List<T> elems1_mid = this.elems1.subList(commonPrefixLength, this.elems1.size() - commonSuffixLength);
        List<T> elems2_mid = this.elems2.subList(commonPrefixLength, this.elems2.size() - commonSuffixLength);
        this.lcs(elems1_mid, elems2_mid, commonPrefixLength);
    }

    private void addSuffixIndices(int commonSuffixLength) {
        int suffixIndex = commonSuffixLength - 1;
        while (suffixIndex >= 0) {
            int el1_index = this.elems1.size() - 1 - suffixIndex;
            int el2_index = this.elems2.size() - 1 - suffixIndex;
            assert (this.lcsCommand.isMatch(this.elems1.get(el1_index), this.elems2.get(el2_index))) : "elements should match since they are in the common suffix";
            this.matchedIndices1.add(el1_index);
            this.matchedIndices2.add(el2_index);
            --suffixIndex;
        }
    }

    private void addPrefixIndices(int commonPrefixLength) {
        int prefixIndex = 0;
        while (prefixIndex < commonPrefixLength) {
            assert (this.lcsCommand.isMatch(this.elems1.get(prefixIndex), this.elems2.get(prefixIndex))) : "elements should match since they are in the common prefix";
            this.matchedIndices1.add(prefixIndex);
            this.matchedIndices2.add(prefixIndex);
            ++prefixIndex;
        }
    }

    private int commonPrefixLength() {
        int minLength = Math.min(this.elems1.size(), this.elems2.size());
        int commonPrefixLength = 0;
        while (commonPrefixLength < minLength) {
            T el2;
            T el1 = this.elems1.get(commonPrefixLength);
            if (!this.lcsCommand.isMatch(el1, el2 = this.elems2.get(commonPrefixLength))) break;
            ++commonPrefixLength;
        }
        return commonPrefixLength;
    }

    private int commonSuffixLength(int commonPrefixLength) {
        int minLength = Math.min(this.elems1.size(), this.elems2.size());
        int commonSuffixLength = 0;
        while (commonSuffixLength < minLength - commonPrefixLength) {
            T el2;
            int el1_index = this.elems1.size() - commonSuffixLength - 1;
            int el2_index = this.elems2.size() - commonSuffixLength - 1;
            T el1 = this.elems1.get(el1_index);
            if (!this.lcsCommand.isMatch(el1, el2 = this.elems2.get(el2_index))) break;
            ++commonSuffixLength;
        }
        return commonSuffixLength;
    }

    private void lcs(List<T> elems1, List<T> elems2, int startIndex) {
        int j;
        int lengthElems1 = elems1.size();
        int lengthElems2 = elems2.size();
        int[][] opt = new int[lengthElems1 + 1][lengthElems2 + 1];
        int i = lengthElems1 - 1;
        while (i >= 0) {
            j = lengthElems2 - 1;
            while (j >= 0) {
                opt[i][j] = this.lcsCommand.isMatch(elems1.get(i), elems2.get(j)) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
                --j;
            }
            --i;
        }
        i = 0;
        j = 0;
        while (i < lengthElems1 && j < lengthElems2) {
            T el2;
            T el1 = elems1.get(i);
            if (this.lcsCommand.isMatch(el1, el2 = elems2.get(j))) {
                this.matchedIndices1.add(i + startIndex);
                this.matchedIndices2.add(j + startIndex);
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
    }

    private void checkAssertions(List<T> elems1, List<T> elems2) {
        assert (this.matchedIndices1.size() == this.matchedIndices2.size());
        assert (this.matchedIndices1.size() <= elems1.size());
        assert (this.matchedIndices2.size() <= elems2.size());
        int i = 0;
        while (i < this.matchedIndices1.size()) {
            T el1 = elems1.get(this.matchedIndices1.get(i));
            T el2 = elems2.get(this.matchedIndices2.get(i));
            assert (this.lcsCommand.isMatch(el1, el2));
            ++i;
        }
        i = 1;
        while (i < this.matchedIndices1.size()) {
            assert (this.matchedIndices1.get(i) > this.matchedIndices1.get(i - 1));
            assert (this.matchedIndices2.get(i) > this.matchedIndices2.get(i - 1));
            ++i;
        }
    }
}

