/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.editregion.detection.DiscardableRegion;
import org.spoofax.jsglr.client.editregion.detection.HelperFunctions;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;

public class RecoverInterpretation {
    private final IStrategoTerm term;
    private final IStrategoTerm parentTerm;
    private final boolean isRecovered;
    private final ArrayList<RecoverInterpretation> subtermRecoveries;
    private final int recoveryCosts;

    public IStrategoTerm getTerm() {
        return this.term;
    }

    public ArrayList<RecoverInterpretation> getSubtermRecoveries() {
        return this.subtermRecoveries;
    }

    public int getRecoveryCosts() {
        return this.recoveryCosts;
    }

    public String getGeneralSort() {
        return HelperFunctions.getGeneralSort(this.term, this.parentTerm);
    }

    public String getSort() {
        return ImploderAttachment.getSort(this.term);
    }

    public boolean hasSameSort(IStrategoTerm term, IStrategoTerm parent) {
        String generalSort = HelperFunctions.getGeneralSort(term, parent);
        String sort = ImploderAttachment.getSort(term);
        String generalTermSort = this.getGeneralSort();
        String termSort = this.getSort();
        return generalSort == generalTermSort && sort == termSort;
    }

    public boolean hasCompatibleSort(IStrategoTerm term, IStrategoTerm parent) {
        String generalSort = HelperFunctions.getGeneralSort(term, parent);
        String sort = ImploderAttachment.getSort(term);
        String generalTermSort = this.getGeneralSort();
        String termSort = this.getSort();
        boolean hasCompatibleSort = generalSort.equals(termSort) || generalSort.equals(generalTermSort.replace("*", "")) || generalSort.equals(generalTermSort) || sort.equals(termSort) || sort.equals(generalTermSort.replace("*", "")) || sort.equals(generalTermSort) || generalSort.replace("*", "").equals(termSort) || generalSort.replace("*", "").equals(generalTermSort.replace("*", "")) || generalSort.replace("*", "").equals(generalTermSort);
        return hasCompatibleSort;
    }

    public boolean isUndamagedTerm() {
        return this.getSubtermRecoveries() == null;
    }

    public ArrayList<DiscardableRegion> getDamagedRegions() {
        if (this.getSubtermRecoveries() == null) {
            return new ArrayList<DiscardableRegion>();
        }
        if (this.isRecovered) {
            return this.getDamagedRegionsForUnaffectedTerm();
        }
        return this.getDamagedRegionsForAffectedTerm();
    }

    public ArrayList<IStrategoTerm> getDamagedTerms() {
        ArrayList<IStrategoTerm> damagedTerms = new ArrayList<IStrategoTerm>();
        if (this.getSubtermRecoveries() == null) {
            return new ArrayList<IStrategoTerm>();
        }
        if (!this.isRecovered && this.hasNonLayoutTokenDiscards()) {
            damagedTerms.add(this.getTerm());
        }
        int i = 0;
        while (i < this.getSubtermRecoveries().size()) {
            damagedTerms.addAll(this.getSubtermRecoveries().get(i).getDamagedTerms());
            ++i;
        }
        return damagedTerms;
    }

    private boolean hasNonLayoutTokenDiscards() {
        int recoverCostsSubterms = 0;
        for (RecoverInterpretation subtermRecovery : this.getSubtermRecoveries()) {
            recoverCostsSubterms += subtermRecovery.getRecoveryCosts();
        }
        assert (this.recoveryCosts >= recoverCostsSubterms);
        return this.recoveryCosts > recoverCostsSubterms;
    }

    public String toString() {
        ArrayList<DiscardableRegion> damagedRegions = this.getDamagedRegions();
        String inputString = this.getInputString();
        String recoveredProgram = DiscardableRegion.replaceAllRegionsByWhitespace(damagedRegions, inputString);
        int startOffset = ImploderAttachment.getLeftToken(this.term).getStartOffset();
        int endOffset = ImploderAttachment.getRightToken(this.term).getEndOffset();
        String recoveredTermFragment = recoveredProgram.substring(startOffset, endOffset + 1);
        return recoveredTermFragment;
    }

    public static RecoverInterpretation createOriginalTermInterpretation(IStrategoTerm term, IStrategoTerm parentTerm) {
        return new RecoverInterpretation(term, parentTerm, true, null);
    }

    public static RecoverInterpretation createDiscardInterpretation(IStrategoTerm term, IStrategoTerm parentTerm) {
        assert (term.isList() || HelperFunctions.isSomeNode(term) || parentTerm == null);
        return new RecoverInterpretation(term, parentTerm, false, new ArrayList<RecoverInterpretation>());
    }

    public static RecoverInterpretation createRepairSublistsInterpretation(IStrategoTerm term, IStrategoTerm parentTerm, ArrayList<RecoverInterpretation> recoveredSublists) {
        assert (!recoveredSublists.contains(null));
        return new RecoverInterpretation(term, parentTerm, true, recoveredSublists);
    }

    public static RecoverInterpretation createRepairSubtermsInterpretation(IStrategoTerm term, IStrategoTerm parentTerm, ArrayList<RecoverInterpretation> recoveredSubterms) {
        assert (recoveredSubterms.size() == term.getSubtermCount() && !recoveredSubterms.contains(null));
        return new RecoverInterpretation(term, parentTerm, true, recoveredSubterms);
    }

    public static RecoverInterpretation createReplaceBySubtermsInterpretation(IStrategoTerm term, IStrategoTerm parentTerm, RecoverInterpretation recoveredSubterm) {
        assert (recoveredSubterm.hasCompatibleSort(term, parentTerm));
        ArrayList<RecoverInterpretation> subRecoveries = new ArrayList<RecoverInterpretation>();
        subRecoveries.add(recoveredSubterm);
        return RecoverInterpretation.createReplaceBySubtermsInterpretation(term, parentTerm, subRecoveries);
    }

    public static RecoverInterpretation createReplaceBySubtermsInterpretation(IStrategoTerm term, IStrategoTerm parentTerm, ArrayList<RecoverInterpretation> recoveredSubterms) {
        assert (parentTerm.isList() && recoveredSubterms.size() >= 1 || recoveredSubterms.size() == 1);
        return new RecoverInterpretation(term, parentTerm, false, recoveredSubterms);
    }

    private RecoverInterpretation(IStrategoTerm term, IStrategoTerm parentTerm, boolean isRecovered, ArrayList<RecoverInterpretation> recoveredSubterms) {
        this.term = term;
        this.parentTerm = parentTerm;
        this.isRecovered = isRecovered;
        this.subtermRecoveries = recoveredSubterms;
        this.recoveryCosts = this.calculateRecoveryCosts();
        this.checkAssertions();
    }

    private void checkAssertions() {
        assert (!(this.subtermRecoveries == null ? !this.isRecovered || this.recoveryCosts != 0 : this.recoveryCosts < 0));
        int subtermCosts = 0;
        if (this.subtermRecoveries != null) {
            for (RecoverInterpretation subtermRecovery : this.subtermRecoveries) {
                assert (subtermRecovery != null);
                subtermCosts += subtermRecovery.getRecoveryCosts();
            }
        }
        assert (!(this.isRecovered ? this.recoveryCosts != subtermCosts : this.recoveryCosts < subtermCosts));
    }

    private int calculateRecoveryCosts() {
        int costs = 0;
        if (this.subtermRecoveries == null) {
            return 0;
        }
        if (!this.isRecovered) {
            int nrOfNonLayoutInSubterms = 0;
            for (RecoverInterpretation subtermRecovery : this.subtermRecoveries) {
                nrOfNonLayoutInSubterms += this.numberOfNonLayoutTokens(subtermRecovery.getTerm());
            }
            costs = this.numberOfNonLayoutTokens(this.getTerm()) - nrOfNonLayoutInSubterms;
        }
        for (RecoverInterpretation subtermRecovery : this.subtermRecoveries) {
            costs += subtermRecovery.getRecoveryCosts();
        }
        return costs;
    }

    private int numberOfNonLayoutTokens(IStrategoTerm term) {
        ITokenizer tokens = (ITokenizer)ImploderAttachment.getTokenizer(term);
        int leftIndex = ImploderAttachment.getLeftToken(term).getIndex();
        int rightIndex = ImploderAttachment.getRightToken(term).getIndex();
        int nrOfNonLayoutTokens = 0;
        int i = leftIndex;
        while (i <= rightIndex) {
            if (tokens.getTokenAt(i).getKind() != IToken.Kind.TK_LAYOUT) {
                ++nrOfNonLayoutTokens;
            }
            ++i;
        }
        return nrOfNonLayoutTokens;
    }

    private ArrayList<DiscardableRegion> getDamagedRegionsForAffectedTerm() {
        String input = this.getInputString();
        ArrayList<DiscardableRegion> damagedRegions = new ArrayList<DiscardableRegion>();
        int startOffset = ImploderAttachment.getLeftToken(this.term).getStartOffset();
        int i = 0;
        while (i < this.getSubtermRecoveries().size()) {
            RecoverInterpretation subtermRecovery = this.getSubtermRecoveries().get(i);
            int endOffset = ImploderAttachment.getLeftToken(subtermRecovery.getTerm()).getStartOffset() - 1;
            if (startOffset <= endOffset) {
                DiscardableRegion region = new DiscardableRegion(startOffset, endOffset, input);
                damagedRegions.add(region);
            }
            damagedRegions.addAll(subtermRecovery.getDamagedRegions());
            startOffset = ImploderAttachment.getRightToken(subtermRecovery.getTerm()).getEndOffset() + 1;
            ++i;
        }
        int endOffset = ImploderAttachment.getRightToken(this.term).getEndOffset();
        if (startOffset <= endOffset) {
            DiscardableRegion damagedRegion = new DiscardableRegion(startOffset, endOffset, input);
            damagedRegions.add(damagedRegion);
        }
        return damagedRegions;
    }

    private ArrayList<DiscardableRegion> getDamagedRegionsForUnaffectedTerm() {
        ArrayList<DiscardableRegion> damagedRegions = new ArrayList<DiscardableRegion>();
        for (RecoverInterpretation subtermRecovery : this.getSubtermRecoveries()) {
            damagedRegions.addAll(subtermRecovery.getDamagedRegions());
        }
        return damagedRegions;
    }

    private String getInputString() {
        return ImploderAttachment.getTokenizer(this.getTerm()).getInput();
    }

    public boolean isDiscardRecovery() {
        return this.getSubtermRecoveries() != null && this.getSubtermRecoveries().isEmpty();
    }
}

