/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import java.util.Collections;
import org.spoofax.jsglr.client.editregion.detection.DamagedTokenAnalyzer;
import org.spoofax.jsglr.client.imploder.IToken;

public class TerminalEditsAnalyzer {
    private final DamagedTokenAnalyzer tokenEdits;
    private final ArrayList<Integer> startOffsetsTokensDamagedByInsertions = new ArrayList();

    public void addDamagedTokensStartOffsets(ArrayList<Integer> deletedOffsets) {
        deletedOffsets.addAll(this.startOffsetsTokensDamagedByInsertions);
        Collections.sort(deletedOffsets);
    }

    public TerminalEditsAnalyzer(DamagedTokenAnalyzer tokenEdits) {
        this.tokenEdits = tokenEdits;
        this.analyze();
    }

    private void analyze() {
        for (IToken tokenWithInsertions : this.tokenEdits.getTokensDamagedByInsertion()) {
            if (tokenWithInsertions.getKind() == IToken.Kind.TK_LAYOUT || this.tokenEdits.isDamagedByDeletion(tokenWithInsertions)) continue;
            this.startOffsetsTokensDamagedByInsertions.add(tokenWithInsertions.getStartOffset());
        }
    }
}

