/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr.client.imploder.ListImploderAttachment;
import org.spoofax.jsglr.client.imploder.NullTokenizer;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.terms.attachments.AbstractTermAttachment;
import org.spoofax.terms.attachments.OriginAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;
import org.spoofax.terms.util.TermUtils;

public class ImploderAttachment
extends AbstractTermAttachment {
    private static final long serialVersionUID = -578795745164445689L;
    public static final TermAttachmentType<ImploderAttachment> TYPE = new TermAttachmentType<ImploderAttachment>(ImploderAttachment.class, "ImploderAttachment", 6){

        @Override
        protected IStrategoTerm[] toSubterms(ITermFactory f, ImploderAttachment attachment) {
            IToken left = attachment.getLeftToken();
            IToken right = attachment.getRightToken();
            String sortType = attachment.getSort() == null ? "" : attachment.getSort();
            String fileName = left.getFilename() == null ? "" : left.getFilename();
            return new IStrategoTerm[]{f.makeString(fileName), f.makeInt(left.getLine()), f.makeInt(left.getColumn()), f.makeInt(left.getStartOffset()), f.makeInt(right.getEndOffset()), f.makeString(sortType)};
        }

        @Override
        protected ImploderAttachment fromSubterms(IStrategoTerm[] subterms) {
            String fileName = TermUtils.toJavaString(subterms[0]).equals("") ? null : TermUtils.toJavaString(subterms[0]);
            String sortType = TermUtils.toJavaString(subterms[0]).equals("") ? null : TermUtils.toJavaString(subterms[5]);
            return ImploderAttachment.createCompactPositionAttachment(fileName, TermUtils.toJavaInt(subterms[1]), TermUtils.toJavaInt(subterms[2]), TermUtils.toJavaInt(subterms[3]), TermUtils.toJavaInt(subterms[4]), sortType);
        }
    };
    private final IToken leftToken;
    private final IToken rightToken;
    private final boolean isCompletion;
    private final boolean isNestedCompletion;
    private final boolean isSinglePlaceholderCompletion;
    private boolean isBracket;
    private final String sort;
    private LinkedList<String> injections;

    protected ImploderAttachment(String sort, IToken leftToken, IToken rightToken, boolean isBracket, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion) {
        assert (leftToken != null && rightToken != null);
        this.sort = sort;
        this.leftToken = leftToken;
        this.rightToken = rightToken;
        this.isCompletion = isCompletion;
        this.isNestedCompletion = isNestedCompletion;
        this.isSinglePlaceholderCompletion = isSinglePlaceholderCompletion;
        this.isBracket = isBracket;
    }

    public TermAttachmentType<ImploderAttachment> getAttachmentType() {
        return TYPE;
    }

    public static ImploderAttachment get(ISimpleTerm term) {
        return term.getAttachment(TYPE);
    }

    public IToken getLeftToken() {
        return this.leftToken;
    }

    public IToken getRightToken() {
        return this.rightToken;
    }

    public String getSort() {
        return this.sort;
    }

    public boolean isSequenceAttachment() {
        return false;
    }

    public String getElementSort() {
        return this.getSort();
    }

    public static IToken getLeftToken(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        if (attachment == null) {
            assert (!ImploderAttachment.hasImploderOrigin(term)) : "Likely error: called getLeftToken() on term with imploder origin, instead of the origin itself";
            return null;
        }
        return attachment.getLeftToken();
    }

    public static IToken getRightToken(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        if (attachment == null) {
            assert (!ImploderAttachment.hasImploderOrigin(term)) : "Likely error: called getRightToken() on term with imploder origin, instead of the origin itself";
            return null;
        }
        return attachment.getRightToken();
    }

    public static String getSort(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? null : attachment.getSort();
    }

    public static String getElementSort(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? null : attachment.getElementSort();
    }

    public static String getFilename(ISimpleTerm term) {
        IToken token = ImploderAttachment.getLeftToken(term);
        return token == null ? null : token.getFilename();
    }

    public static ITokens getTokenizer(ISimpleTerm term) {
        IToken token = ImploderAttachment.getLeftToken(term);
        assert (token == null || token.getTokenizer() == ImploderAttachment.getRightToken(term).getTokenizer()) : "Tokenizer of left and right token inconsistent";
        return token == null ? null : token.getTokenizer();
    }

    public static boolean hasImploderOrigin(ISimpleTerm term) {
        IStrategoTerm origin = OriginAttachment.getOrigin(term);
        if (origin != null) {
            term = origin;
        }
        return term.getAttachment(TYPE) != null;
    }

    public static IStrategoTerm getImploderOrigin(IStrategoTerm term) {
        IStrategoTerm origin = OriginAttachment.getOrigin(term);
        if (origin != null) {
            term = origin;
        }
        return term.getAttachment(TYPE) != null ? term : null;
    }

    public static ImploderAttachment createCompactPositionAttachment(String filename, int line, int column, int startOffset, int endOffset) {
        return ImploderAttachment.createCompactPositionAttachment(filename, line, column, startOffset, endOffset, null);
    }

    public static ImploderAttachment createCompactPositionAttachment(String filename, int line, int column, int startOffset, int endOffset, String sortType) {
        Token token = new Token(null, filename, 0, line, column, startOffset, endOffset, IToken.Kind.TK_UNKNOWN);
        NullTokenizer newTokenizer = new NullTokenizer(sortType, filename, token);
        token.setTokenizer(newTokenizer);
        return new ImploderAttachment(null, token, token, false, false, false, false);
    }

    public static void putImploderAttachment(ISimpleTerm term, boolean isAnonymousSequence, String sort, IToken leftToken, IToken rightToken, boolean isBracket, boolean isCompletion, boolean isNestedCompletion, boolean isSinglePlaceholderCompletion) {
        term.putAttachment(isAnonymousSequence ? new ListImploderAttachment(sort, leftToken, rightToken) : new ImploderAttachment(sort, leftToken, rightToken, isBracket, isCompletion, isNestedCompletion, isSinglePlaceholderCompletion));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBracket ? 1231 : 1237);
        result = 31 * result + (this.isCompletion ? 1231 : 1237);
        result = 31 * result + (this.isNestedCompletion ? 1231 : 1237);
        result = 31 * result + (this.isSinglePlaceholderCompletion ? 1231 : 1237);
        result = 31 * result + this.leftToken.hashCode();
        result = 31 * result + this.rightToken.hashCode();
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImploderAttachment other = (ImploderAttachment)obj;
        if (this.isBracket != other.isBracket) {
            return false;
        }
        if (this.isCompletion != other.isCompletion) {
            return false;
        }
        if (this.isNestedCompletion != other.isNestedCompletion) {
            return false;
        }
        if (this.isSinglePlaceholderCompletion != other.isSinglePlaceholderCompletion) {
            return false;
        }
        if (!this.leftToken.equals(other.leftToken)) {
            return false;
        }
        if (!this.rightToken.equals(other.rightToken)) {
            return false;
        }
        if (this.sort == null) {
            return other.sort == null;
        }
        return this.sort.equals(other.sort);
    }

    public String toString() {
        if (this.getLeftToken() != null) {
            return "(" + this.getSort() + ",\"" + this.getLeftToken().getTokenizer().toString(this.getLeftToken(), this.getRightToken()) + "\")";
        }
        return "(" + this.getSort() + ",null)";
    }

    public boolean isCompletion() {
        return this.isCompletion;
    }

    public boolean isNestedCompletion() {
        return this.isNestedCompletion;
    }

    public boolean isSinglePlaceholderCompletion() {
        return this.isSinglePlaceholderCompletion;
    }

    public boolean isBracket() {
        return this.isBracket;
    }

    public void setBracket(boolean isBracket) {
        this.isBracket = isBracket;
    }

    public void pushInjection(String sort) {
        if (this.injections == null) {
            this.injections = new LinkedList();
        }
        this.injections.push(sort);
    }

    public List<String> getInjections() {
        return this.injections == null ? Collections.emptyList() : Collections.unmodifiableList(this.injections);
    }

    public void clearInjections() {
        this.injections = null;
    }
}

