/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.IKeywordRecognizer;
import org.spoofax.jsglr.client.KeywordRecognizer;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.terms.SimpleTermVisitor;

public class Tokenizer
extends AbstractTokenizer {
    private static final long serialVersionUID = -7507424974905643146L;
    private static final double EXPECTED_TOKENS_DIVIDER = 1.3;
    private final ArrayList<Token> tokens;
    private IKeywordRecognizer keywords;
    private ISimpleTerm ast;
    private int startOffset;
    private int line;
    private int offsetAtLineStart;

    public Tokenizer(String input, String filename, IKeywordRecognizer keywords) {
        this(input, filename, keywords, true);
    }

    public Tokenizer(String input, String filename, IKeywordRecognizer keywords, boolean startWithReserved) {
        super(input, filename);
        this.keywords = keywords;
        this.tokens = new ArrayList();
        this.startOffset = 0;
        this.line = 1;
        this.offsetAtLineStart = 0;
        if (startWithReserved) {
            this.tokens.add(new Token(this, filename, 0, this.line, 0, 0, -1, IToken.Kind.TK_RESERVED));
        }
    }

    @Override
    public final int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public void setStartOffset(int startOffset) {
        assert (this.isAmbiguous() || this.startOffset >= this.getInput().length());
        if (this.startOffset == startOffset) {
            return;
        }
        this.startOffset = startOffset;
        IToken lastToken = this.getTokenAtOffset(startOffset);
        this.offsetAtLineStart = lastToken.getStartOffset() - lastToken.getColumn();
        this.line = lastToken.getLine();
    }

    @Override
    public IToken currentToken() {
        return this.tokens.size() == 0 ? null : (IToken)this.tokens.get(this.tokens.size() - 1);
    }

    @Override
    public int getTokenCount() {
        return this.tokens.size();
    }

    @Override
    public Token getTokenAt(int i) {
        Token result = this.tokens.get(i);
        return result;
    }

    public Token internalGetTokenAt(int i) {
        Token result = this.tokens.get(i);
        return result;
    }

    protected void removeTokenAt(int i) {
        this.tokens.remove(i);
    }

    public void setPositions(int line, int startOffset, int offsetAtLineStart) {
        this.line = line;
        this.offsetAtLineStart = offsetAtLineStart;
        this.startOffset = startOffset;
    }

    protected void setKeywordRecognizer(IKeywordRecognizer keywords) {
        this.keywords = keywords;
    }

    @Override
    public IToken getTokenAtOffset(int offset) {
        assert (this.isAmbiguous() || this.getTokenCount() < 2 || this.internalGetTokenAt(this.getTokenCount() - 1).getStartOffset() == this.internalGetTokenAt(this.getTokenCount() - 2).getEndOffset() + 1) : "Unordered tokens at end of tokenizer";
        Token key = new Token(this, this.getFilename(), -1, -1, -1, offset, offset - 1, IToken.Kind.TK_RESERVED);
        int resultIndex = Collections.binarySearch(this.tokens, key);
        if (resultIndex == -1) {
            throw new IndexOutOfBoundsException("No token at offset " + offset + " (binary search returned " + resultIndex + ")");
        }
        if (resultIndex < -1) {
            resultIndex = -resultIndex - 1;
        }
        if (offset == this.getInput().length() && this.tokens.size() > 0) {
            return this.currentToken();
        }
        if (resultIndex >= this.getTokenCount()) {
            throw new IndexOutOfBoundsException("No token at offset " + offset);
        }
        return this.internalGetTokenAt(resultIndex);
    }

    @Override
    public final Token makeToken(int endOffset, IToken.Kind kind, boolean allowEmptyToken) {
        return this.makeToken(endOffset, kind, allowEmptyToken, null);
    }

    public Token makeToken(int endOffset, IToken.Kind kind, boolean allowEmptyToken, String errorMessage) {
        String input = this.getInput();
        assert (endOffset <= input.length());
        if (!allowEmptyToken && this.startOffset > endOffset) {
            return null;
        }
        assert (endOffset + 1 >= this.startOffset || kind == IToken.Kind.TK_RESERVED && this.startOffset == 0) : "Creating token ending before current start offset";
        Token token = null;
        int offset = Math.min(this.startOffset, endOffset);
        while (offset < endOffset) {
            if (input.charAt(offset) == '\n') {
                if (offset - 1 > this.startOffset) {
                    token = this.internalMakeToken(kind, offset - 1, errorMessage);
                }
                this.internalMakeToken(IToken.Kind.TK_LAYOUT, offset, errorMessage);
                ++this.line;
                this.offsetAtLineStart = this.startOffset;
            }
            ++offset;
        }
        if (token == null || offset <= endOffset) {
            int oldStartOffset = this.startOffset;
            token = this.internalMakeToken(kind, offset, errorMessage);
            if (offset >= oldStartOffset && input.charAt(offset) == '\n') {
                ++this.line;
                this.offsetAtLineStart = this.startOffset;
            }
            return token;
        }
        return token;
    }

    protected Token internalMakeToken(IToken.Kind kind, int endOffset, String errorMessage) {
        if (endOffset >= this.getInput().length()) {
            assert (false);
            endOffset = this.getInput().length() - 1;
        }
        Token result = new Token(this, this.getFilename(), this.tokens.size(), this.line, this.startOffset - this.offsetAtLineStart, this.startOffset, endOffset, kind);
        if (errorMessage != null) {
            result.setError(errorMessage);
        }
        if (this.tokens.size() == 5) {
            this.tokens.ensureCapacity((int)((double)this.getInput().length() / 1.3));
        }
        this.tokens.add(result);
        this.startOffset = endOffset + 1;
        return result;
    }

    public void reassignToken(Token token) {
        assert (token.getTokenizer() != this);
        assert (token.getEndOffset() <= this.getInput().length());
        token.setTokenizer(this);
        token.setIndex(this.tokens.size());
        this.tokens.add(token);
        this.startOffset = token.getEndOffset() + 1;
    }

    @Override
    protected void setErrorMessage(IToken leftToken, IToken rightToken, String message) {
        assert (leftToken.getTokenizer() == this && rightToken.getTokenizer() == this);
        int i = leftToken.getIndex();
        int max2 = rightToken.getIndex();
        while (i <= max2) {
            this.tokens.get(i).setError(message);
            ++i;
        }
    }

    @Override
    public void tryMakeSkippedRegionToken(int offset) {
        char inputChar = this.getInput().charAt(offset);
        boolean isInputKeywordChar = KeywordRecognizer.isPotentialKeywordChar(inputChar);
        if (this.isAtPotentialKeywordEnd(offset, isInputKeywordChar)) {
            if (this.keywords.isKeyword(this.toString(this.startOffset, offset - 1))) {
                this.makeToken(offset - 1, IToken.Kind.TK_ERROR_KEYWORD, false, "Syntax error, unexpected construct(s)");
            } else {
                this.makeToken(offset - 1, IToken.Kind.TK_ERROR, false, "Syntax error, unexpected construct(s)");
            }
        }
        if (this.isAtPotentialKeywordStart(offset, isInputKeywordChar)) {
            if (this.keywords.isKeyword(this.toString(this.startOffset, offset))) {
                this.makeToken(offset, IToken.Kind.TK_ERROR_KEYWORD, false, "Syntax error, unexpected construct(s)");
            } else {
                this.makeToken(offset, IToken.Kind.TK_ERROR, false, "Syntax error, unexpected construct(s)");
            }
        }
        this.setSyntaxCorrect(false);
    }

    private boolean isAtPotentialKeywordEnd(int offset, boolean isInputKeywordChar) {
        if (offset >= 1 && offset > this.startOffset) {
            char prevChar = this.getInput().charAt(offset - 1);
            return isInputKeywordChar && !this.isKeywordChar(prevChar) || !isInputKeywordChar && this.isKeywordChar(prevChar);
        }
        return false;
    }

    private boolean isAtPotentialKeywordStart(int offset, boolean isInputKeywordChar) {
        if (isInputKeywordChar && offset + 1 == this.getInput().length()) {
            return true;
        }
        if (offset + 1 < this.getInput().length()) {
            char nextChar = this.getInput().charAt(offset + 1);
            if (isInputKeywordChar && !this.isKeywordChar(nextChar) || !isInputKeywordChar && this.isKeywordChar(nextChar)) {
                return true;
            }
        }
        return false;
    }

    private boolean isKeywordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public String toString() {
        String input = this.getInput();
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (IToken iToken : this.tokens) {
            int offset = iToken.getStartOffset();
            result.append(input, offset, iToken.getEndOffset() + 1);
            result.append(',');
        }
        if (this.tokens.size() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        result.append(']');
        return result.toString();
    }

    protected IKeywordRecognizer getKeywordRecognizer() {
        return this.keywords;
    }

    @Override
    public Iterator<IToken> iterator() {
        return new FilteredTokenIterator(this.allTokens());
    }

    @Override
    public Iterable<IToken> allTokens() {
        List<IToken> result = Collections.unmodifiableList(this.tokens);
        return result;
    }

    @Override
    public void setAst(ISimpleTerm ast) {
        this.ast = ast;
    }

    @Override
    public void initAstNodeBinding() {
        if (this.ast == null) {
            return;
        }
        int tokenIndex = ImploderAttachment.getLeftToken(this.ast).getIndex();
        int endTokenIndex = ImploderAttachment.getRightToken(this.ast).getIndex();
        this.bindAstNode(this.ast, tokenIndex, endTokenIndex);
    }

    private void bindAstNode(ISimpleTerm node, int tokenIndex, int endTokenIndex) {
        assert (ImploderAttachment.getTokenizer(node) == this);
        int tokenCount = this.getTokenCount();
        Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(node);
        int i = 0;
        int max2 = node.getSubtermCount();
        while (i < max2) {
            ISimpleTerm child = iterator == null ? node.getSubterm(i) : iterator.next();
            int childStart = ImploderAttachment.getLeftToken(child).getIndex();
            int childEnd = ImploderAttachment.getRightToken(child).getIndex();
            while (tokenIndex < childStart && tokenIndex < tokenCount) {
                Token token = this.getTokenAt(tokenIndex++);
                token.setAstNode(node);
            }
            this.bindAstNode(child, childStart, childEnd);
            tokenIndex = childEnd + 1;
            ++i;
        }
        while (tokenIndex <= endTokenIndex && tokenIndex < tokenCount) {
            Token token = this.getTokenAt(tokenIndex++);
            token.setAstNode(node);
        }
    }

    public static class FilteredTokenIterator
    implements Iterator<IToken> {
        final Iterator<IToken> allTokensIterator;
        IToken next = null;
        int offset = -1;

        public FilteredTokenIterator(Iterable<IToken> allTokens) {
            this.allTokensIterator = allTokens.iterator();
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IToken next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IToken res = this.next;
            this.calculateNext();
            return res;
        }

        private void calculateNext() {
            while (this.allTokensIterator.hasNext()) {
                this.next = this.allTokensIterator.next();
                if (this.next.getKind() != IToken.Kind.TK_RESERVED && this.next.getKind() != IToken.Kind.TK_EOF && this.next.getStartOffset() == this.next.getEndOffset() + 1 || this.next.getStartOffset() <= this.offset) continue;
                this.offset = this.next.getEndOffset();
                return;
            }
            this.next = null;
        }
    }
}

