/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr2.JSGLR2;
import org.spoofax.jsglr2.JSGLR2Failure;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.JSGLR2Result;
import org.spoofax.jsglr2.JSGLR2Success;
import org.spoofax.jsglr2.imploder.IImplodeResult;
import org.spoofax.jsglr2.imploder.IImploder;
import org.spoofax.jsglr2.imploder.ITokenizer;
import org.spoofax.jsglr2.messages.Message;
import org.spoofax.jsglr2.messages.SourceRegion;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parser.IObservableParser;
import org.spoofax.jsglr2.parser.observing.IParserObserver;
import org.spoofax.jsglr2.parser.result.ParseFailure;
import org.spoofax.jsglr2.parser.result.ParseResult;
import org.spoofax.jsglr2.parser.result.ParseSuccess;

public class JSGLR2Implementation<ParseForest extends IParseForest, IntermediateResult, ImploderCache, AbstractSyntaxTree, ImplodeResult extends IImplodeResult<IntermediateResult, ImploderCache, AbstractSyntaxTree>, TokensResult extends ITokens>
implements JSGLR2<AbstractSyntaxTree> {
    public final IObservableParser<ParseForest, ?, ?, ?, ?> parser;
    public final IImploder<ParseForest, IntermediateResult, ImploderCache, AbstractSyntaxTree, ImplodeResult> imploder;
    public final ITokenizer<IntermediateResult, TokensResult> tokenizer;
    public final HashMap<JSGLR2Request.CachingKey, String> inputCache = new HashMap();
    public final HashMap<JSGLR2Request.CachingKey, ParseForest> parseForestCache = new HashMap();
    public final HashMap<JSGLR2Request.CachingKey, ImploderCache> imploderCacheCache = new HashMap();
    public final HashMap<JSGLR2Request.CachingKey, TokensResult> tokensCache = new HashMap();

    JSGLR2Implementation(IObservableParser<ParseForest, ?, ?, ?, ?> parser, IImploder<ParseForest, IntermediateResult, ImploderCache, AbstractSyntaxTree, ImplodeResult> imploder, ITokenizer<IntermediateResult, TokensResult> tokenizer) {
        this.parser = parser;
        this.imploder = imploder;
        this.tokenizer = tokenizer;
    }

    @Override
    public void attachObserver(IParserObserver observer) {
        this.parser.observing().attachObserver(observer);
    }

    @Override
    public JSGLR2Result<AbstractSyntaxTree> parseResult(JSGLR2Request request) {
        String previousInput = request.isCacheable() ? this.inputCache.get(request.cachingKey()) : null;
        IParseForest previousParseForest = request.isCacheable() ? (IParseForest)this.parseForestCache.get(request.cachingKey()) : null;
        Object previousImploderCache = request.isCacheable() ? (Object)this.imploderCacheCache.get(request.cachingKey()) : null;
        ITokens previousTokens = request.isCacheable() ? (ITokens)this.tokensCache.get(request.cachingKey()) : null;
        ParseResult<IParseForest> parseResult = this.parser.parse(request, previousInput, previousParseForest);
        if (parseResult.isSuccess()) {
            Object parseForest = ((ParseSuccess)parseResult).parseResult;
            ImplodeResult implodeResult = this.imploder.implode(request, parseForest, previousImploderCache);
            Object tokens = this.tokenizer.tokenize((JSGLR2Request)request, implodeResult.intermediateResult(), previousTokens).tokens;
            List<Message> messages = this.postProcessMessages(parseResult.messages, (ITokens)tokens);
            if (request.isCacheable()) {
                this.inputCache.put(request.cachingKey(), request.input);
                this.parseForestCache.put(request.cachingKey(), parseForest);
                this.imploderCacheCache.put(request.cachingKey(), implodeResult.resultCache());
                this.tokensCache.put(request.cachingKey(), tokens);
            }
            return new JSGLR2Success(request, implodeResult.ast(), (ITokens)tokens, implodeResult.isAmbiguous(), (Collection<Message>)messages);
        }
        ParseFailure failure = (ParseFailure)parseResult;
        return new JSGLR2Failure(request, failure, parseResult.messages);
    }

    private List<Message> postProcessMessages(Collection<Message> originalMessages, ITokens tokens) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Iterator<Message> iterator = originalMessages.iterator();
        while (iterator.hasNext()) {
            IToken precedingToken;
            Message originalMessage;
            Message message = originalMessage = iterator.next();
            IToken token = tokens.getTokenAtOffset(originalMessage.region.startOffset);
            IToken iToken = precedingToken = token != null ? token.getTokenBefore() : null;
            if (precedingToken != null && precedingToken.getKind() == IToken.Kind.TK_LAYOUT) {
                message = message.atRegion(SourceRegion.fromToken(precedingToken));
            }
            messages.add(message);
        }
        return messages;
    }
}

