/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2;

import java.util.Objects;
import java.util.Optional;

public class JSGLR2Request {
    public final String input;
    public final String fileName;
    public final String startSymbol;
    public final int recoveryIterationsQuota;
    public final int succeedingRecoveryOffset;
    public final Optional<Integer> completionCursorOffset;
    public static final int DEFAULT_RECOVERY_ITERATIONS_QUOTA = 5;
    public static final int DEFAULT_SUCCEEDING_RECOVERY_OFFSET = 10;

    public JSGLR2Request(String input) {
        this(input, "");
    }

    public JSGLR2Request(String input, String fileName) {
        this(input, fileName, null);
    }

    public JSGLR2Request(String input, String fileName, String startSymbol) {
        this(input, fileName, startSymbol, 5, 10, Optional.empty());
    }

    public JSGLR2Request(String input, String fileName, String startSymbol, int recoveryIterationsQuota, int succeedingRecoveryOffset, Optional<Integer> completionCursorOffset) {
        this.input = input;
        this.fileName = fileName;
        this.startSymbol = startSymbol;
        this.recoveryIterationsQuota = recoveryIterationsQuota;
        this.succeedingRecoveryOffset = succeedingRecoveryOffset;
        this.completionCursorOffset = completionCursorOffset;
    }

    public boolean isCacheable() {
        return !"".equals(this.fileName);
    }

    public int succeedingRecoveryOffset() {
        return this.succeedingRecoveryOffset;
    }

    public boolean isCompletion() {
        return this.completionCursorOffset.isPresent();
    }

    public CachingKey cachingKey() {
        if (!this.isCacheable()) {
            throw new IllegalStateException("This JSGLR2Request is not cacheable");
        }
        return new CachingKey(this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSGLR2Request that = (JSGLR2Request)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.startSymbol, that.startSymbol) && this.recoveryIterationsQuota == that.recoveryIterationsQuota && this.succeedingRecoveryOffset == that.succeedingRecoveryOffset && this.completionCursorOffset.equals(that.completionCursorOffset);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset, this.completionCursorOffset);
    }

    public static class CachingKey {
        final String fileName;
        final String startSymbol;
        final int recoveryIterationsQuota;
        final int succeedingRecoveryOffset;

        CachingKey(String fileName, String startSymbol, int recoveryIterationsQuota, int succeedingRecoveryOffset) {
            this.fileName = fileName;
            this.startSymbol = startSymbol;
            this.recoveryIterationsQuota = recoveryIterationsQuota;
            this.succeedingRecoveryOffset = succeedingRecoveryOffset;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachingKey that = (CachingKey)o;
            return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.startSymbol, that.startSymbol) && this.recoveryIterationsQuota == that.recoveryIterationsQuota && this.succeedingRecoveryOffset == that.succeedingRecoveryOffset;
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.startSymbol, this.recoveryIterationsQuota, this.succeedingRecoveryOffset);
        }
    }
}

