/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.metaborg.parsetable.symbols.IMetaVarSymbol;
import org.spoofax.jsglr2.imploder.IImplodeResult;
import org.spoofax.jsglr2.imploder.IImploder;
import org.spoofax.jsglr2.layoutsensitive.ILayoutSensitiveParseNode;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;

public abstract class AbstractTreeImploder<ParseForest extends IParseForest, ParseNode extends IParseNode<ParseForest, Derivation>, Derivation extends IDerivation<ParseForest>, IntermediateResult, Cache, AbstractSyntaxTree, Result extends IImplodeResult<IntermediateResult, Cache, AbstractSyntaxTree>>
implements IImploder<ParseForest, IntermediateResult, Cache, AbstractSyntaxTree, Result> {
    protected List<List<ParseForest>> implodeAmbiguousLists(List<Derivation> derivations) {
        ArrayList<List<ParseForest>> alternatives = new ArrayList<List<ParseForest>>();
        for (IDerivation derivation : derivations) {
            IParseForest[] children = derivation.parseForests();
            if (children.length == 0) {
                alternatives.add(Collections.emptyList());
                continue;
            }
            if (children.length == 1) {
                alternatives.add(Collections.singletonList(children[0]));
                continue;
            }
            List<IParseForest> subTrees = Arrays.asList(children);
            IParseNode head = (IParseNode)children[0];
            if (head.production().isList() && head.getPreferredAvoidedDerivations().size() > 1) {
                List<IParseForest> tail = subTrees.subList(1, subTrees.size());
                List<List<ParseForest>> headExpansions = this.implodeAmbiguousLists(head.getPreferredAvoidedDerivations());
                for (List<ParseForest> headExpansion : headExpansions) {
                    ArrayList<ParseForest> headExpansionWithTail = new ArrayList<ParseForest>(headExpansion);
                    headExpansionWithTail.addAll(tail);
                    alternatives.add(headExpansionWithTail);
                }
                continue;
            }
            alternatives.add(subTrees);
        }
        return alternatives;
    }

    protected ParseNode implodeInjection(ParseNode parseNode) {
        for (IDerivation derivation : parseNode.getDerivations()) {
            IParseNode injectedParseNode;
            if (derivation.parseForests().length != 1 || !(derivation.parseForests()[0] instanceof IParseNode) || !((injectedParseNode = (IParseNode)derivation.parseForests()[0]).production().lhs() instanceof IMetaVarSymbol)) continue;
            return (ParseNode)injectedParseNode;
        }
        return parseNode;
    }

    protected List<Derivation> applyDisambiguationFilters(ParseNode parseNode) {
        if (!parseNode.isAmbiguous()) {
            return Collections.singletonList(parseNode.getFirstDerivation());
        }
        if (parseNode instanceof ILayoutSensitiveParseNode) {
            ((ILayoutSensitiveParseNode)parseNode).filterLongestMatchDerivations();
        }
        List result = parseNode.getPreferredAvoidedDerivations();
        return result;
    }
}

