/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.util.iterators.Iterables2;
import org.spoofax.jsglr2.imploder.TreeImploder;
import org.spoofax.jsglr2.imploder.input.IImplodeInputFactory;
import org.spoofax.jsglr2.imploder.input.ImplodeInput;
import org.spoofax.jsglr2.imploder.treefactory.ITreeFactory;
import org.spoofax.jsglr2.parseforest.ICharacterNode;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;

public class IterativeTreeImploder<ParseForest extends IParseForest, ParseNode extends IParseNode<ParseForest, Derivation>, Derivation extends IDerivation<ParseForest>, Cache, Tree, Input extends ImplodeInput>
extends TreeImploder<ParseForest, ParseNode, Derivation, Cache, Tree, Input> {
    public IterativeTreeImploder(IImplodeInputFactory<Input> inputFactory, ITreeFactory<Tree> treeFactory) {
        super(inputFactory, treeFactory);
    }

    @Override
    protected TreeImploder.SubTree<Tree> implodeParseNode(Input input, ParseForest rootForest, int startOffset) {
        IParseNode rootNode = (IParseNode)rootForest;
        Stack<PseudoNode> parseNodeStack = new Stack<PseudoNode>();
        Stack<LinkedList<LinkedList<IParseForest>>> inputStack = new Stack<LinkedList<LinkedList<IParseForest>>>();
        Stack<LinkedList<LinkedList<TreeImploder.SubTree>>> outputStack = new Stack<LinkedList<LinkedList<TreeImploder.SubTree>>>();
        parseNodeStack.add(new PseudoNode(this, rootNode, this.applyDisambiguationFilters(rootNode), startOffset));
        inputStack.add(IterativeTreeImploder.newNestedList(rootForest));
        outputStack.add(IterativeTreeImploder.newNestedList(new TreeImploder.SubTree[0]));
        while (true) {
            PseudoNode pseudoNode = (PseudoNode)parseNodeStack.peek();
            LinkedList currentIn = (LinkedList)inputStack.peek();
            LinkedList currentOut = (LinkedList)outputStack.peek();
            if (((LinkedList)currentIn.getFirst()).isEmpty()) {
                currentIn.removeFirst();
                if (currentIn.isEmpty()) {
                    inputStack.pop();
                    if (inputStack.isEmpty()) break;
                    parseNodeStack.pop();
                    outputStack.pop();
                    TreeImploder.SubTree<Tree> possiblyAmbiguousSubTree = pseudoNode.isListNode ? this.createPossiblyAmbiguousSubTree(pseudoNode.parseNode, currentOut.stream().map(subTrees -> this.createNonTerminalSubTree(pseudoNode.production, (List<TreeImploder.SubTree<Tree>>)subTrees)).collect(Collectors.toList())) : this.createPossiblyAmbiguousSubTree(pseudoNode.parseNode, Lists.newArrayList(Iterables2.zip(pseudoNode.derivations, currentOut, (derivation, subTrees) -> this.createNonTerminalSubTree(derivation.production(), (List<TreeImploder.SubTree<Tree>>)subTrees))));
                    ((LinkedList)((LinkedList)outputStack.peek()).getLast()).add(possiblyAmbiguousSubTree);
                    ((PseudoNode)parseNodeStack.peek()).pivotOffset += possiblyAmbiguousSubTree.width;
                    continue;
                }
                currentOut.add(new LinkedList());
                pseudoNode.pivotOffset = pseudoNode.beginOffset;
                continue;
            }
            IParseForest parseForest = (IParseForest)((LinkedList)currentIn.getFirst()).removeFirst();
            if (parseForest instanceof ICharacterNode) {
                TreeImploder.SubTree characterSubTree = new TreeImploder.SubTree(this.treeFactory.createCharacterTerminal(((ICharacterNode)parseForest).character()), null, parseForest.width(), true);
                ((LinkedList)currentOut.getLast()).add(characterSubTree);
                pseudoNode.pivotOffset += characterSubTree.width;
                continue;
            }
            IParseNode parseNode = this.implodeInjection((IParseNode)parseForest);
            IProduction production = parseNode.production();
            if (!production.isContextFree() || production.isSkippableInParseForest()) {
                TreeImploder.SubTree<Tree> lexicalSubTree = this.createLexicalSubTree(((ImplodeInput)input).inputString, parseNode, pseudoNode.pivotOffset, production);
                ((LinkedList)currentOut.getLast()).add(lexicalSubTree);
                pseudoNode.pivotOffset += lexicalSubTree.width;
                continue;
            }
            List derivations = this.applyDisambiguationFilters(parseNode);
            if (derivations.size() > 1 && production.isList()) {
                inputStack.add(this.getDerivationListsForListNode(production, derivations));
                parseNodeStack.add(new PseudoNode(this, parseNode, production, pseudoNode.pivotOffset));
            } else {
                inputStack.add(this.getDerivationLists(derivations));
                parseNodeStack.add(new PseudoNode(this, parseNode, derivations, pseudoNode.pivotOffset));
            }
            outputStack.add(IterativeTreeImploder.newNestedList(new TreeImploder.SubTree[0]));
        }
        return (TreeImploder.SubTree)((LinkedList)((LinkedList)outputStack.peek()).getFirst()).getFirst();
    }

    private LinkedList<LinkedList<ParseForest>> getDerivationLists(List<Derivation> derivations) {
        LinkedList<LinkedList<ParseForest>> derivationLists = new LinkedList<LinkedList<ParseForest>>();
        for (IDerivation derivation : derivations) {
            if (!derivation.production().isContextFree()) {
                throw new RuntimeException("non context free imploding of Derivations not supported");
            }
            derivationLists.add(new LinkedList(this.getChildParseForests(derivation)));
        }
        return derivationLists;
    }

    private LinkedList<LinkedList<ParseForest>> getDerivationListsForListNode(IProduction production, List<Derivation> derivations) {
        LinkedList<LinkedList<ParseForest>> derivationLists = new LinkedList<LinkedList<ParseForest>>();
        for (List derivationParseForests : this.implodeAmbiguousLists(derivations)) {
            derivationLists.add(new LinkedList(this.getChildParseForests(production, derivationParseForests)));
        }
        return derivationLists;
    }

    private TreeImploder.SubTree<Tree> createPossiblyAmbiguousSubTree(ParseNode parseNode, List<TreeImploder.SubTree<Tree>> subTrees) {
        if (subTrees.size() > 1) {
            return this.createAmbiguousSubTree(parseNode, subTrees);
        }
        return subTrees.get(0);
    }

    private TreeImploder.SubTree<Tree> createAmbiguousSubTree(ParseNode parseNode, List<TreeImploder.SubTree<Tree>> subTrees) {
        return new TreeImploder.SubTree(this.treeFactory.createAmb(subTrees.stream().map(t -> t.tree)::iterator), subTrees, null, subTrees.get((int)0).width, false, true, false);
    }

    private TreeImploder.SubTree<Tree> createNonTerminalSubTree(IProduction production, List<TreeImploder.SubTree<Tree>> subTrees) {
        List childASTs = subTrees.stream().filter(t -> t.tree != null).map(t -> t.tree).collect(Collectors.toList());
        Object contextFreeTerm = this.createContextFreeTerm(production, childASTs);
        return new TreeImploder.SubTree(contextFreeTerm, subTrees, production, childASTs.size() == 1 && contextFreeTerm == childASTs.get(0));
    }

    private TreeImploder.SubTree<Tree> createLexicalSubTree(String inputString, ParseNode parseNode, int startOffset, IProduction production) {
        int width = parseNode.width();
        return new TreeImploder.SubTree(this.createLexicalTerm(production, inputString, startOffset, width), production, width, false);
    }

    @SafeVarargs
    private static <E> LinkedList<LinkedList<E>> newNestedList(E ... elements) {
        return new LinkedList<LinkedList<E>>(Collections.singletonList(new LinkedList<E>(Arrays.asList(elements))));
    }

    private class PseudoNode {
        final ParseNode parseNode;
        final List<Derivation> derivations;
        final IProduction production;
        final boolean isListNode;
        final int beginOffset;
        int pivotOffset;
        final /* synthetic */ IterativeTreeImploder this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        PseudoNode(ParseNode parseNode, List<Derivation> derivations, int beginOffset) {
            this.this$0 = (IterativeTreeImploder)n;
            this.parseNode = parseNode;
            this.derivations = derivations;
            this.production = null;
            this.beginOffset = beginOffset;
            this.pivotOffset = beginOffset;
            this.isListNode = false;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        PseudoNode(ParseNode parseNode, IProduction production, int beginOffset) {
            this.this$0 = (IterativeTreeImploder)n;
            this.parseNode = parseNode;
            this.derivations = null;
            this.production = production;
            this.beginOffset = beginOffset;
            this.pivotOffset = beginOffset;
            this.isListNode = true;
        }
    }
}

