/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder;

import org.metaborg.parsetable.symbols.ISymbol;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.imploder.ITokenizer;
import org.spoofax.jsglr2.imploder.TokenizeResult;
import org.spoofax.jsglr2.imploder.TreeImploder;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.Tokens;

public abstract class TreeTokenizer<Tree>
implements ITokenizer<TreeImploder.SubTree<Tree>, ITokens> {
    @Override
    public TokenizeResult<ITokens> tokenize(JSGLR2Request request, TreeImploder.SubTree<Tree> implodeIntermediateResult, ITokens previousResult) {
        Tokens tokens = new Tokens(request.input, request.fileName);
        this.tokenize(tokens, implodeIntermediateResult);
        return new TokenizeResult<ITokens>(tokens);
    }

    protected void tokenize(Tokens tokens, TreeImploder.SubTree<Tree> tree) {
        tokens.makeStartToken();
        this.tokenTreeBinding(tokens.startToken(), tree.tree);
        SubTree res = this.tokenizeInternal(tokens, tree, Position.START_POSITION);
        tokens.makeEndToken(res.endPosition);
        this.tokenTreeBinding(tokens.endToken(), res.tree);
    }

    private SubTree tokenizeInternal(Tokens tokens, TreeImploder.SubTree<Tree> tree, Position startPosition) {
        if (tree.production != null && !tree.production.isContextFree() || tree.isCharacterTerminal) {
            if (tree.width > 0) {
                Position endPosition = startPosition.step(tokens.getInput(), tree.width);
                IToken token = tokens.makeToken(startPosition, endPosition, tree.production);
                this.tokenTreeBinding(token, tree.tree);
                return new SubTree(tree, token, token, endPosition);
            }
            return new SubTree(tree, null, null, startPosition);
        }
        IToken leftToken = null;
        IToken rightToken = null;
        Position pivotPosition = startPosition;
        for (TreeImploder.SubTree child : tree.children) {
            if (tree.isAmbiguous) {
                pivotPosition = startPosition;
            }
            SubTree subTree = this.tokenizeInternal(tokens, child, pivotPosition);
            if (subTree.tree == null) {
                if (subTree.leftToken != null) {
                    this.tokenTreeBinding(subTree.leftToken, tree.tree);
                }
                if (subTree.rightToken != null) {
                    this.tokenTreeBinding(subTree.rightToken, tree.tree);
                }
            }
            if (leftToken == null) {
                leftToken = subTree.leftToken;
            }
            if (subTree.rightToken != null) {
                rightToken = subTree.rightToken;
            }
            pivotPosition = subTree.endPosition;
        }
        if (leftToken == null) {
            assert (rightToken == null);
            leftToken = rightToken = tokens.makeToken(startPosition, pivotPosition, tree.production);
            this.tokenTreeBinding(leftToken, tree.tree);
        }
        return new SubTree(tree, leftToken, rightToken, pivotPosition);
    }

    protected abstract void configure(Tree var1, String var2, IToken var3, IToken var4);

    protected abstract void configureInjection(ISymbol var1, Tree var2, boolean var3);

    protected abstract void tokenTreeBinding(IToken var1, Tree var2);

    class SubTree {
        public final Tree tree;
        public final IToken leftToken;
        public final IToken rightToken;
        public final Position endPosition;

        SubTree(TreeImploder.SubTree<Tree> tree, IToken leftToken, IToken rightToken, Position endPosition) {
            this.tree = tree.tree;
            this.leftToken = leftToken;
            this.rightToken = rightToken;
            this.endPosition = endPosition;
            assert (leftToken != null ^ rightToken == null) : "Both tokens should be either null, or not null";
            if (tree.tree != null) {
                assert (leftToken != null && rightToken != null) : "All AST nodes should have tokens, even if it's empty";
                if (tree.isInjection) {
                    TreeTokenizer.this.configureInjection(tree.production.lhs(), tree.tree, tree.production.isBracket());
                } else {
                    String sort = tree.production == null ? null : tree.production.sort();
                    TreeTokenizer.this.configure(tree.tree, sort, leftToken, rightToken);
                }
            }
        }
    }
}

