/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental.diff;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.spoofax.jsglr2.incremental.EditorUpdate;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalDerivation;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForestManager;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalSkippedNode;
import org.spoofax.jsglr2.inputstack.incremental.IIncrementalInputStack;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.stack.IStackNode;

public class ProcessUpdates<StackNode extends IStackNode, ParseState extends AbstractParseState<IIncrementalInputStack, StackNode>> {
    private final ParserObserving<IncrementalParseForest, IncrementalDerivation, IncrementalParseNode, StackNode, ParseState> observing = new ParserObserving();
    private final IncrementalParseForestManager<StackNode, ParseState> parseForestManager;

    public ProcessUpdates(IncrementalParseForestManager<StackNode, ParseState> parseForestManager) {
        this.parseForestManager = parseForestManager;
    }

    public IncrementalParseForest processUpdates(String previousInput, IncrementalParseForest previous, EditorUpdate ... editorUpdates) {
        return this.processUpdates(previousInput, previous, Arrays.asList(editorUpdates));
    }

    public IncrementalParseForest processUpdates(String previousInput, IncrementalParseForest previous, List<EditorUpdate> editorUpdates) {
        if (editorUpdates.size() == 0) {
            return previous;
        }
        if (editorUpdates.size() == 1) {
            EditorUpdate editorUpdate = editorUpdates.get(0);
            if (editorUpdate.deletedStart == 0 && editorUpdate.deletedEnd == previous.width()) {
                return this.getParseNodeFromString(editorUpdate.inserted);
            }
        }
        LinkedList<EditorUpdate> linkedUpdates = new LinkedList<EditorUpdate>(editorUpdates);
        return this.processUpdates(previousInput, previous, 0, linkedUpdates);
    }

    private IncrementalParseForest processUpdates(String previousInput, IncrementalParseForest currentForest, int currentOffset, LinkedList<EditorUpdate> updates) {
        if (currentForest.isTerminal()) {
            if (currentForest instanceof IncrementalSkippedNode) {
                return this.processUpdates(previousInput, (IncrementalParseForest)this.getParseNodeFromString(previousInput.substring(currentOffset, currentOffset + currentForest.width())), currentOffset, updates);
            }
            EditorUpdate update = updates.getFirst();
            int deletedStartOffset = update.deletedStart;
            int deletedEndOffset = update.deletedEnd;
            String inserted = update.inserted;
            EditorUpdate.Type type = update.type;
            if (type == EditorUpdate.Type.INSERTION) {
                if (deletedStartOffset == 0 && currentOffset == deletedEndOffset) {
                    updates.removeFirst();
                    return this.newParseNodeFromChildren(this.getParseNodeFromString(inserted), currentForest);
                }
                if (deletedStartOffset != 0 && currentOffset == deletedStartOffset - currentForest.width()) {
                    updates.removeFirst();
                    return this.newParseNodeFromChildren(currentForest, this.getParseNodeFromString(inserted));
                }
                return currentForest;
            }
            if (type == EditorUpdate.Type.REPLACEMENT && currentOffset == deletedStartOffset) {
                if (currentOffset == deletedEndOffset - currentForest.width()) {
                    updates.removeFirst();
                }
                return this.getParseNodeFromString(inserted);
            }
            if (deletedStartOffset <= currentOffset && currentOffset < deletedEndOffset) {
                if (currentOffset == deletedEndOffset - currentForest.width()) {
                    updates.removeFirst();
                }
                return null;
            }
            return currentForest;
        }
        IncrementalParseForest[] parseForests = (IncrementalParseForest[])((IncrementalParseNode)currentForest).getFirstDerivation().parseForests().clone();
        int i = 0;
        while (i < parseForests.length) {
            if (updates.isEmpty()) break;
            if (currentOffset >= updates.getFirst().deletedEnd && currentOffset > 0) {
                updates.removeFirst();
            }
            if (updates.isEmpty()) break;
            EditorUpdate update = updates.getFirst();
            int deletedStartOffset = update.deletedStart;
            int deletedEndOffset = update.deletedEnd;
            String inserted = update.inserted;
            EditorUpdate.Type type = update.type;
            IncrementalParseForest parseForest = parseForests[i];
            int nextOffset = currentOffset + parseForest.width();
            if (type == EditorUpdate.Type.REPLACEMENT && deletedStartOffset == currentOffset && nextOffset <= deletedEndOffset && currentOffset < nextOffset) {
                parseForests[i] = this.getParseNodeFromString(inserted);
            } else if (type == EditorUpdate.Type.REPLACEMENT && deletedStartOffset <= currentOffset && nextOffset <= deletedEndOffset) {
                parseForests[i] = null;
            } else if (deletedStartOffset <= nextOffset && currentOffset <= deletedEndOffset) {
                parseForests[i] = this.processUpdates(previousInput, parseForest, currentOffset, updates);
            }
            currentOffset = nextOffset;
            ++i;
        }
        return this.newParseNodeFromChildren(parseForests);
    }

    private IncrementalParseNode newParseNodeFromChildren(IncrementalParseForest ... newChildren) {
        IncrementalParseForest[] filtered = (IncrementalParseForest[])Arrays.stream(newChildren).filter(Objects::nonNull).toArray(IncrementalParseForest[]::new);
        if (filtered.length == 0) {
            return null;
        }
        return this.parseForestManager.createChangedParseNode(filtered);
    }

    public IncrementalParseNode getParseNodeFromString(String inputString) {
        int[] chars = inputString.codePoints().toArray();
        IncrementalParseForest[] parseForests = this.parseForestManager.parseForestsArray(chars.length);
        int i = 0;
        while (i < chars.length) {
            parseForests[i] = this.parseForestManager.createCharacterNode(chars[i]);
            ++i;
        }
        return this.parseForestManager.createChangedParseNode(parseForests);
    }
}

